/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.oasisopen.jmi1.RefContainer;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.base.cci2.ExportItemResult;
import org.opencrx.kernel.base.jmi1.ExportItemResult;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.ModelHelper;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.cci.Multiplicity;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.base.text.conversion.XMLEncoder;
import org.openmdx.kernel.exception.BasicException;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class XmlExporter
extends AbstractImpl {
    public static final String MIME_TYPE_XML = "application/xml";
    public static final String MIME_TYPE_EXCEL = "application/x-excel";
    public static final String FILE_EXT_XLS = ".xls";
    public static final String FILE_EXT_XML = ".xml";
    public static final String FILE_EXT_BIN = ".bin";
    public static final String FILE_EXT_ZIP = ".zip";
    protected static final int MAX_LEVELS = 5;

    public static void register() {
        XmlExporter.registerImpl(new XmlExporter());
    }

    public static XmlExporter getInstance() throws ServiceException {
        return XmlExporter.getInstance(XmlExporter.class);
    }

    protected XmlExporter() {
    }

    public void exportItem(OutputStream out, PrintStream ps, List<TraversedObject> startPoints, List<TraversedObject> allExportedObjects, List<TraversedObject> allReferencedObjects, ExportParams params) throws IOException, ServiceException {
        if (!startPoints.isEmpty()) {
            ArrayList<TraversedObject> referencedObjects = new ArrayList<TraversedObject>();
            for (TraversedObject startPoint : startPoints) {
                if (startPoint.getLevel() >= 5 || allExportedObjects.contains(startPoint)) continue;
                boolean isMultiFileExport = out instanceof ZipOutputStream;
                if (isMultiFileExport) {
                    ((ZipOutputStream)out).putNextEntry(new ZipEntry("data-" + params.getNextEntryId() + FILE_EXT_XML));
                }
                String qualifiedModelName = startPoint.getObject().refGetPath().get(0);
                String namespace = qualifiedModelName.substring(0, qualifiedModelName.lastIndexOf(":"));
                String modelName = qualifiedModelName.substring(qualifiedModelName.lastIndexOf(":") + 1);
                ObjectExporter objectExporter = new ObjectExporter(ps, params, allExportedObjects);
                objectExporter.export(startPoint, startPoint.getObject().refGetPath().getParent().getLastSegment().toString(), "xri://+resource/" + namespace.replace(':', '/') + "/" + modelName + "/xmi1/" + modelName + ".xsd");
                for (TraversedObject o : objectExporter.getReferencedObjects()) {
                    if (!referencedObjects.contains(o)) {
                        referencedObjects.add(o);
                    }
                    if (allReferencedObjects.contains(o)) continue;
                    allReferencedObjects.add(o);
                }
            }
            Iterator i = referencedObjects.iterator();
            while (i.hasNext()) {
                TraversedObject object = (TraversedObject)i.next();
                if (object.getObject().refGetPath().size() > 5) continue;
                i.remove();
            }
            this.exportItem(out, ps, referencedObjects, allExportedObjects, allReferencedObjects, params);
        }
    }

    public ExportItemResult exportItem(RefObject_1_0 object, String referenceFilter, String itemMimeType) throws ServiceException {
        try {
            String contentMimeType;
            Object pi;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
            ExportParams exportParams = new ExportParams();
            ArrayList<TraversedObject> roots = new ArrayList<TraversedObject>();
            roots.add(new TraversedObject(object, 1));
            if (referenceFilter != null) {
                if (referenceFilter.indexOf("$") > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(referenceFilter.substring(0, referenceFilter.indexOf("$")), "\t\n ;,", false);
                    while (tokenizer.hasMoreTokens()) {
                        roots.add(new TraversedObject((RefObject_1_0)pm.getObjectById((Object)new Path(tokenizer.nextToken())), 1));
                    }
                    referenceFilter = referenceFilter.substring(referenceFilter.indexOf("$") + 1);
                }
                String options = null;
                if (referenceFilter.indexOf("!") > 0) {
                    options = referenceFilter.substring(referenceFilter.indexOf("!") + 1);
                    referenceFilter = referenceFilter.substring(0, referenceFilter.indexOf("!"));
                }
                StringTokenizer referenceFilterTokenizer = new StringTokenizer(referenceFilter, "\t\n ;,", false);
                while (referenceFilterTokenizer.hasMoreTokens()) {
                    Object referenceName = referenceFilterTokenizer.nextToken();
                    if (!((String)referenceName).endsWith("]")) {
                        referenceName = (String)referenceName + "[1]";
                    }
                    exportParams.getReferenceFilter().add((String)referenceName);
                }
                if (options != null) {
                    StringTokenizer optionsTokenizer = new StringTokenizer(options, "\t\n ,", false);
                    while (optionsTokenizer.hasMoreTokens()) {
                        String option = optionsTokenizer.nextToken();
                        String optionName = null;
                        ArrayList<String> optionParams = new ArrayList<String>();
                        if (option.indexOf("[") > 0) {
                            optionName = option.substring(0, option.indexOf("["));
                            StringTokenizer optionParamsTokenizer = new StringTokenizer(option.substring(option.indexOf("[") + 1), ";]", false);
                            while (optionParamsTokenizer.hasMoreTokens()) {
                                optionParams.add(optionParamsTokenizer.nextToken());
                            }
                        } else {
                            optionName = option;
                        }
                        exportParams.getOptions().put(optionName, optionParams);
                    }
                }
            }
            exportParams.setMimeType(itemMimeType == null ? MIME_TYPE_XML : itemMimeType);
            ArrayList<TraversedObject> allExportedObjects = new ArrayList<TraversedObject>();
            ArrayList<TraversedObject> allReferencedObjects = new ArrayList<TraversedObject>();
            boolean isMultiFileExport = exportParams.getMimeType().equals(MIME_TYPE_XML);
            OutputStream out = isMultiFileExport ? new ZipOutputStream(new NullOutputStream()) : new NullOutputStream();
            PrintStream ps = new PrintStream(out);
            this.exportItem(out, ps, roots, allExportedObjects, allReferencedObjects, exportParams);
            Iterator i = allReferencedObjects.iterator();
            while (i.hasNext()) {
                TraversedObject pi2 = (TraversedObject)i.next();
                if (pi2.getObject().refGetPath().size() > 5) continue;
                i.remove();
            }
            ArrayList<TraversedObject> nonCompositeStartingPoints = new ArrayList<TraversedObject>(allReferencedObjects);
            Iterator i2 = nonCompositeStartingPoints.iterator();
            block9: while (i2.hasNext()) {
                pi = (TraversedObject)i2.next();
                for (TraversedObject pj : allReferencedObjects) {
                    if (((TraversedObject)pi).getObject().refGetPath().size() <= pj.getObject().refGetPath().size() || !((TraversedObject)pi).getObject().refGetPath().startsWith(pj.getObject().refGetPath())) continue;
                    i2.remove();
                    continue block9;
                }
            }
            Iterator i3 = nonCompositeStartingPoints.iterator();
            block11: while (i3.hasNext()) {
                pi = (TraversedObject)i3.next();
                for (TraversedObject pj : allExportedObjects) {
                    if (((TraversedObject)pi).getObject().refGetPath().size() <= pj.getObject().refGetPath().size() || !((TraversedObject)pi).getObject().refGetPath().startsWith(pj.getObject().refGetPath())) continue;
                    i3.remove();
                    continue block11;
                }
            }
            nonCompositeStartingPoints.removeAll(roots);
            QuotaByteArrayOutputStream bs = new QuotaByteArrayOutputStream(XmlExporter.class.getName());
            out = isMultiFileExport ? new ZipOutputStream(bs) : bs;
            ps = new PrintStream(out, false, "UTF-8");
            exportParams.getContext().keySet().retainAll(Arrays.asList("template"));
            exportParams.resetEntryId();
            allExportedObjects = new ArrayList<TraversedObject>();
            this.exportItem(out, ps, roots, allExportedObjects, new ArrayList<TraversedObject>(), exportParams);
            this.exportItem(out, ps, nonCompositeStartingPoints, allExportedObjects, new ArrayList<TraversedObject>(), exportParams);
            for (Object e : exportParams.getContext().values()) {
                if (!(e instanceof HSSFWorkbook)) continue;
                try {
                    ((HSSFWorkbook)e).write((OutputStream)ps);
                }
                catch (IOException e2) {
                    throw new ServiceException((Exception)e2);
                }
            }
            ps.close();
            String string = contentMimeType = isMultiFileExport ? "application/zip" : exportParams.getMimeType();
            String string2 = "Export" + (contentMimeType.equals("application/zip") ? FILE_EXT_ZIP : (contentMimeType.equals(MIME_TYPE_EXCEL) ? FILE_EXT_XLS : FILE_EXT_BIN));
            return (ExportItemResult)Structures.create(ExportItemResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ExportItemResult.Member.item, (Object)bs.toByteArray()), Datatypes.member((Enum)ExportItemResult.Member.itemMimeType, (Object)contentMimeType), Datatypes.member((Enum)ExportItemResult.Member.itemName, (Object)string2), Datatypes.member((Enum)ExportItemResult.Member.status, (Object)0), Datatypes.member((Enum)ExportItemResult.Member.statusMessage, null)});
        }
        catch (IOException e) {
            throw new ServiceException((Exception)e);
        }
    }

    protected Collection<?> getContent(TraversedObject object, String referenceName) {
        return ((RefContainer)object.getObject().refGetValue(referenceName)).refGetAll(null);
    }

    class ObjectExporter {
        final Set<String> NOT_EXPORTED_ATTRIBUTES = new HashSet<String>(Arrays.asList("object_instanceof"));
        final List<TraversedObject> referencedObjects;
        final List<TraversedObject> exportedObjects;
        final ExportParams params;
        final PrintStream out;

        public ObjectExporter(PrintStream out, ExportParams params, List<TraversedObject> exportedObjects) {
            this.out = out;
            this.params = params;
            this.referencedObjects = new ArrayList<TraversedObject>();
            this.exportedObjects = exportedObjects;
        }

        public List<TraversedObject> getReferencedObjects() {
            return this.referencedObjects;
        }

        public List<TraversedObject> getExportedObjects() {
            return this.exportedObjects;
        }

        public String getQualifierName(RefObject_1_0 object) throws ServiceException {
            Model_1_0 model = Model_1Factory.getModel();
            ModelElement_1_0 objectClass = model.getElement((Object)object.refClass().refMofId());
            String qualifierName = null;
            if (objectClass.objGetValue("compositeReference") != null) {
                ModelElement_1_0 compReference = model.getElement((Object)((Path)objectClass.objGetValue("compositeReference")).getLastSegment().toString());
                ModelElement_1_0 associationEnd = model.getElement((Object)compReference.getReferencedEnd().getLastSegment().toString());
                qualifierName = (String)associationEnd.objGetList("qualifierName").get(0);
            } else if ("org:openmdx:base:Authority".equals(objectClass.getQualifiedName())) {
                qualifierName = "name";
            } else {
                throw new ServiceException("DefaultDomain", -2, "no composite reference found for class.", new BasicException.Parameter[]{new BasicException.Parameter("class", (Object)objectClass)});
            }
            return qualifierName;
        }

        public void export(TraversedObject object, String referenceName, String schemaString) throws ServiceException {
            ContentHandler contentHandler = null;
            if (XmlExporter.MIME_TYPE_XML.equals(this.params.getMimeType())) {
                contentHandler = new XMLContentHandler("http://www.w3.org/2001/XMLSchema-instance", schemaString);
            } else if (XmlExporter.MIME_TYPE_EXCEL.equals(this.params.getMimeType())) {
                contentHandler = new ExcelContentHandler(this.params.getContext());
            } else {
                throw new ServiceException("DefaultDomain", -2, "Unsupported mime type. Unable to export item.", new BasicException.Parameter[]{new BasicException.Parameter("mimetype", (Object)this.params.getMimeType())});
            }
            contentHandler.startTraversal(object);
            this.exportObject(object, referenceName, contentHandler);
            contentHandler.endTraversal(object);
        }

        private void exportObject(TraversedObject object, String reference, ContentHandler contentHandler) throws ServiceException {
            if (!this.exportedObjects.contains(object)) {
                Model_1_0 model = Model_1Factory.getModel();
                String objectType = object.getObject().refClass().refMofId();
                String qualifierName = this.getQualifierName(object.getObject());
                contentHandler.startObject(object, object.getObject().refGetPath().getLastSegment().toString(), qualifierName, objectType);
                contentHandler.featureComplete(object, reference);
                Map references = model.getElement((Object)objectType).objGetMap("reference");
                for (ModelElement_1_0 featureDef : references.values()) {
                    boolean matches;
                    boolean referenceIsShared;
                    ModelElement_1_0 referencedEnd = model.getElement((Object)featureDef.getReferencedEnd());
                    boolean referenceIsComposite = model.isReferenceType((Object)featureDef) && "composite".equals(referencedEnd.getAggregation());
                    boolean bl = referenceIsShared = model.isReferenceType((Object)featureDef) && "shared".equals(referencedEnd.getAggregation());
                    if (!referenceIsComposite && !referenceIsShared) continue;
                    String referenceName = featureDef.getName();
                    Set<String> referenceFilter = this.params.getReferenceFilter();
                    boolean bl2 = matches = referenceFilter == null;
                    if (!matches) {
                        String qualifiedReferenceName = featureDef.getQualifiedName();
                        for (int i = object.getLevel(); i < 5; ++i) {
                            boolean bl3 = matches = referenceFilter.contains(referenceName + "[" + i + "]") || referenceFilter.contains(qualifiedReferenceName + "[" + i + "]");
                            if (matches) break;
                        }
                    }
                    if (!matches) continue;
                    Collection<?> content = XmlExporter.this.getContent(object, referenceName);
                    contentHandler.startReference(referenceName);
                    for (Object contained : content) {
                        if (!(contained instanceof RefObject_1_0)) continue;
                        this.exportObject(new TraversedObject((RefObject_1_0)contained, object.getLevel()), referenceName, contentHandler);
                    }
                    contentHandler.endReference(referenceName);
                }
                contentHandler.endObject(object, objectType);
                this.exportedObjects.add(object);
            }
        }

        class XMLContentHandler
        implements ContentHandler {
            final Model_1_0 model = Model_1Factory.getModel();
            final String schemaInstance;
            final String schemaLocation;
            private final XMLWriter xmlWriter;

            public XMLContentHandler(String schemaInstance, String schemaLocation) {
                this.schemaInstance = schemaInstance;
                this.schemaLocation = schemaLocation;
                this.xmlWriter = new XMLWriter(ObjectExporter.this.out);
            }

            private String toXML(Object elementName) {
                return ((String)elementName).replace(':', '.');
            }

            private String toSimpleQualifiedName(String qualifiedName) {
                return qualifiedName.substring(qualifiedName.lastIndexOf(58) + 1);
            }

            @Override
            public void endObject(TraversedObject object, String qualifiedName) throws ServiceException {
                this.xmlWriter.endElement("", "", "_content", true);
                String endElem = this.toXML(qualifiedName);
                this.xmlWriter.endElement("", "", endElem, true);
            }

            @Override
            public void endReference(String reference) throws ServiceException {
                this.xmlWriter.endElement("", "", this.toSimpleQualifiedName(reference), true);
            }

            @Override
            public boolean featureComplete(TraversedObject object, String referenceName) throws ServiceException {
                Map tags = null;
                ModelElement_1_0 objectClass = this.model.getElement((Object)object.getObject().refClass().refMofId());
                this.xmlWriter.startElement("", "", "_object", new XMLWriter.Attributes());
                Map modelAttributes = this.model.getAttributeDefs(objectClass, true, true);
                for (String attributeName : modelAttributes.keySet()) {
                    if (objectClass == null || ObjectExporter.this.NOT_EXPORTED_ATTRIBUTES.contains(attributeName)) continue;
                    ModelElement_1_0 attributeDef = (ModelElement_1_0)modelAttributes.get(attributeName);
                    Object attributeValue = null;
                    try {
                        attributeValue = object.getObject().refGetValue(attributeName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (attributeDef == null || attributeValue == null) continue;
                    Multiplicity multiplicity = ModelHelper.getMultiplicity((ModelElement_1_0)attributeDef);
                    boolean isMultiValued = multiplicity == Multiplicity.SET || multiplicity == Multiplicity.LIST || multiplicity == Multiplicity.SPARSEARRAY || multiplicity == Multiplicity.MAP;
                    boolean needsPosition = multiplicity == Multiplicity.SPARSEARRAY;
                    String elementTag = this.toSimpleQualifiedName(attributeDef.getQualifiedName());
                    ArrayList<Object> attributeValues = new ArrayList<Object>();
                    if (attributeValue instanceof Collection) {
                        try {
                            attributeValues.addAll((Collection)attributeValue);
                        }
                        catch (Exception exception) {}
                    } else {
                        attributeValues.add(attributeValue);
                    }
                    if (attributeValues.isEmpty()) continue;
                    this.xmlWriter.startElement("", "", elementTag, new XMLWriter.Attributes());
                    int valueIndex = 0;
                    for (Object value : attributeValues) {
                        String t;
                        Object v;
                        Object stringValue = null;
                        ModelElement_1_0 attributeType = this.model.getDereferencedType((Object)attributeDef.getType());
                        String typeName = attributeType.getQualifiedName();
                        if ("org:w3c:dateTime".equals(typeName)) {
                            v = DateTimeFormat.BASIC_UTC_FORMAT.format((Date)value);
                            t = ((String)v).substring(0, 4) + "-" + ((String)v).substring(4, 6) + "-" + ((String)v).substring(6, 11) + ":" + ((String)v).substring(11, 13) + ":" + ((String)v).substring(13, 20);
                            stringValue = t;
                        } else if ("org:w3c:date".equals(typeName)) {
                            v = (XMLGregorianCalendar)value;
                            t = ((XMLGregorianCalendar)v).getYear() + "-" + (Serializable)(((XMLGregorianCalendar)v).getMonth() < 10 ? "0" + ((XMLGregorianCalendar)v).getMonth() : Integer.valueOf(((XMLGregorianCalendar)v).getMonth())) + "-" + (Serializable)(((XMLGregorianCalendar)v).getDay() < 10 ? "0" + ((XMLGregorianCalendar)v).getDay() : Integer.valueOf(((XMLGregorianCalendar)v).getDay()));
                            stringValue = t;
                        } else if ("org:w3c:long".equals(typeName) || "org:w3c:integer".equals(typeName) || "org:w3c:short".equals(typeName)) {
                            value = new Long(((Number)value).longValue());
                            stringValue = value.toString();
                        } else if ("org:w3c:binary".equals(typeName)) {
                            stringValue = value instanceof byte[] ? Base64.encode((byte[])((byte[])value)) : value.toString();
                        } else if (value instanceof RefObject_1_0) {
                            RefObject_1_0 obj = (RefObject_1_0)value;
                            stringValue = obj.refGetPath().toXRI();
                            TraversedObject o = new TraversedObject(obj, object.getLevel() + 1);
                            if (!ObjectExporter.this.referencedObjects.contains(o)) {
                                ObjectExporter.this.referencedObjects.add(o);
                            }
                        } else {
                            stringValue = value.toString();
                        }
                        XMLWriter.Attributes atts = new XMLWriter.Attributes();
                        if (needsPosition) {
                            atts.addCDATA("_position", String.valueOf(valueIndex));
                        }
                        if (isMultiValued) {
                            this.xmlWriter.startElement("", "", "_item", atts);
                        }
                        this.xmlWriter.characters(((String)stringValue).toCharArray(), 0, ((String)stringValue).length());
                        if (isMultiValued) {
                            this.xmlWriter.endElement("", "", "_item", false);
                        }
                        ++valueIndex;
                    }
                    this.xmlWriter.endElement("", "", elementTag, isMultiValued);
                    if (tags == null || tags.get(attributeName) == null) continue;
                    this.xmlWriter.comment((String)tags.get(attributeName));
                }
                this.xmlWriter.endElement("", "", "_object", true);
                this.xmlWriter.startElement("", "", "_content", new XMLWriter.Attributes());
                return true;
            }

            @Override
            public boolean startObject(TraversedObject object, String id, String qualifierName, String qualifiedName) throws ServiceException {
                XMLWriter.Attributes atts = new XMLWriter.Attributes();
                atts.addCDATA(qualifierName, object.getObject().refGetPath().getLastSegment().toString());
                this.xmlWriter.startElement("", "", this.toXML(qualifiedName), atts);
                return true;
            }

            @Override
            public boolean startReference(String name) throws ServiceException {
                this.xmlWriter.startElement("", "", this.toSimpleQualifiedName(name), new XMLWriter.Attributes());
                return true;
            }

            @Override
            public void endTraversal(TraversedObject object) throws ServiceException {
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object.getObject());
                for (int i = object.getObject().refGetPath().size() - 2; i > 0; i -= 2) {
                    RefObject_1_0 parent = (RefObject_1_0)pm.getObjectById((Object)object.getObject().refGetPath().getPrefix(i));
                    String qualifiedTypeName = parent.refClass().refMofId();
                    this.xmlWriter.endElement("", "", object.getObject().refGetPath().get(i), true);
                    this.xmlWriter.endElement("", "", "_content", true);
                    this.xmlWriter.endElement("", "", this.toXML(qualifiedTypeName), true);
                }
                this.xmlWriter.endDocument();
            }

            @Override
            public void startTraversal(TraversedObject object) throws ServiceException {
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object.getObject());
                this.xmlWriter.startDocument();
                for (int i = 1; i < object.getObject().refGetPath().size(); i += 2) {
                    RefObject_1_0 parent = (RefObject_1_0)pm.getObjectById((Object)object.getObject().refGetPath().getPrefix(i));
                    String qualifiedTypeName = parent.refClass().refMofId();
                    String qualifierName = ObjectExporter.this.getQualifierName(parent);
                    XMLWriter.Attributes atts = new XMLWriter.Attributes();
                    atts.addCDATA(qualifierName, parent.refGetPath().getLastSegment().toString());
                    atts.addCDATA("_operation", "null");
                    if (qualifiedTypeName.equals("org:openmdx:base:Authority")) {
                        atts.addCDATA("xmlns:xsi", this.schemaInstance);
                        atts.addCDATA("xsi:noNamespaceSchemaLocation", this.schemaLocation);
                    }
                    this.xmlWriter.startElement("", "", this.toXML(qualifiedTypeName), atts);
                    this.xmlWriter.startElement("", "", "_object", new XMLWriter.Attributes());
                    this.xmlWriter.endElement("", "", "_object", true);
                    this.xmlWriter.startElement("", "", "_content", new XMLWriter.Attributes());
                    this.xmlWriter.startElement("", "", object.getObject().refGetPath().get(i), new XMLWriter.Attributes());
                }
            }
        }

        class ExcelContentHandler
        implements ContentHandler {
            private static final int MAX_OBJECTS = 2000;
            private final Model_1_0 model = Model_1Factory.getModel();
            private HSSFWorkbook wb = null;
            private HSSFSheet sheet = null;
            private HSSFSheet metainf = null;
            private HSSFCellStyle cellStyleHidden = null;
            private int objectLimit;
            private int objectCount;

            public ExcelContentHandler(Map<String, Object> context) {
                this.wb = (HSSFWorkbook)context.get("wb");
                if (this.wb == null) {
                    HSSFWorkbook wb = null;
                    if (context.get("template") != null) {
                        Object template = context.get("template");
                        try {
                            Document templateDocument;
                            DocumentRevision revision;
                            if (template instanceof InputStream) {
                                wb = new HSSFWorkbook((InputStream)template, true);
                            } else if (template instanceof Document && (revision = (templateDocument = (Document)template).getHeadRevision()) instanceof MediaContent) {
                                BinaryLargeObject content = ((MediaContent)revision).getContent();
                                wb = new HSSFWorkbook(content.getContent(), true);
                                QuotaByteArrayOutputStream bos = new QuotaByteArrayOutputStream(XmlExporter.class.getName());
                                wb.write((OutputStream)bos);
                                bos.close();
                                context.put("template", bos.toInputStream());
                            }
                        }
                        catch (Exception e) {
                            ServiceException e0 = new ServiceException(e);
                            e0.log();
                        }
                    }
                    if (wb == null) {
                        wb = new HSSFWorkbook();
                    }
                    this.wb = wb;
                    context.put("wb", this.wb);
                }
                this.cellStyleHidden = this.wb.createCellStyle();
                this.cellStyleHidden.setHidden(false);
                this.objectCount = 0;
                this.metainf = this.wb.getSheet("META-INF");
                HSSFCell mCell = this.metainf == null || this.metainf.getRow(1) == null ? null : this.metainf.getRow(1).getCell(this.getColumnIndex(this.metainf, "META-INF", "MaxObjects"));
                this.objectLimit = mCell == null ? 2000 : new Double(mCell.getNumericCellValue()).intValue();
            }

            private int getColumnIndex(HSSFSheet sheet, String sheetName, String attributeName) {
                List<String> attributeNames;
                HSSFRow heading = sheet.getRow(0);
                int num = 0;
                Iterator i = heading.cellIterator();
                while (i.hasNext()) {
                    Cell cell = (Cell)i.next();
                    if (attributeName.equals(cell.getStringCellValue())) {
                        return cell.getColumnIndex();
                    }
                    ++num;
                }
                HSSFCell cell = heading.createCell(num);
                cell.setCellValue((RichTextString)new HSSFRichTextString(attributeName));
                if (ObjectExporter.this.params.getOptions().get(sheetName) != null && !(attributeNames = ObjectExporter.this.params.getOptions().get(sheetName)).isEmpty() && !attributeNames.contains(attributeName)) {
                    sheet.setColumnWidth(num, 0);
                }
                return num;
            }

            private Map<String, ModelElement_1_0> getAttributes(TraversedObject object) throws ServiceException {
                Map attributes = this.model.getElement((Object)object.getObject().refClass().refMofId()).objGetMap("attribute");
                return attributes;
            }

            private int getMaxValueSize(TraversedObject object) throws ServiceException {
                int maxIndex = 0;
                for (String attributeName : this.getAttributes(object).keySet()) {
                    if (ObjectExporter.this.NOT_EXPORTED_ATTRIBUTES.contains(attributeName)) continue;
                    Object value = null;
                    try {
                        value = object.getObject().refGetValue(attributeName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (value instanceof Collection) {
                        maxIndex = Math.max(maxIndex, ((Collection)value).size());
                        continue;
                    }
                    if (value == null) continue;
                    maxIndex = Math.max(maxIndex, 1);
                }
                return maxIndex;
            }

            @Override
            public void endObject(TraversedObject object, String qualifiedName) throws ServiceException {
            }

            @Override
            public void endReference(String reference) throws ServiceException {
                this.sheet = null;
            }

            @Override
            public void endTraversal(TraversedObject object) throws ServiceException {
            }

            @Override
            public boolean featureComplete(TraversedObject object, String referenceName) throws ServiceException {
                ++this.objectCount;
                if (object.getObject().refGetPath().size() > 5) {
                    Object sheetName = referenceName;
                    if (((String)sheetName).length() > 0) {
                        sheetName = Character.toUpperCase(((String)sheetName).charAt(0)) + ((String)sheetName).substring(1);
                    }
                    this.sheet = this.wb.getSheet((String)sheetName);
                    if (this.sheet == null) {
                        HSSFName namedCell2;
                        this.sheet = this.wb.createSheet((String)sheetName);
                        String cellName = (String)sheetName + ".DATA";
                        try {
                            namedCell2 = this.wb.createName();
                            namedCell2.setNameName(cellName);
                            namedCell2.setRefersToFormula((String)sheetName + "!$A$2:$CY$65536");
                        }
                        catch (Exception namedCell2) {
                            // empty catch block
                        }
                        try {
                            namedCell2 = this.wb.createName();
                            namedCell2.setNameName((String)sheetName + ".COLUMN");
                            namedCell2.setRefersToFormula((String)sheetName + "!$A$1:$CY$1");
                        }
                        catch (Exception namedCell3) {
                            // empty catch block
                        }
                        this.sheet.createRow(0);
                        if (ObjectExporter.this.params.getOptions().get(sheetName) != null) {
                            List<String> attributeNames = ObjectExporter.this.params.getOptions().get(sheetName);
                            for (String attributeName : attributeNames) {
                                this.getColumnIndex(this.sheet, (String)sheetName, attributeName);
                            }
                        }
                    }
                    int maxIndex = this.getMaxValueSize(object);
                    String xri = object.getObject().refGetPath().toXRI();
                    HSSFRichTextString parentXri = new HSSFRichTextString(object.getObject().refGetPath().getParent().getParent().toXRI());
                    HSSFRichTextString objectId = new HSSFRichTextString(object.getObject().refGetPath().getLastSegment().toString());
                    HSSFRichTextString objectClass = new HSSFRichTextString(object.getObject().refClass().refMofId());
                    for (int i = 0; i < maxIndex; ++i) {
                        HSSFRow row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
                        HSSFCell cell = row.createCell(this.getColumnIndex(this.sheet, (String)sheetName, "XRI"));
                        cell.setCellValue((RichTextString)new HSSFRichTextString(xri + (String)(i > 0 ? "*" + i : "")));
                        cell = row.createCell(this.getColumnIndex(this.sheet, (String)sheetName, "XRI.PARENT"));
                        cell.setCellValue((RichTextString)parentXri);
                        cell = row.createCell(this.getColumnIndex(this.sheet, (String)sheetName, "ID"));
                        cell.setCellValue((RichTextString)objectId);
                        cell = row.createCell(this.getColumnIndex(this.sheet, (String)sheetName, "IDX"));
                        cell.setCellValue((double)i);
                        cell = row.createCell(this.getColumnIndex(this.sheet, (String)sheetName, "object_class"));
                        cell.setCellValue((RichTextString)objectClass);
                        Map<String, ModelElement_1_0> attributes = this.getAttributes(object);
                        for (String attributeName : attributes.keySet()) {
                            Object value;
                            Object v = null;
                            try {
                                v = object.getObject().refGetValue(attributeName);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ArrayList<Object> values = new ArrayList<Object>();
                            if (v instanceof Collection) {
                                try {
                                    values.addAll((Collection)v);
                                }
                                catch (Exception exception) {}
                            } else if (v != null) {
                                values.add(v);
                            }
                            Object object2 = value = i < values.size() ? (Object)values.get(i) : null;
                            if (ObjectExporter.this.NOT_EXPORTED_ATTRIBUTES.contains(attributeName) || value == null) continue;
                            cell = row.createCell(this.getColumnIndex(this.sheet, (String)sheetName, attributeName));
                            if (value instanceof InputStream) {
                                try {
                                    QuotaByteArrayOutputStream bytes = new QuotaByteArrayOutputStream(XmlExporter.class.getName());
                                    BinaryLargeObjects.streamCopy((InputStream)((InputStream)value), (long)0L, (OutputStream)bytes);
                                    String encodedBytes = Base64.encode((byte[])bytes.getBuffer(), (int)0, (int)bytes.size());
                                    if (encodedBytes.length() >= Short.MAX_VALUE) continue;
                                    cell.setCellValue((RichTextString)new HSSFRichTextString(encodedBytes));
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new ServiceException(e);
                                }
                            }
                            if (value instanceof byte[]) {
                                String encodedBytes = Base64.encode((byte[])((byte[])value));
                                if (encodedBytes.length() >= Short.MAX_VALUE) continue;
                                cell.setCellValue((RichTextString)new HSSFRichTextString(encodedBytes));
                                continue;
                            }
                            if (value instanceof Number) {
                                cell.setCellValue(((Number)value).doubleValue());
                                continue;
                            }
                            if (value instanceof Boolean) {
                                cell.setCellValue(((Boolean)value).booleanValue());
                                continue;
                            }
                            if (value instanceof RefObject_1_0) {
                                TraversedObject obj;
                                ModelElement_1_0 featureDef;
                                boolean matches;
                                cell.setCellValue((RichTextString)new HSSFRichTextString(((RefObject_1_0)value).refGetPath().toXRI()));
                                Set<String> referenceFilter = ObjectExporter.this.params.getReferenceFilter();
                                boolean bl = matches = referenceFilter == null;
                                if (!matches && (featureDef = attributes.get(attributeName)) != null) {
                                    String qualifiedFeatureName = featureDef.getQualifiedName();
                                    boolean bl2 = matches = referenceFilter.contains(attributeName + "[1]") || referenceFilter.contains(qualifiedFeatureName + "[1]");
                                }
                                if (!matches || ObjectExporter.this.referencedObjects.contains(obj = new TraversedObject((RefObject_1_0)value, object.getLevel() + 1))) continue;
                                ObjectExporter.this.referencedObjects.add(obj);
                                continue;
                            }
                            String stringifiedValue = value.toString();
                            if (stringifiedValue.length() > Short.MAX_VALUE) {
                                cell.setCellValue((RichTextString)new HSSFRichTextString(stringifiedValue.substring(0, 32762) + "..."));
                                continue;
                            }
                            cell.setCellValue((RichTextString)new HSSFRichTextString(stringifiedValue));
                        }
                    }
                    HSSFCell mCell = this.metainf == null || this.metainf.getRow(1) == null ? null : this.metainf.getRow(1).getCell(this.getColumnIndex(this.metainf, "META-INF", (String)sheetName));
                    int rowLimit = mCell == null ? this.objectLimit : new Double(mCell.getNumericCellValue()).intValue();
                    return this.sheet.getLastRowNum() < rowLimit;
                }
                return this.objectCount < this.objectLimit;
            }

            @Override
            public boolean startObject(TraversedObject object, String id, String qualifierName, String qualifiedName) throws ServiceException {
                return this.objectCount < this.objectLimit;
            }

            @Override
            public boolean startReference(String qualifiedName) throws ServiceException {
                return true;
            }

            @Override
            public void startTraversal(TraversedObject object) throws ServiceException {
                this.sheet = null;
            }
        }
    }

    static interface ContentHandler {
        public boolean startReference(String var1) throws ServiceException;

        public void endReference(String var1) throws ServiceException;

        public boolean startObject(TraversedObject var1, String var2, String var3, String var4) throws ServiceException;

        public void endObject(TraversedObject var1, String var2) throws ServiceException;

        public boolean featureComplete(TraversedObject var1, String var2) throws ServiceException;

        public void startTraversal(TraversedObject var1) throws ServiceException;

        public void endTraversal(TraversedObject var1) throws ServiceException;
    }

    static class XMLWriter {
        private final PrintStream out;
        private String indentString = "\t";
        private final Stack<String> qNameStack;

        public XMLWriter(PrintStream out) {
            this.out = out;
            this.qNameStack = new Stack();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws ServiceException {
            int i;
            this.out.print('\n');
            for (i = 0; i < this.qNameStack.size(); ++i) {
                this.out.print(this.indentString);
            }
            this.out.print('<');
            this.out.print(qName);
            if (atts.getLength() > 0) {
                for (i = 0; i < atts.getLength(); ++i) {
                    this.out.print(" ");
                    this.out.print(XMLEncoder.encode((String)atts.getQName(i)));
                    this.out.print('=');
                    this.out.print('\"');
                    this.out.print(XMLEncoder.encode((String)atts.getValue(i)));
                    this.out.print('\"');
                }
            }
            this.out.write(62);
            this.qNameStack.push(qName);
        }

        public void endElement(String namespaceURI, String localName, String qName, boolean newLine) throws ServiceException {
            String expectedQName = this.qNameStack.pop();
            if (!expectedQName.equals(qName)) {
                throw new ServiceException("DefaultDomain", -2, "Non matching qName for XML tag.", new BasicException.Parameter[]{new BasicException.Parameter("qName", (Object)qName), new BasicException.Parameter("expected qName", (Object)expectedQName)});
            }
            if (newLine) {
                this.out.print('\n');
                for (int i = 0; i < this.qNameStack.size(); ++i) {
                    this.out.print(this.indentString);
                }
            }
            this.out.print("</");
            this.out.print(XMLEncoder.encode((String)qName));
            this.out.print(">");
        }

        public void characters(char[] ch, int start, int length) throws ServiceException {
            String s = new String(ch, start, length);
            this.out.print(XMLEncoder.encode((String)s));
        }

        public void startDocument() throws ServiceException {
            this.out.print("<?xml version=\"1.0\" encoding=\"");
            this.out.print("UTF-8");
            this.out.print("\"?>");
        }

        public void comment(String comment) throws ServiceException {
            this.out.print("<!-- " + comment + " -->");
        }

        public void endDocument() throws ServiceException {
            this.out.flush();
            if (!this.qNameStack.isEmpty()) {
                throw new ServiceException("DefaultDomain", -2, "Open elements while endDocument().", new BasicException.Parameter[]{new BasicException.Parameter("elements", (Object)this.qNameStack.toString())});
            }
        }

        public void processingInstruction(String target, String data) throws ServiceException {
            this.out.print("\n<?");
            this.out.print(target);
            this.out.print(' ');
            this.out.print(data);
            this.out.print("?>");
        }

        public static class Attributes {
            private List<Attribute> _attributes = new ArrayList<Attribute>();

            public void addCDATA(String qName, String value) {
                this._attributes.add(new Attribute(qName, value));
            }

            public String getQName(int index) {
                return this._attributes.get((int)index)._qName;
            }

            public String getValue(int index) {
                return this._attributes.get((int)index)._value;
            }

            public int getLength() {
                return this._attributes.size();
            }
        }

        private static class Attribute {
            String _qName;
            String _value;

            Attribute(String qName, String value) {
                this._qName = qName;
                this._value = value;
            }
        }
    }

    public static class ExportParams {
        private final Set<String> referenceFilter = new HashSet<String>();
        private final Map<String, List<String>> options = new HashMap<String, List<String>>();
        private final Map<String, Object> context = new HashMap<String, Object>();
        private String mimeType;
        private int currentEntryId = 0;

        public Set<String> getReferenceFilter() {
            return this.referenceFilter;
        }

        public Map<String, List<String>> getOptions() {
            return this.options;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public int getNextEntryId() {
            return this.currentEntryId++;
        }

        public void resetEntryId() {
            this.currentEntryId = 0;
        }
    }

    static class NullOutputStream
    extends OutputStream {
        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    public static class TraversedObject {
        private final RefObject_1_0 object;
        private final int level;

        public TraversedObject(RefObject_1_0 object, int level) {
            this.object = object;
            this.level = level;
        }

        public RefObject_1_0 getObject() {
            return this.object;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean equals(Object obj) {
            return obj instanceof TraversedObject ? this.object.equals(((TraversedObject)obj).object) : false;
        }
    }
}

