/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.backend.Accounts;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.DataBinding;
import org.w3c.spi2.Datatypes;

public class AccountIsMemberOfDataBinding
extends DataBinding {
    private List<Short> memberRoles = null;

    public AccountIsMemberOfDataBinding(String parameterString) {
        if (parameterString != null && parameterString.startsWith("memberRole=")) {
            String[] memberRoles;
            this.memberRoles = new ArrayList<Short>();
            for (String value : memberRoles = parameterString.substring(11).split(",")) {
                String type = "short";
                if (value.startsWith("(")) {
                    type = value.substring(1, value.indexOf(")"));
                    value = value.substring(value.indexOf(")") + 1);
                }
                Class valueClass = null;
                if ("short".equalsIgnoreCase(type)) {
                    valueClass = Short.class;
                } else if ("int".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type)) {
                    valueClass = Integer.class;
                } else if ("long".equalsIgnoreCase(type)) {
                    valueClass = Long.class;
                } else if ("decimal".equalsIgnoreCase(type)) {
                    valueClass = BigDecimal.class;
                }
                this.memberRoles.add(((Number)Datatypes.create(valueClass, (String)value)).shortValue());
            }
        }
    }

    public Object getValue(RefObject object, String qualifiedFeatureName, ApplicationContext app) {
        if (object instanceof Account) {
            Account account = (Account)object;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
            String providerName = account.refGetPath().get(2);
            String segmentName = account.refGetPath().get(4);
            TreeMap<CallSite, Account> referencingAccounts = new TreeMap<CallSite, Account>();
            try {
                Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, providerName, segmentName);
                MemberQuery query = (MemberQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(Member.class), (Object)accountSegment.refGetPath().getDescendant(new String[]{"account", ":*", "member", ":*"}));
                query.thereExistsAccount().equalTo(account);
                query.forAllDisabled().isFalse();
                if (this.memberRoles != null) {
                    query.thereExistsMemberRole().elementOf(this.memberRoles);
                }
                for (Member member : accountSegment.getExtent((ExtentCapableQuery)query)) {
                    Account referencingAccount = (Account)pm.getObjectById((Object)member.refGetPath().getParent().getParent());
                    if (referencingAccounts.values().contains(referencingAccount)) continue;
                    referencingAccounts.put((CallSite)((Object)(referencingAccount.getFullName() + "*" + referencingAccount.refGetPath())), referencingAccount);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return referencingAccounts.values();
        }
        return null;
    }

    public void setValue(RefObject object, String qualifiedFeatureName, Object newValue, ApplicationContext app) {
    }
}

