/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.activity1.cci2.EMailContainsRecipient;
import org.opencrx.kernel.activity1.jmi1.AbstractEMailRecipient;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.EMailRecipient;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.DataBinding;

public class EMailRecipientDataBinding
extends DataBinding {
    private int index = 0;
    private short partyType = 0;

    public EMailRecipientDataBinding(String parameterString) {
        String[] params = parameterString.split(";");
        if (params != null) {
            for (String param : params) {
                String[] nv = param.split("=");
                if (nv == null || nv.length != 2) continue;
                if ("index".equals(nv[0])) {
                    this.index = Integer.valueOf(nv[1]);
                    continue;
                }
                if (!"partyType".equals(nv[0])) continue;
                this.partyType = Short.valueOf(nv[1]);
            }
        }
    }

    protected List<EMailRecipient> getEMailRecipients(EMail eMailActivity) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)eMailActivity);
        TreeMap<CallSite, EMailRecipient> allRecipients = new TreeMap<CallSite, EMailRecipient>();
        EMailContainsRecipient.EmailRecipient recipients = eMailActivity.getEmailRecipient();
        Date now = new Date();
        Iterator iterator = recipients.iterator();
        while (iterator.hasNext()) {
            AbstractEMailRecipient recipient = (AbstractEMailRecipient)iterator.next();
            if (!(recipient instanceof EMailRecipient) || recipient.getPartyType() != this.partyType) continue;
            allRecipients.put((CallSite)((Object)(JDOHelper.isNew((Object)recipient) ? now.getTime() + ":" + recipient.refGetPath().getLastSegment().toString() : recipient.getCreatedAt().getTime() + ":" + recipient.refGetPath().getLastSegment().toString())), (EMailRecipient)recipient);
        }
        Set deletedObjects = pm.getManagedObjects(EnumSet.of(ObjectState.PERSISTENT_DELETED));
        for (RefObject_1_0 object : deletedObjects) {
            EMailRecipient recipient;
            if (!(object instanceof EMailRecipient) || !object.refGetPath().startsWith(eMailActivity.refGetPath()) || (recipient = (EMailRecipient)object).getPartyType() != this.partyType) continue;
            allRecipients.put((CallSite)((Object)(recipient.getCreatedAt().getTime() + ":" + recipient.refGetPath().getLastSegment().toString())), recipient);
        }
        return new ArrayList<EMailRecipient>(allRecipients.values());
    }

    protected String uuidAsString() {
        return UUIDConversion.toUID((UUID)UUIDs.newUUID());
    }

    public Object getValue(RefObject object, String qualifiedFeatureName, ApplicationContext app) {
        if (object instanceof EMail) {
            EMail eMailActivity = (EMail)object;
            List<EMailRecipient> recipients = this.getEMailRecipients(eMailActivity);
            return this.index < recipients.size() ? recipients.get(this.index) : null;
        }
        return null;
    }

    public void setValue(RefObject object, String qualifiedFeatureName, Object newValue, ApplicationContext app) {
        if (object instanceof EMail && (newValue == null || newValue instanceof EMailAddress)) {
            EMail eMailActivity = (EMail)object;
            EMailAddress eMailAddress = (EMailAddress)newValue;
            List<EMailRecipient> recipients = this.getEMailRecipients(eMailActivity);
            if (this.index < recipients.size()) {
                EMailRecipient recipient = recipients.get(this.index);
                if (newValue == null) {
                    if (!JDOHelper.isDeleted((Object)recipient)) {
                        recipient.refDelete();
                    }
                } else {
                    recipient.setParty(eMailAddress);
                }
            } else if (newValue != null) {
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)eMailActivity);
                EMailRecipient recipient = null;
                for (int i = recipients.size(); i < this.index + 1; ++i) {
                    recipient = (EMailRecipient)pm.newInstance(EMailRecipient.class);
                    recipient.setPartyType(this.partyType);
                    eMailActivity.addEmailRecipient(this.uuidAsString(), recipient);
                }
                recipient.setParty(eMailAddress);
            }
        }
    }
}

