/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.text;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.openmdx.base.exception.ServiceException;

public class WordToText {
    public String[] getParagraphText(HWPFDocument doc) {
        String[] ret = new String[]{};
        try {
            Range r = doc.getRange();
            ret = new String[r.numParagraphs()];
            for (int i = 0; i < ret.length; ++i) {
                Paragraph p = r.getParagraph(i);
                ret[i] = p.text();
                if (!ret[i].endsWith("\r")) continue;
                ret[i] = ret[i] + "\n";
            }
        }
        catch (Exception e) {
            ret = new String[]{this.getTextFromPieces(doc)};
        }
        return ret;
    }

    public String getTextFromPieces(HWPFDocument doc) {
        StringBuffer textBuf = new StringBuffer();
        for (TextPiece piece : doc.getTextTable().getTextPieces()) {
            String encoding = "Cp1252";
            if (piece.isUnicode()) {
                encoding = "UTF-16LE";
            }
            try {
                String text = new String(piece.getRawBytes(), encoding);
                textBuf.append(text);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        Object text = textBuf.toString();
        text = ((String)text).replaceAll("\r\r\r", "\r\n\r\n\r\n");
        if (((String)(text = ((String)text).replaceAll("\r\r", "\r\n\r\n"))).endsWith("\r")) {
            text = (String)text + "\n";
        }
        return text;
    }

    public Reader parse(InputStream in) throws ServiceException {
        try {
            String[] paragraphs;
            HWPFDocument doc = new HWPFDocument(HWPFDocument.verifyAndBuildPOIFS((InputStream)in));
            StringBuilder text = new StringBuilder();
            for (String paragraph : paragraphs = this.getParagraphText(doc)) {
                text.append(paragraph);
            }
            return new StringReader(text.toString());
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

