/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.account1.cci2.AbstractGroupQuery;
import org.opencrx.kernel.account1.cci2.AccountFilterGlobalQuery;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.jmi1.AbstractFilterAccount;
import org.opencrx.kernel.account1.jmi1.AbstractGroup;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.backend.Accounts;
import org.openmdx.base.exception.ServiceException;
import org.w3c.format.DateTimeFormat;

public class AccountQueryHelper {
    protected final PersistenceManager pm;
    protected AccountFilterGlobal accountFilter = null;
    protected AbstractGroup accountGroup = null;
    protected Segment accountSegment = null;
    protected String filterName = null;
    protected String accountGroupName = null;

    public AccountQueryHelper(PersistenceManager pm) {
        this.pm = pm;
    }

    public int parseQueryId(String id) throws ServiceException {
        List<String> l = AccountQueryHelper.splitUri(id);
        if (l.size() >= 3) {
            String providerName = l.get(0);
            String segmentName = l.get(1);
            this.accountSegment = Accounts.getInstance().getAccountSegment(this.pm, providerName, segmentName);
            this.filterName = null;
            this.accountFilter = null;
            this.accountGroupName = null;
            this.accountGroup = null;
            if ("filter".equals(l.get(l.size() - 2))) {
                this.filterName = l.get(l.size() - 1);
                AccountFilterGlobalQuery query = (AccountFilterGlobalQuery)this.pm.newQuery(AccountFilterGlobal.class);
                query.name().equalTo((Object)this.filterName);
                List accountFilters = this.accountSegment.getAccountFilter(query);
                if (!accountFilters.isEmpty()) {
                    this.accountFilter = (AccountFilterGlobal)accountFilters.iterator().next();
                }
            } else if ("group".equals(l.get(l.size() - 2))) {
                this.accountGroupName = l.get(l.size() - 1);
                AbstractGroupQuery query = (AbstractGroupQuery)this.pm.newQuery(AbstractGroup.class);
                query.name().equalTo((Object)this.accountGroupName);
                List accountGroups = this.accountSegment.getAccount(query);
                if (!accountGroups.isEmpty()) {
                    this.accountGroup = (AbstractGroup)accountGroups.iterator().next();
                }
            }
        }
        return l.size();
    }

    public AbstractFilterAccount getAccountFilter() {
        return this.accountFilter;
    }

    public AbstractGroup getAccountGroup() {
        return this.accountGroup;
    }

    public Segment getAccountSegment() {
        return this.accountSegment;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getAccountGroupName() {
        return this.accountGroupName;
    }

    public Collection<Account> getFilteredAccounts(AccountQuery accountQuery) {
        if (this.accountFilter != null) {
            return this.accountFilter.getFilteredAccount(accountQuery);
        }
        if (this.accountGroup != null) {
            accountQuery.thereExistsAccountMembership().thereExistsAccountFrom().elementOf(new Object[]{this.accountGroup});
            accountQuery.thereExistsAccountMembership().distance().equalTo((Object)-1);
            return this.accountSegment.getAccount(accountQuery);
        }
        return Collections.emptyList();
    }

    public static String formatDate(Date date) {
        return DateTimeFormat.BASIC_UTC_FORMAT.format(date).substring(0, 15) + "Z";
    }

    public static List<String> splitUri(String uri) throws IllegalArgumentException {
        try {
            String[] ss = uri.split("/");
            int pathLength = ss.length - 1;
            if (pathLength < 2) {
                throw new IllegalArgumentException("Bad uri: " + uri);
            }
            List<String> l = Arrays.asList(ss);
            return l.subList(1, l.size());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad uri: " + uri);
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }
}

