/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.util.List;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.admin1.jmi1.Segment;
import org.opencrx.kernel.base.cci2.StringPropertyQuery;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;

public abstract class ComponentConfigHelper {
    public static ComponentConfiguration getComponentConfiguration(String configurationId, String providerName, PersistenceManager pm, boolean autoCreate, String[][] initialProperties) {
        ComponentConfiguration componentConfiguration = null;
        try {
            Segment adminSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.admin1").getDescendant(new String[]{"provider", providerName, "segment", "Root"}));
            try {
                componentConfiguration = adminSegment.getConfiguration(configurationId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (autoCreate && componentConfiguration == null) {
                componentConfiguration = (ComponentConfiguration)pm.newInstance(ComponentConfiguration.class);
                componentConfiguration.setName(configurationId);
                pm.currentTransaction().begin();
                adminSegment.addConfiguration(false, configurationId, componentConfiguration);
                if (initialProperties != null) {
                    for (String[] e : initialProperties) {
                        StringProperty sp = (StringProperty)pm.newInstance(StringProperty.class);
                        sp.setName(e[0]);
                        sp.setStringValue(e[1]);
                        componentConfiguration.addProperty(UUIDConversion.toUID((UUID)UUIDs.newUUID()), sp);
                    }
                }
                pm.currentTransaction().commit();
                componentConfiguration = adminSegment.getConfiguration(configurationId);
            }
        }
        catch (Exception e) {
            SysLog.warning((String)"Can not get component configuration", (Throwable)e);
        }
        return componentConfiguration;
    }

    public static StringProperty addComponentConfigProperty(String name, String stringValue, ComponentConfiguration configuration) {
        boolean isTxLocal;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)configuration);
        boolean bl = isTxLocal = !pm.currentTransaction().isActive();
        if (isTxLocal) {
            pm.currentTransaction().begin();
        }
        StringProperty sp = (StringProperty)pm.newInstance(StringProperty.class);
        sp.setName(name);
        sp.setStringValue(stringValue);
        configuration.addProperty(UUIDConversion.toUID((UUID)UUIDs.newUUID()), sp);
        if (isTxLocal) {
            pm.currentTransaction().commit();
        }
        return sp;
    }

    public static StringProperty getComponentConfigProperty(String name, ComponentConfiguration configuration) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)configuration);
        StringPropertyQuery query = (StringPropertyQuery)pm.newQuery(StringProperty.class);
        query.name().equalTo((Object)name);
        List properties = configuration.getProperty(query);
        return properties.isEmpty() ? null : (StringProperty)properties.iterator().next();
    }
}

