/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils.rtf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.opencrx.kernel.utils.rtf.Bookmark;
import org.opencrx.kernel.utils.rtf.BookmarkIsNotCheckboxException;
import org.opencrx.kernel.utils.rtf.BookmarkNotFoundException;
import org.opencrx.kernel.utils.rtf.RtfUtil;
import org.opencrx.kernel.utils.rtf.Text;

public class RTFTemplate {
    private StringBuffer content;

    public void readFrom(Reader in, boolean closeReader) throws IOException {
        int c;
        this.content = new StringBuffer();
        while ((c = in.read()) >= 0) {
            this.content.append((char)c);
        }
        if (closeReader) {
            in.close();
        }
    }

    public void writeTo(Writer out, boolean closeWriter) throws IOException {
        String documentAsString = this.getDocumentAsString();
        out.write(documentAsString);
        if (closeWriter) {
            out.close();
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        String documentAsString = this.getDocumentAsString();
        out.write(documentAsString.getBytes());
    }

    public boolean existBookmark(String name) {
        int pos = this.content.toString().indexOf("\\bkmkstart " + name + "}");
        return pos >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bookmark searchBookmark(String name) throws BookmarkNotFoundException {
        Bookmark result = null;
        StringBuffer rtfdoc = this.content;
        int begin = rtfdoc.indexOf("\\bkmkstart " + name + "}");
        if (begin < 0) {
            begin = rtfdoc.indexOf("\\bkmkstart " + name + "\r");
        }
        if (begin < 0) throw new BookmarkNotFoundException(name, "Bookmark '" + name + "' not found!");
        int contentBegin = rtfdoc.indexOf("}", begin);
        while (rtfdoc.charAt(contentBegin) == '}') {
            ++contentBegin;
        }
        int end = rtfdoc.indexOf("\\bkmkend " + name + "}", contentBegin);
        if (end < 0) {
            end = rtfdoc.indexOf("\\bkmkend " + name + "\r", contentBegin);
        }
        if (end < 0) throw new BookmarkNotFoundException(name, "Endtag of bookmark '" + name + "' not found!");
        int contentEnd = rtfdoc.lastIndexOf("{", end);
        while (rtfdoc.charAt(contentEnd) == '{') {
            --contentEnd;
        }
        return new Bookmark(name, begin, RtfUtil.getPositionOfTagEnd(rtfdoc, end), contentBegin, ++contentEnd, rtfdoc.substring(contentBegin, contentEnd));
    }

    public void appendTableRow(String bookmarkTableEnd) throws BookmarkNotFoundException {
        int pos;
        Bookmark bmTableEnd = this.searchBookmark(bookmarkTableEnd);
        int nRowCount = 2;
        int[] posRow = new int[2];
        for (pos = bmTableEnd.getContentBegin(); pos >= 0; --pos) {
            if (!this.content.substring(pos).startsWith("\\row ")) continue;
            posRow[--nRowCount] = pos;
            if (nRowCount == 0) break;
        }
        if (pos >= 0 && posRow[0] > 0 && posRow[1] > posRow[0]) {
            String rowContent = this.content.substring(posRow[0], posRow[1]) + " ";
            this.content.insert(pos, rowContent);
        }
    }

    private void setBookmarkRawContent(String bookmark, String text, boolean removeBookmark) throws BookmarkNotFoundException {
        Bookmark bm = this.searchBookmark(bookmark);
        if (removeBookmark) {
            this.content.replace(bm.getContentEnd(), bm.getEnd(), "{\\*\\bkmkend null}");
        }
        if (bm.isField()) {
            String bkmkcontent = bm.getRawContent();
            int contentPos = bkmkcontent.indexOf("\\fldrslt");
            if (contentPos >= 0) {
                int begin = bkmkcontent.lastIndexOf("{", contentPos);
                int end = RtfUtil.getPositionOfTagEnd(bkmkcontent, begin);
                this.content.replace(bm.getContentBegin() + begin, bm.getContentBegin() + end, "{\\fldrslt " + text + "}");
            } else {
                int inspos = bkmkcontent.lastIndexOf("}");
                this.content.insert(bm.getContentBegin() + inspos, "{\\fldrslt " + text + "}");
            }
        } else {
            this.content.replace(bm.getContentBegin(), bm.getContentEnd(), text);
        }
        if (removeBookmark) {
            this.content.replace(bm.getBegin(), bm.getContentBegin(), "\\bkmkstart null}");
        }
    }

    public void setBookmarkContent(String bookmark, String text, boolean removeBookmark) throws BookmarkNotFoundException {
        this.setBookmarkRawContent(bookmark, RtfUtil.getRTFString(text), removeBookmark);
    }

    public void setBookmarkContent(String bookmark, String text) throws BookmarkNotFoundException {
        this.setBookmarkRawContent(bookmark, RtfUtil.getRTFString(text), false);
    }

    public void setBookmarkContent(String bookmark, Text textparts, boolean removeBookmark) throws BookmarkNotFoundException {
        this.setBookmarkRawContent(bookmark, textparts.getRtfContent(), removeBookmark);
    }

    public void setBookmarkContent(String bookmark, Text textparts) throws BookmarkNotFoundException {
        this.setBookmarkRawContent(bookmark, textparts.getRtfContent(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBookmarkCheckbox(String bookmark, boolean value) throws BookmarkNotFoundException, BookmarkIsNotCheckboxException {
        String cbresult;
        Bookmark bmi = this.searchBookmark(bookmark);
        String string = cbresult = value ? "1" : "25";
        if (!bmi.isField()) throw new BookmarkIsNotCheckboxException(bookmark);
        if (bmi.getFieldtype() != 1) throw new BookmarkIsNotCheckboxException(bookmark);
        int posres = bmi.getRawContent().indexOf("\\ffres");
        if (posres >= 0) {
            int len = 0;
            int countstart = bmi.getContentBegin() + posres + 6;
            while (Character.isDigit(this.content.charAt(countstart + len))) {
                ++len;
            }
            this.content.replace(countstart, countstart + len, cbresult);
            return;
        } else {
            int postype = bmi.getRawContent().indexOf("\\fftype");
            if (postype < 0) throw new BookmarkNotFoundException(bookmark, "Typedefinition not found!");
            this.content.insert(bmi.getContentBegin() + postype + 8, "\\ffres " + cbresult);
        }
    }

    protected String getDocumentAsString() {
        return this.content.toString();
    }

    public List<String> getBookmarkNames() {
        ArrayList<String> allbm = new ArrayList<String>();
        int pos = 0;
        while ((pos = this.content.indexOf("\\bkmkstart ", pos)) >= 0) {
            int end = this.content.indexOf("}", pos);
            allbm.add(this.content.substring(pos + 11, end));
            ++pos;
        }
        return allbm;
    }
}

