/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.adapter;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.PersistenceManagerFactory;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;
import org.opencrx.application.adapter.AbstractSession;
import org.openmdx.base.exception.ServiceException;

public abstract class AbstractServer
implements Runnable {
    protected final String serverName;
    protected final String bindAddress;
    protected final String sslKeystoreFile;
    protected final String sslKeystoreType;
    protected final String sslKeystorePass;
    protected final String sslKeyPass;
    protected final String sslTruststoreFile;
    protected final String sslTruststoreType;
    protected final String sslTruststorePass;
    protected final Boolean sslNeedClientAuth;
    protected final int portNumber;
    protected final String providerName;
    protected final boolean isDebug;
    protected final int delayOnStartup;
    protected final Map<Thread, AbstractSession> sessions = new ConcurrentHashMap<Thread, AbstractSession>();
    protected ServerSocket serverSocket = null;
    protected final PersistenceManagerFactory pmf;

    protected AbstractServer(String serverName, PersistenceManagerFactory pmf, String providerName, String bindAddress, int portNumber, String sslKeystoreFile, String sslKeystoreType, String sslKeystorePass, String sslKeyPass, String sslTruststoreFile, String sslTruststorePass, String sslTruststoreType, Boolean sslNeedClientAuth, boolean isDebug, int delayOnStartup) {
        this.serverName = serverName;
        this.pmf = pmf;
        this.bindAddress = bindAddress;
        this.portNumber = portNumber;
        this.sslKeystoreFile = sslKeystoreFile;
        this.sslKeystoreType = sslKeystoreType;
        this.sslKeystorePass = sslKeystorePass;
        this.sslKeyPass = sslKeyPass;
        this.sslTruststoreFile = sslTruststoreFile;
        this.sslTruststorePass = sslTruststorePass;
        this.sslTruststoreType = sslTruststoreType;
        this.sslNeedClientAuth = sslNeedClientAuth;
        this.providerName = providerName;
        this.isDebug = isDebug;
        this.delayOnStartup = delayOnStartup;
    }

    public abstract AbstractSession newSession(Socket var1, AbstractServer var2);

    public boolean bind() throws ServiceException {
        ServerSocketFactory serverSocketFactory;
        boolean isSsl = false;
        if (this.sslKeystoreFile == null || this.sslKeystoreFile.isEmpty()) {
            serverSocketFactory = ServerSocketFactory.getDefault();
        } else {
            isSsl = true;
            FileInputStream keyStoreInputStream = null;
            FileInputStream trustStoreInputStream = null;
            try {
                keyStoreInputStream = new FileInputStream(this.sslKeystoreFile);
                KeyStore keystore = KeyStore.getInstance(this.sslKeystoreType);
                keystore.load(keyStoreInputStream, this.sslKeystorePass.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keystore, this.sslKeyPass.toCharArray());
                SSLContext sslContext = SSLContext.getInstance("SSLv3");
                TrustManagerFactory tmf = null;
                if (this.sslTruststoreFile != null && !this.sslTruststoreFile.isEmpty()) {
                    trustStoreInputStream = new FileInputStream(this.sslTruststoreFile);
                    KeyStore truststore = KeyStore.getInstance(this.sslTruststoreType);
                    truststore.load(trustStoreInputStream, this.sslTruststorePass.toCharArray());
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(truststore);
                }
                sslContext.init(kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), null);
                serverSocketFactory = sslContext.getServerSocketFactory();
            }
            catch (IOException e) {
                throw new ServiceException((Exception)e);
            }
            catch (GeneralSecurityException e) {
                throw new ServiceException((Exception)e);
            }
            finally {
                if (keyStoreInputStream != null) {
                    try {
                        keyStoreInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            this.serverSocket = this.bindAddress == null || this.bindAddress.isEmpty() ? serverSocketFactory.createServerSocket(this.portNumber) : serverSocketFactory.createServerSocket(this.portNumber, 0, Inet4Address.getByName(this.bindAddress));
            if (Boolean.TRUE.equals(this.sslNeedClientAuth)) {
                ((SSLServerSocket)this.serverSocket).setNeedClientAuth(true);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Exception)e);
        }
        return isSsl;
    }

    @Override
    public void run() {
        try {
            Thread.sleep((long)this.delayOnStartup * 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (true) {
            if (this.serverSocket == null) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                Socket socket = this.serverSocket.accept();
                socket.setSoTimeout(30000);
                AbstractSession session = this.newSession(socket, this);
                Thread clientHandler = new Thread(session);
                clientHandler.start();
                Iterator<Map.Entry<Thread, AbstractSession>> i = this.sessions.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<Thread, AbstractSession> e = i.next();
                    if (e.getKey().isAlive()) continue;
                    i.remove();
                }
                this.sessions.put(clientHandler, session);
                continue;
            }
            catch (Exception e) {
                new ServiceException(e).log();
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }

    public void pause() {
        try {
            ServerSocket serverSocket = this.serverSocket;
            this.serverSocket = null;
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(this.serverName + " " + this.providerName + " stopped listening on port " + this.portNumber);
        for (AbstractSession session : this.sessions.values()) {
            session.stop();
        }
        this.sessions.clear();
    }

    public void resume() {
        boolean isSsl = false;
        try {
            if (this.serverSocket == null || this.serverSocket.isClosed()) {
                this.sessions.clear();
                isSsl = this.bind();
                System.out.println(this.serverName + " " + this.providerName + " is listening on " + (isSsl ? "SSL " : "") + "port " + this.portNumber);
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            System.out.println(this.serverName + " " + this.providerName + " bind failed for " + (isSsl ? "SSL " : "") + "port " + this.portNumber + ". See log for more information.");
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.pmf;
    }
}

