/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiActivity;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.Segment;
import org.opencrx.kernel.backend.Activities;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Query_2Facade;

public class GetAssignedActivitiesAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<Contact> contacts = plugIn.findContacts(path.getPrefix(7), pm);
        if (contacts == null || contacts.isEmpty()) {
            resp.setStatus(404);
        } else {
            try {
                Segment activitySegment = Activities.getInstance().getActivitySegment(pm, path.get(2), path.get(4));
                Contact contact = contacts.iterator().next();
                Query_2Facade queryFacade = Facades.newQuery((Path)activitySegment.refGetPath().getChild("activity"));
                queryFacade.setQueryType("org:opencrx:kernel:activity1:Activity");
                String query = req.getParameter("query");
                queryFacade.setQuery(query);
                String position = req.getParameter("position");
                queryFacade.setPosition((Number)(position == null ? Integer.valueOf(0) : Integer.valueOf(position)));
                String size = req.getParameter("size");
                queryFacade.setSize((Number)(size == null ? 25 : Integer.parseInt(size)));
                ActivityQuery activityQuery = (ActivityQuery)pm.newQuery("org.openmdx.query.OPENMDXQL", (Object)queryFacade.getDelegate());
                ArrayList<BpiActivity> bpiAssignedActivities = new ArrayList<BpiActivity>();
                int count = 0;
                ListIterator i = contact.getAssignedActivity(activityQuery).listIterator(queryFacade.getPosition().intValue());
                while (i.hasNext()) {
                    Activity activity = (Activity)i.next();
                    bpiAssignedActivities.add(plugIn.toBpiActivity(activity, plugIn.newBpiActivity(), this.getFetchGroup(req)));
                    if ((long)(++count) <= queryFacade.getSize()) continue;
                    break;
                }
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                PrintWriter pw = resp.getWriter();
                plugIn.printObject(pw, bpiAssignedActivities);
                resp.setStatus(200);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

