/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.kernel.workflow1.cci2.RunImportExportParams;
import org.opencrx.kernel.workflow1.jmi1.ExporterTask;
import org.opencrx.kernel.workflow1.jmi1.RunExportResult;
import org.opencrx.kernel.workflow1.jmi1.RunImportExportParams;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class RunExportAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<ExporterTask> exporterTasks = plugIn.findExporterTasks(path, pm);
        if (exporterTasks == null || exporterTasks.isEmpty()) {
            resp.setStatus(404);
        } else {
            try {
                ExporterTask exporterTask = exporterTasks.iterator().next();
                RunImportExportParams runExportParams = (RunImportExportParams)Structures.create(RunImportExportParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)RunImportExportParams.Member.param0, (Object)req.getParameter("param0")), Datatypes.member((Enum)RunImportExportParams.Member.param1, (Object)req.getParameter("param1")), Datatypes.member((Enum)RunImportExportParams.Member.param2, (Object)req.getParameter("param2")), Datatypes.member((Enum)RunImportExportParams.Member.param3, (Object)req.getParameter("param3")), Datatypes.member((Enum)RunImportExportParams.Member.param4, (Object)req.getParameter("param4")), Datatypes.member((Enum)RunImportExportParams.Member.param5, (Object)req.getParameter("param5")), Datatypes.member((Enum)RunImportExportParams.Member.param6, (Object)req.getParameter("param6")), Datatypes.member((Enum)RunImportExportParams.Member.param7, (Object)req.getParameter("param7")), Datatypes.member((Enum)RunImportExportParams.Member.param8, (Object)req.getParameter("param8")), Datatypes.member((Enum)RunImportExportParams.Member.param9, (Object)req.getParameter("param9"))});
                RunExportResult result = exporterTask.runExport(runExportParams);
                resp.setContentType(result.getFileMimeType());
                resp.setHeader("Content-disposition", "attachment;filename=" + path.getLastSegment().toString());
                byte[] source = result.getFile();
                ServletOutputStream target = resp.getOutputStream();
                BinaryLargeObjects.streamCopy((InputStream)BinaryLargeObjects.valueOf((byte[])result.getFile()).getContent(), (long)0L, (OutputStream)target);
                resp.setContentLength(source.length);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

