/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.carddav;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.opencrx.application.carddav.AccountResource;
import org.opencrx.application.carddav.CardDavResource;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.home1.jmi1.ContactsFeed;
import org.openmdx.base.collection.MarshallingCollection;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.marshalling.Marshaller;

public class AccountCollectionResource
extends CardDavResource {
    private static final int FETCH_SIZE = 200;

    public AccountCollectionResource(RequestContext requestContext, ContactsFeed contactsFeed) {
        super(requestContext, contactsFeed);
    }

    @Override
    public ContactsFeed getObject() {
        return (ContactsFeed)super.getObject();
    }

    @Override
    public String getDisplayName() {
        Set features = this.getObject().refDefaultFetchGroup();
        String name = this.getName();
        if (features.contains("name")) {
            name = (String)this.getObject().refGetValue("name");
        }
        return name;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getMimeType() {
        return "text/calendar";
    }

    public Collection<Resource> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        if (this.getObject() != null && this.getObject().getAccountGroup() != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)this.getObject());
            MemberQuery query = (MemberQuery)pm.newQuery(Member.class);
            query.forAllDisabled().isFalse();
            query.thereExistsAccount().vcard().isNonNull();
            query.orderByCreatedAt().ascending();
            ((Query)query).getFetchPlan().setFetchSize(200);
            return new AccountResourceCollection(this.getRequestContext(), this.getObject().getAccountGroup().getMember(query), this);
        }
        return Collections.emptyList();
    }

    static class AccountResourceCollection<T>
    extends MarshallingCollection<T> {
        private static final long serialVersionUID = 6257982279508324945L;

        public AccountResourceCollection(final RequestContext requestContext, Collection<Member> members, final AccountCollectionResource accountCollectionResource) {
            super(new Marshaller(){

                public Object marshal(Object source) throws ServiceException {
                    if (source instanceof Member) {
                        return new AccountResource(requestContext, (Account)((Member)source).getAccount(), accountCollectionResource);
                    }
                    return source;
                }

                public Object unmarshal(Object source) throws ServiceException {
                    if (source instanceof CardDavResource) {
                        return ((CardDavResource)source).getObject();
                    }
                    return source;
                }
            }, members);
        }
    }
}

