/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.document;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.MimetypesFileTypeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.cci2.SendAlertParams;
import org.opencrx.kernel.base.jmi1.SendAlertParams;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.cci2.DocumentHasRevision;
import org.opencrx.kernel.document1.cci2.DocumentQuery;
import org.opencrx.kernel.document1.cci2.FolderAssignmentQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.FolderAssignment;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.document1.jmi1.ResourceIdentifier;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class DocumentScannerServlet
extends HttpServlet {
    private static final long serialVersionUID = 4441731357561757549L;
    private static final String COMMAND_EXECUTE = "/execute";
    private static final String WORKFLOW_NAME = "DocumentScanner";
    private static final String COMPONENT_CONFIGURATION_ID = "DocumentScanner";
    private static final String OPTION_SCAN_DIR = "scanDir";
    private static final String OPTION_URL_PREFIX = "urlPrefix";
    private static final String OPTION_UPLOAD = "upload";
    private static final String OPTION_GROUPS = "groups";
    private static final long STARTUP_DELAY = 180000L;
    private PersistenceManagerFactory pmf = null;
    private static final Map<String, Thread> runningSegments = new ConcurrentHashMap<String, Thread>();
    private long startedAt = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("Can not get connection to persistence manager", (Throwable)e);
        }
    }

    private StringProperty getComponentConfigProperty(PersistenceManager rootPm, String providerName, String segmentName, String name) {
        ComponentConfiguration componentConfiguration = ComponentConfigHelper.getComponentConfiguration("DocumentScanner", providerName, rootPm, true, new String[][]{{providerName + ".Standard.scanDir", ""}, {providerName + ".Standard.urlPrefix", ""}, {providerName + ".Standard.upload", ""}, {providerName + ".Standard.groups", ""}});
        if (componentConfiguration != null) {
            return ComponentConfigHelper.getComponentConfigProperty(providerName + "." + segmentName + "." + name, componentConfiguration);
        }
        return null;
    }

    private void sendAlert(Segment documentSegment, String filename, String message, PersistenceManager pm) {
        String providerName = documentSegment.refGetPath().get(2);
        String segmentName = documentSegment.refGetPath().get(4);
        UserHome userHomeAdmin = (UserHome)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "userHome", "admin" + SecurityKeys.ID_SEPARATOR + segmentName}));
        SendAlertParams sendAlertParams = (SendAlertParams)Structures.create(SendAlertParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)SendAlertParams.Member.description, (Object)(DocumentScannerServlet.class.getSimpleName() + ": error importing document " + filename + "\nReason is:\n" + message)), Datatypes.member((Enum)SendAlertParams.Member.importance, (Object)2), Datatypes.member((Enum)SendAlertParams.Member.name, (Object)(DocumentScannerServlet.class.getSimpleName() + ": error importing document " + filename)), Datatypes.member((Enum)SendAlertParams.Member.resendDelayInSeconds, (Object)60), Datatypes.member((Enum)SendAlertParams.Member.toUsers, (Object)("admin" + SecurityKeys.ID_SEPARATOR + segmentName)), Datatypes.member((Enum)SendAlertParams.Member.reference, null)});
        try {
            pm.currentTransaction().begin();
            userHomeAdmin.sendAlert(sendAlertParams);
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void scanDocuments(File currentDir, File rootDir, Segment documentSegment, String uriPrefix, Boolean upload, List<PrincipalGroup> principalGroups, PersistenceManager pm) {
        File[] files = currentDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String[] names;
                if (file.isDirectory()) {
                    this.scanDocuments(file, rootDir, documentSegment, uriPrefix, upload, principalGroups, pm);
                    continue;
                }
                boolean hasErrors = false;
                String filename = file.getName();
                String ext = null;
                if (filename.indexOf(".") > 0) {
                    int pos = filename.lastIndexOf(".");
                    ext = filename.substring(pos + 1);
                    filename = filename.substring(0, pos);
                }
                boolean hasVersion = (names = filename.split("#")).length > 0 && names[names.length - 1].length() > 1 && names[names.length - 1].charAt(0) == 'v' && Character.isDigit(names[names.length - 1].charAt(1));
                String version = hasVersion ? names[names.length - 1].substring(1) : "1.0";
                Date activeOn = null;
                for (String name : names) {
                    if (!name.startsWith("@")) continue;
                    try {
                        activeOn = DateTimeFormat.BASIC_UTC_FORMAT.parse((String)(name.indexOf("T") > 0 ? name.substring(1) : name.substring(1) + "T000000.000Z"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                DocumentQuery query = (DocumentQuery)pm.newQuery(Document.class);
                String documentName = names[0] + (String)(ext == null ? "" : "." + ext);
                query.name().equalTo((Object)documentName);
                List documents = documentSegment.getDocument(query);
                Document document = null;
                if (documents.isEmpty()) {
                    document = (Document)pm.newInstance(Document.class);
                    document.setName(documentName);
                    document.setActiveOn(activeOn);
                    document.getOwningGroup().clear();
                    document.getOwningGroup().addAll(principalGroups);
                    try {
                        pm.currentTransaction().begin();
                        documentSegment.addDocument(Base.getInstance().getUidAsString(), document);
                        pm.currentTransaction().commit();
                    }
                    catch (Exception e) {
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.sendAlert(documentSegment, filename, e.getMessage(), pm);
                        new ServiceException(e).log();
                        hasErrors = true;
                    }
                } else {
                    document = (Document)documents.iterator().next();
                }
                DocumentRevision revision = null;
                DocumentHasRevision.Revision revisions = document.getRevision();
                Iterator iterator = revisions.iterator();
                while (iterator.hasNext()) {
                    DocumentRevision r = (DocumentRevision)iterator.next();
                    if (!version.equals(r.getVersion())) continue;
                    revision = r;
                    break;
                }
                if (revision == null) {
                    if (upload.booleanValue()) {
                        MediaContent mediaContent = (MediaContent)pm.newInstance(MediaContent.class);
                        mediaContent.setContent(BinaryLargeObjects.valueOf((File)file));
                        mediaContent.setContentMimeType(MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(file.getName()));
                        mediaContent.setContentName(file.getName());
                        revision = mediaContent;
                    } else {
                        ResourceIdentifier resourceIdentifier = (ResourceIdentifier)pm.newInstance(ResourceIdentifier.class);
                        resourceIdentifier.setUri(uriPrefix + currentDir.getPath().substring(rootDir.getPath().length()).replace("\\", "/") + "/" + file.getName());
                        revision = resourceIdentifier;
                    }
                    revision.setName(file.getName());
                    revision.setVersion(version);
                    revision.getOwningGroup().clear();
                    revision.getOwningGroup().addAll(principalGroups);
                    try {
                        pm.currentTransaction().begin();
                        document.addRevision(Base.getInstance().getUidAsString(), revision);
                        document.setHeadRevision(revision);
                        pm.currentTransaction().commit();
                    }
                    catch (Exception e) {
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception r) {
                            // empty catch block
                        }
                        this.sendAlert(documentSegment, filename, e.getMessage(), pm);
                        new ServiceException(e).log();
                        hasErrors = true;
                    }
                }
                ArrayList<String> folderNames = new ArrayList<String>();
                for (int i = 1; i < (hasVersion ? names.length - 1 : names.length); ++i) {
                    if (names[i].startsWith("@")) continue;
                    folderNames.add(names[i]);
                }
                folderNames.add(currentDir.getName());
                for (String folderName : folderNames) {
                    DocumentFolderQuery folderQuery = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
                    folderQuery.name().equalTo((Object)folderName);
                    List folders = documentSegment.getFolder(folderQuery);
                    DocumentFolder folder = null;
                    if (folders.isEmpty()) {
                        folder = (DocumentFolder)pm.newInstance(DocumentFolder.class);
                        folder.setName(folderName);
                        try {
                            pm.currentTransaction().begin();
                            documentSegment.addFolder(Base.getInstance().getUidAsString(), folder);
                            pm.currentTransaction().commit();
                        }
                        catch (Exception e) {
                            try {
                                pm.currentTransaction().rollback();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.sendAlert(documentSegment, filename, e.getMessage(), pm);
                            new ServiceException(e).log();
                            hasErrors = true;
                        }
                    } else {
                        try {
                            pm.currentTransaction().begin();
                            folder = (DocumentFolder)folders.iterator().next();
                            List groups = documentSegment.getOwningGroup();
                            for (PrincipalGroup group : groups) {
                                if (folder.getOwningGroup().contains(group)) continue;
                                folder.getOwningGroup().add(group);
                            }
                            pm.currentTransaction().commit();
                        }
                        catch (Exception e) {
                            try {
                                pm.currentTransaction().rollback();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.sendAlert(documentSegment, filename, e.getMessage(), pm);
                            new ServiceException(e).log();
                            hasErrors = true;
                        }
                    }
                    FolderAssignmentQuery assignmentQuery = (FolderAssignmentQuery)pm.newQuery(FolderAssignment.class);
                    assignmentQuery.thereExistsDocumentFolder().equalTo(folder);
                    List assignments = document.getDocumentFolderAssignment(assignmentQuery);
                    if (!assignments.isEmpty()) continue;
                    FolderAssignment assignment = (FolderAssignment)pm.newInstance(FolderAssignment.class);
                    assignment.setName(folder.getName());
                    assignment.setDocumentFolder(folder);
                    assignment.getOwningGroup().clear();
                    assignment.getOwningGroup().addAll(principalGroups);
                    try {
                        pm.currentTransaction().begin();
                        document.addDocumentFolderAssignment(Base.getInstance().getUidAsString(), assignment);
                        pm.currentTransaction().commit();
                        hasErrors = true;
                    }
                    catch (Exception e) {
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.sendAlert(documentSegment, filename, e.getMessage(), pm);
                        new ServiceException(e).log();
                        hasErrors = true;
                    }
                }
                if (hasErrors) continue;
                try {
                    file.delete();
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
        }
    }

    public void scanDocuments(String id, String providerName, String segmentName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        System.out.println(new Date().toString() + ": DocumentScanner " + providerName + "/" + segmentName);
        try {
            PersistenceManager pm = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
            PersistenceManager rootPm = Utils.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
            Workflows.getInstance().initWorkflows(pm, providerName, segmentName);
            for (int i = -1; i < 10; ++i) {
                Object idxSuffix = i < 0 ? "" : "[" + i + "]";
                StringProperty scanDir = this.getComponentConfigProperty(rootPm, providerName, segmentName, OPTION_SCAN_DIR + (String)idxSuffix);
                StringProperty urlPrefix = this.getComponentConfigProperty(rootPm, providerName, segmentName, OPTION_URL_PREFIX + (String)idxSuffix);
                StringProperty upload = this.getComponentConfigProperty(rootPm, providerName, segmentName, OPTION_UPLOAD + (String)idxSuffix);
                StringProperty groups = this.getComponentConfigProperty(rootPm, providerName, segmentName, OPTION_GROUPS + (String)idxSuffix);
                if (scanDir == null) continue;
                rootPm.currentTransaction().begin();
                scanDir.setDescription("Last scan at " + new Date());
                rootPm.currentTransaction().commit();
                scanDir = (StringProperty)rootPm.getObjectById((Object)scanDir.refGetPath());
                if (scanDir.getStringValue() == null || scanDir.getStringValue().length() <= 0) continue;
                File dir = new File(scanDir.getStringValue());
                Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
                ArrayList<PrincipalGroup> principalGroups = new ArrayList<PrincipalGroup>();
                if (groups == null || groups.getStringValue().length() == 0) {
                    PrincipalGroup group = (PrincipalGroup)pm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "realm", segmentName, "principal", "Users"}));
                    principalGroups.add(group);
                    group = (PrincipalGroup)pm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "realm", segmentName, "principal", "Administrators"}));
                    principalGroups.add(group);
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(groups.getStringValue(), ",; ", false);
                    while (tokenizer.hasMoreTokens()) {
                        String groupName = tokenizer.nextToken();
                        PrincipalGroup group = null;
                        try {
                            group = (PrincipalGroup)pm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "realm", segmentName, "principal", groupName}));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (group == null) continue;
                        principalGroups.add(group);
                    }
                }
                this.scanDocuments(dir, dir, documentSegment, urlPrefix == null ? "http://localhost" : urlPrefix.getStringValue(), upload == null ? false : Boolean.valueOf(upload.getStringValue()), principalGroups, pm);
            }
            try {
                if (pm != null) {
                    pm.close();
                }
                if (rootPm != null) {
                    rootPm.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            new ServiceException(e).log();
            System.out.println(new Date() + ": DocumentScanner " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (System.currentTimeMillis() > this.startedAt + 180000L) {
            String segmentName = req.getParameter("segment");
            String providerName = req.getParameter("provider");
            String id = providerName + "/" + segmentName;
            if (COMMAND_EXECUTE.equals(req.getPathInfo())) {
                if (!runningSegments.containsKey(id)) {
                    try {
                        runningSegments.put(id, Thread.currentThread());
                        this.scanDocuments(id, providerName, segmentName, req, res);
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                    finally {
                        runningSegments.remove(id);
                    }
                } else if (!runningSegments.get(id).isAlive() || runningSegments.get(id).isInterrupted()) {
                    Thread t = runningSegments.get(id);
                    System.out.println(new Date() + ": DocumentScanner " + providerName + "/" + segmentName + ": workflow " + t.getId() + " is alive=" + t.isAlive() + "; interrupted=" + t.isInterrupted() + ". Skipping execution.");
                }
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }
}

