/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.mail.importer;

import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.naming.InitialContext;
import org.opencrx.application.mail.importer.MailImporterConfig;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.log.SysLog;

public class MailStore {
    public static final String POP3_MODE = "pop3";
    public static final String IMAP_MODE = "imap";
    public static final String DEFAULT_FOLDERNAME = "INBOX";
    private Store store = null;
    private Folder folder = null;
    private MailImporterConfig config = null;

    public MailStore(MailImporterConfig config) {
        this.config = config;
    }

    public void openStore() throws ServiceException {
        SysLog.info((String)"Fetching emails with configuration", (Object)this.config);
        try {
            InitialContext initialContxt = new InitialContext();
            String mailServiceName = this.config.getMailServiceName();
            Session session = (Session)initialContxt.lookup("java:comp/env" + (String)(mailServiceName.startsWith("/") ? mailServiceName : "/" + mailServiceName));
            this.store = session.getStore();
            String protocol = this.store.getURLName().getProtocol();
            String port = session.getProperty("mail." + protocol + ".port");
            this.store.connect(session.getProperty("mail." + protocol + ".host"), port == null ? -1 : Integer.valueOf(port), session.getProperty("mail." + protocol + ".user"), session.getProperty("mail." + protocol + ".password"));
        }
        catch (Exception e) {
            SysLog.error((String)"Could not get mail session", (Object)this.config.getMailServiceName());
            ServiceException e0 = new ServiceException(e);
            SysLog.error((String)e0.getMessage(), (Throwable)e0.getCause());
            throw e0;
        }
    }

    public Message[] getMessages() throws MessagingException {
        return this.folder.getMessages();
    }

    public void openFolder(String name) throws ServiceException {
        try {
            this.folder = this.store.getFolder(name == null ? DEFAULT_FOLDERNAME : name);
            this.folder.open(2);
        }
        catch (FolderNotFoundException e) {
            SysLog.error((String)("Could not open the specified folder '" + name + "'"));
            ServiceException e0 = new ServiceException((Exception)((Object)e));
            SysLog.error((String)e0.getMessage(), (Throwable)e0.getCause());
            throw e0;
        }
        catch (MessagingException e) {
            SysLog.error((String)("Exception while opening folder '" + name + "'"));
            ServiceException e0 = new ServiceException((Exception)((Object)e));
            SysLog.error((String)e0.getMessage(), (Throwable)e0.getCause());
            throw e0;
        }
    }

    public void closeFolder() {
        if (this.folder != null) {
            try {
                this.folder.close(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeStore() {
        try {
            this.store.close();
        }
        catch (MessagingException e) {
            SysLog.warning((String)"Could not clean up resources");
        }
    }
}

