/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.parameter.EmailType;
import org.opencrx.application.uses.ezvcard.property.HasAltId;
import org.opencrx.application.uses.ezvcard.property.TextProperty;

public class Email
extends TextProperty
implements HasAltId {
    public Email(String email) {
        super(email);
    }

    public Set<EmailType> getTypes() {
        Set<String> values = this.parameters.getTypes();
        HashSet<EmailType> types = new HashSet<EmailType>(values.size());
        for (String value : values) {
            types.add(EmailType.get(value));
        }
        return types;
    }

    public void addType(EmailType type) {
        this.parameters.addType(type.getValue());
    }

    public void removeType(EmailType type) {
        this.parameters.removeType(type.getValue());
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        super._validate(warnings, version, vcard);
        for (EmailType type : this.getTypes()) {
            if (type == EmailType.PREF || type.isSupported(version)) continue;
            warnings.add(new Warning(9, type.getValue()));
        }
    }
}

