/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class IOUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        if (dot >= 0 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return null;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        return IOUtils.toByteArray(in, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in, boolean close) throws IOException {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                IOUtils.closeQuietly(in);
            }
        }
    }

    public static String toString(Reader reader) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4096];
        while ((read = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, read);
        }
        return sb.toString();
    }

    public static String getFileContents(File file) throws IOException {
        return IOUtils.getFileContents(file, Charset.defaultCharset().name());
    }

    public static String getFileContents(File file, String charset) throws IOException {
        byte[] bytes = IOUtils.toByteArray(new FileInputStream(file), true);
        return new String(bytes, charset);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Writer utf8Writer(OutputStream out) {
        return new OutputStreamWriter(out, UTF8);
    }

    public static Writer utf8Writer(File file) throws FileNotFoundException {
        return IOUtils.utf8Writer(file, false);
    }

    public static Writer utf8Writer(File file, boolean append) throws FileNotFoundException {
        return IOUtils.utf8Writer(new FileOutputStream(file, append));
    }

    public static Reader utf8Reader(InputStream in) {
        return new InputStreamReader(in, UTF8);
    }

    public static Reader utf8Reader(File file) throws FileNotFoundException {
        return IOUtils.utf8Reader(new FileInputStream(file));
    }

    private IOUtils() {
    }
}

