/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.uses.net.sf.webdav.Lock;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.exceptions.AccessDeniedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.LockFailedException;
import org.opencrx.application.uses.net.sf.webdav.exceptions.WebdavException;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLHelper;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLWriter;
import org.opencrx.application.uses.net.sf.webdav.methods.WebDavMethod;
import org.openmdx.base.exception.ServiceException;
import org.xml.sax.InputSource;

public class DoPropfind
extends WebDavMethod {
    private static Logger LOG = Logger.getLogger(DoPropfind.class.getPackage().getName());
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private final WebDavStore _store;

    public DoPropfind(WebDavStore store) {
        this._store = store;
    }

    protected boolean handleExtension(RequestContext requestContext, XMLWriter writer, String contextPath, Resource res, String property) {
        return false;
    }

    protected void writeCollectionType(RequestContext requestContext, XMLWriter writer, Resource res) {
    }

    protected Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("DAV:", "D");
        return namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute(RequestContext requestContext) throws IOException, LockFailedException {
        req = requestContext.getHttpServletRequest();
        resp = requestContext.getHttpServletResponse();
        DoPropfind.LOG.finest("-- " + this.getClass().getName());
        path = this.getCleanPath(this.getRelativePath(requestContext));
        res = null;
        try {
            res = this._store.getResourceByPath(requestContext, path);
            if (res == null) {
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/xml");
                resp.sendError(404, req.getRequestURI());
                return;
            }
            depth = this.getDepth(requestContext);
            properties = null;
            path = this.getCleanPath(this.getRelativePath(requestContext));
            propertyFindType = 1;
            propNode = null;
            if (req.getContentLength() > 0) {
                try {
                    documentBuilder = this.getDocumentBuilder();
                    document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                    rootElement = document.getDocumentElement();
                    propNode = XMLHelper.findSubElement(rootElement, "prop");
                    if (propNode != null) {
                        propertyFindType = 0;
                    }
                    if (XMLHelper.findSubElement(rootElement, "propname") != null) {
                        propertyFindType = 2;
                    }
                    if (XMLHelper.findSubElement(rootElement, "allprop") == null) ** GOTO lbl40
                    propertyFindType = 1;
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    resp.sendError(500);
                    return;
                }
            } else {
                propertyFindType = 1;
            }
lbl40:
            // 5 sources

            namespaces = this.getNamespaces();
            if (propertyFindType == 0) {
                propertyFindType = 0;
                properties = XMLHelper.getPropertiesFromXML(propNode);
            }
            resp.setStatus(207);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/xml ");
            resp.addHeader("DAV", this.getVersion());
            writer = new XMLWriter(resp.getWriter(), namespaces);
            writer.writeXMLHeader();
            writer.writeElement("DAV::multistatus", 0);
            if (depth == 0) {
                this.parseProperties(requestContext, writer, res, path, propertyFindType, properties, depth);
            } else {
                this.recursiveParseProperties(requestContext, writer, res, path, propertyFindType, properties, depth, depth);
            }
            writer.writeElement("DAV::multistatus", 1);
            writer.sendData();
        }
        catch (AccessDeniedException e) {
            resp.sendError(403);
        }
        catch (WebdavException e) {
            new ServiceException((Exception)e).log();
            resp.sendError(500);
        }
    }

    protected void recursiveParseProperties(RequestContext requestContext, XMLWriter writer, Resource res, String path, int propertyFindType, List<String> properties, int currentDepth, int depth) throws WebdavException {
        this.parseProperties(requestContext, writer, res, (String)path, propertyFindType, properties, depth);
        if (currentDepth > 0) {
            Resource parent = this._store.getResourceByPath(requestContext, (String)path);
            Collection<Resource> children = this._store.getChildren(requestContext, parent, null, null);
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            for (Resource child : children) {
                String childPath = (String)path + child.getName();
                this.recursiveParseProperties(requestContext, writer, child, childPath, propertyFindType, properties, currentDepth - 1, depth);
            }
        }
    }

    protected void parseProperties(RequestContext requestContext, XMLWriter writer, Resource res, String path, int type, List<String> propertiesVector, int depth) throws WebdavException {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        boolean isCollection = res.isCollection();
        String creationdate = ((SimpleDateFormat)CREATION_DATE_FORMAT.get()).format(res.getCreationDate());
        String lastModified = ((SimpleDateFormat)LAST_MODIFIED_DATE_FORMAT.get()).format(res.getLastModified());
        Long resourceLength = null;
        writer.writeElement("DAV::response", 0);
        String status = new String("HTTP/1.1 200 OK");
        writer.writeElement("DAV::href", 0);
        writer.writeText(this.encodeURL(resp, this.getHRef(req, path, isCollection)));
        writer.writeElement("DAV::href", 1);
        String displayName = res.getDisplayName();
        switch (type) {
            case 1: {
                writer.writeElement("DAV::propstat", 0);
                writer.writeElement("DAV::prop", 0);
                writer.writeProperty("DAV::creationdate", creationdate);
                writer.writeProperty("DAV::getlastmodified", lastModified);
                writer.writeElement("DAV::displayname", 0);
                writer.writeData(displayName);
                writer.writeElement("DAV::displayname", 1);
                if (!isCollection) {
                    if (resourceLength == null) {
                        try {
                            resourceLength = this._store.getResourceContent(requestContext, res).getLength();
                        }
                        catch (Exception e) {
                            resourceLength = 0L;
                        }
                    }
                    writer.writeProperty("DAV::getcontentlength", Long.toString(resourceLength));
                    String contentType = this._store.getMimeType(res);
                    if (contentType != null) {
                        writer.writeProperty("DAV::getcontenttype", contentType);
                    }
                    writer.writeProperty("DAV::getetag", this.getETag(res));
                    writer.writeElement("DAV::resourcetype", 2);
                } else {
                    writer.writeElement("DAV::resourcetype", 0);
                    writer.writeElement("DAV::collection", 2);
                    this.writeCollectionType(requestContext, writer, res);
                    writer.writeElement("DAV::resourcetype", 1);
                }
                this.writeSupportedPrivilegeElements(requestContext, writer, path);
                this.writeSupportedLockElements(requestContext, writer, path);
                this.writeLockDiscoveryElements(requestContext, writer, path, depth);
                writer.writeProperty("DAV::source", "");
                writer.writeElement("DAV::prop", 1);
                writer.writeElement("DAV::status", 0);
                writer.writeText(status);
                writer.writeElement("DAV::status", 1);
                writer.writeElement("DAV::propstat", 1);
                break;
            }
            case 2: {
                writer.writeElement("DAV::propstat", 0);
                writer.writeElement("DAV::prop", 0);
                writer.writeElement("DAV::creationdate", 2);
                writer.writeElement("DAV::displayname", 2);
                if (!isCollection) {
                    writer.writeElement("DAV::getcontentlanguage", 2);
                    writer.writeElement("DAV::getcontentlength", 2);
                    writer.writeElement("DAV::getcontenttype", 2);
                    writer.writeElement("DAV::getetag", 2);
                    writer.writeElement("DAV::getlastmodified", 2);
                }
                writer.writeElement("DAV::resourcetype", 2);
                writer.writeElement("DAV::supportedlock", 2);
                writer.writeElement("DAV::source", 2);
                writer.writeElement("DAV::prop", 1);
                writer.writeElement("DAV::status", 0);
                writer.writeText(status);
                writer.writeElement("DAV::status", 1);
                writer.writeElement("DAV::propstat", 1);
                break;
            }
            case 0: {
                ArrayList<String> propertiesNotFound = new ArrayList<String>();
                writer.writeElement("DAV::propstat", 0);
                writer.writeElement("DAV::prop", 0);
                for (String property : propertiesVector) {
                    if (property.indexOf("creationdate") > 0) {
                        writer.writeProperty("DAV::creationdate", creationdate);
                        continue;
                    }
                    if (property.indexOf("displayname") > 0) {
                        writer.writeElement("DAV::displayname", 0);
                        writer.writeData(displayName);
                        writer.writeElement("DAV::displayname", 1);
                        continue;
                    }
                    if (property.indexOf("getcontentlanguage") > 0) {
                        if (isCollection) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        writer.writeElement("DAV::getcontentlanguage", 2);
                        continue;
                    }
                    if (property.indexOf("getcontentlength") > 0) {
                        if (isCollection) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        if (resourceLength == null) {
                            try {
                                resourceLength = this._store.getResourceContent(requestContext, res).getLength();
                            }
                            catch (Exception e) {
                                resourceLength = 0L;
                            }
                        }
                        writer.writeProperty("DAV::getcontentlength", Long.toString(resourceLength));
                        continue;
                    }
                    if (property.indexOf("getcontenttype") > 0) {
                        writer.writeProperty("DAV::getcontenttype", this._store.getMimeType(res));
                        continue;
                    }
                    if (property.indexOf("getetag") > 0) {
                        if (isCollection) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        writer.writeProperty("DAV::getetag", this.getETag(res));
                        continue;
                    }
                    if (property.equals("DAV::getlastmodified")) {
                        if (isCollection) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        writer.writeProperty("DAV::getlastmodified", lastModified);
                        continue;
                    }
                    if (property.indexOf("resourcetype") > 0) {
                        if (isCollection) {
                            writer.writeElement("DAV::resourcetype", 0);
                            writer.writeElement("DAV::collection", 2);
                            this.writeCollectionType(requestContext, writer, res);
                            writer.writeElement("DAV::resourcetype", 1);
                            continue;
                        }
                        writer.writeElement("DAV::resourcetype", 2);
                        continue;
                    }
                    if (property.indexOf("source") > 0) {
                        writer.writeProperty("DAV::source", "");
                        continue;
                    }
                    if (property.indexOf("supportedlock") > 0) {
                        this.writeSupportedLockElements(requestContext, writer, path);
                        continue;
                    }
                    if (property.indexOf("lockdiscovery") > 0) {
                        this.writeLockDiscoveryElements(requestContext, writer, path, depth);
                        continue;
                    }
                    if (this.handleExtension(requestContext, writer, req.getContextPath(), res, property)) continue;
                    propertiesNotFound.add(property);
                }
                writer.writeElement("DAV::prop", 1);
                writer.writeElement("DAV::status", 0);
                writer.writeText(status);
                writer.writeElement("DAV::status", 1);
                writer.writeElement("DAV::propstat", 1);
                Iterator propertiesNotFoundList = propertiesNotFound.iterator();
                if (!propertiesNotFoundList.hasNext()) break;
                status = new String("HTTP/1.1 404 Not Found");
                writer.writeElement("DAV::propstat", 0);
                writer.writeElement("DAV::prop", 0);
                while (propertiesNotFoundList.hasNext()) {
                    writer.writeElement((String)propertiesNotFoundList.next(), 2);
                }
                writer.writeElement("DAV::prop", 1);
                writer.writeElement("DAV::status", 0);
                writer.writeText(status);
                writer.writeElement("DAV::status", 1);
                writer.writeElement("DAV::propstat", 1);
            }
        }
        writer.writeElement("DAV::response", 1);
    }

    protected void writeSupportedPrivilegeElements(RequestContext requestContext, XMLWriter writer, String path) {
        writer.writeElement("DAV::current-user-privilege-set", 0);
        writer.writeElement("DAV::privilege", 0);
        writer.writeElement("DAV::all", 2);
        writer.writeElement("DAV::read", 2);
        writer.writeElement("DAV::write", 2);
        writer.writeElement("DAV::privilege", 1);
        writer.writeElement("DAV::current-user-privilege-set", 1);
    }

    protected void writeSupportedLockElements(RequestContext requestContext, XMLWriter writer, String path) {
        writer.writeElement("DAV::supportedlock", 0);
        List<Lock> los = this._store.getLocksByPath(requestContext, path);
        if (los.isEmpty()) {
            writer.writeElement("DAV::lockentry", 0);
            writer.writeElement("DAV::lockscope", 0);
            writer.writeElement("DAV::exclusive", 2);
            writer.writeElement("DAV::lockscope", 1);
            writer.writeElement("DAV::locktype", 0);
            writer.writeElement("DAV::write", 2);
            writer.writeElement("DAV::locktype", 1);
            writer.writeElement("DAV::lockentry", 1);
            writer.writeElement("DAV::lockentry", 0);
            writer.writeElement("DAV::lockscope", 0);
            writer.writeElement("DAV::shared", 2);
            writer.writeElement("DAV::lockscope", 1);
            writer.writeElement("DAV::locktype", 0);
            writer.writeElement("DAV::write", 2);
            writer.writeElement("DAV::locktype", 1);
            writer.writeElement("DAV::lockentry", 1);
        } else {
            for (Lock lo : los) {
                if (!"shared".equals(lo.getScope())) continue;
                writer.writeElement("DAV::lockentry", 0);
                writer.writeElement("DAV::lockscope", 0);
                writer.writeElement("DAV::shared", 2);
                writer.writeElement("DAV::lockscope", 1);
                writer.writeElement("DAV::locktype", 0);
                writer.writeElement("DAV::" + lo.getType(), 2);
                writer.writeElement("DAV::locktype", 1);
                writer.writeElement("DAV::lockentry", 1);
            }
        }
        writer.writeElement("DAV::supportedlock", 1);
    }

    protected void writeLockDiscoveryElements(RequestContext requestContext, XMLWriter writer, String path, int _depth) {
        writer.writeElement("DAV::lockdiscovery", 0);
        List<Lock> locks = this._store.getLocksByPath(requestContext, path);
        for (Lock lock : locks) {
            if (lock == null || System.currentTimeMillis() >= lock.getExpiresAt()) continue;
            writer.writeElement("DAV::activelock", 0);
            writer.writeElement("DAV::locktype", 0);
            writer.writeProperty("DAV::" + lock.getType());
            writer.writeElement("DAV::locktype", 1);
            writer.writeElement("DAV::lockscope", 0);
            if ("exclusive".equals(lock.getScope())) {
                writer.writeProperty("DAV::exclusive");
            } else {
                writer.writeProperty("DAV::shared");
            }
            writer.writeElement("DAV::lockscope", 1);
            writer.writeElement("DAV::depth", 0);
            if (_depth == 3) {
                writer.writeText("Infinity");
            } else {
                writer.writeText(String.valueOf(_depth));
            }
            writer.writeElement("DAV::depth", 1);
            writer.writeElement("DAV::owner", 0);
            writer.writeElement("DAV::href", 0);
            writer.writeText(lock.getOwner());
            writer.writeElement("DAV::href", 1);
            writer.writeElement("DAV::owner", 1);
            int timeout = (int)((lock.getExpiresAt() - System.currentTimeMillis()) / 1000L);
            String timeoutStr = new Integer(timeout).toString();
            writer.writeElement("DAV::timeout", 0);
            writer.writeText("Second-" + timeoutStr);
            writer.writeElement("DAV::timeout", 1);
            String lockToken = lock.getID();
            writer.writeElement("DAV::locktoken", 0);
            writer.writeElement("DAV::href", 0);
            writer.writeText("opaquelocktoken:" + lockToken);
            writer.writeElement("DAV::href", 1);
            writer.writeElement("DAV::locktoken", 1);
            writer.writeElement("DAV::activelock", 1);
        }
        writer.writeElement("DAV::lockdiscovery", 1);
    }
}

