/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.webdav;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.webdav.DocumentFolderResource;
import org.opencrx.application.webdav.DocumentResource;
import org.opencrx.application.webdav.WebDavResource;
import org.opencrx.kernel.document1.cci2.DocumentBasedFolderEntryQuery;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.cci2.DocumentQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentBasedFolderEntry;
import org.opencrx.kernel.document1.jmi1.DocumentFilterGlobal;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.generic.ChainingCollection;
import org.openmdx.base.collection.MarshallingCollection;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.marshalling.Marshaller;

public abstract class DocumentCollectionResource
extends WebDavResource {
    public DocumentCollectionResource(RequestContext requestContext, DocumentFolder documentFolder) {
        super(requestContext, documentFolder);
    }

    public DocumentCollectionResource(RequestContext requestContext, DocumentFilterGlobal documentFilter) {
        super(requestContext, documentFilter);
    }

    @Override
    public String getDisplayName() {
        Set features = this.getObject().refDefaultFetchGroup();
        String name = this.getName();
        if (features.contains("name")) {
            name = (String)this.getObject().refGetValue("name");
        }
        return name;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public String getName() {
        BasicObject documentCollection = this.getObject();
        if (documentCollection instanceof DocumentFolder) {
            return ((DocumentFolder)documentCollection).getName();
        }
        if (documentCollection instanceof DocumentFilterGlobal) {
            return ((DocumentFilterGlobal)documentCollection).getName();
        }
        return "NA";
    }

    public DocumentBasedFolderEntryQuery getFolderEntryQuery() {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)this.getObject());
        DocumentBasedFolderEntryQuery query = (DocumentBasedFolderEntryQuery)pm.newQuery(DocumentBasedFolderEntry.class);
        query.forAllDisabled().isFalse();
        query.orderByCreatedAt().ascending();
        return query;
    }

    public DocumentFolderQuery getFolderQuery() {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)this.getObject());
        DocumentFolderQuery query = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
        query.forAllDisabled().isFalse();
        return query;
    }

    public DocumentQuery getDocumentQuery() {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)this.getObject());
        DocumentQuery query = (DocumentQuery)pm.newQuery(Document.class);
        query.forAllDisabled().isFalse();
        query.orderByCreatedAt().ascending();
        return query;
    }

    public Collection<Resource> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        BasicObject documentCollection = this.getObject();
        if (documentCollection instanceof DocumentFolder) {
            DocumentFolder documentFolder = (DocumentFolder)documentCollection;
            DocumentBasedFolderEntryQuery folderEntryQuery = this.getFolderEntryQuery();
            DocumentResourceCollectionBasedOnFolderEntries documentResourceCollection = new DocumentResourceCollectionBasedOnFolderEntries(this.getRequestContext(), documentFolder.getFolderEntry(folderEntryQuery), this);
            DocumentFolderQuery folderQuery = this.getFolderQuery();
            DocumentFolderResourceCollection documentFolderCollection = new DocumentFolderResourceCollection(this.getRequestContext(), documentFolder.getSubFolder(folderQuery));
            return new ChainingCollection<Resource>(new Collection[]{documentFolderCollection, documentResourceCollection});
        }
        if (documentCollection instanceof DocumentFilterGlobal) {
            DocumentFilterGlobal documentFilterGlobal = (DocumentFilterGlobal)documentCollection;
            DocumentQuery documentQuery = this.getDocumentQuery();
            DocumentResourceCollectionBasedOnDocuments documentResourceCollection = new DocumentResourceCollectionBasedOnDocuments(this.getRequestContext(), documentFilterGlobal.getFilteredDocument(documentQuery), this);
            return documentResourceCollection;
        }
        return Collections.emptyList();
    }

    static class DocumentFolderResourceCollection
    extends MarshallingCollection<Resource> {
        private static final long serialVersionUID = 6284983517339059654L;

        public DocumentFolderResourceCollection(final RequestContext requestContext, Collection<DocumentFolder> entries) {
            super(new Marshaller(){

                public Object marshal(Object source) throws ServiceException {
                    if (source instanceof DocumentFolder) {
                        return new DocumentFolderResource(requestContext, (DocumentFolder)source);
                    }
                    return source;
                }

                public Object unmarshal(Object source) throws ServiceException {
                    if (source instanceof WebDavResource) {
                        return ((WebDavResource)source).getObject();
                    }
                    return source;
                }
            }, entries);
        }
    }

    static class DocumentResourceCollectionBasedOnDocuments
    extends MarshallingCollection<Resource> {
        private static final long serialVersionUID = -4267414630873757556L;

        public DocumentResourceCollectionBasedOnDocuments(final RequestContext requestContext, Collection<Document> entries, final DocumentCollectionResource parentCollection) {
            super(new Marshaller(){

                public Object marshal(Object source) throws ServiceException {
                    if (source instanceof Document) {
                        return new DocumentResource(requestContext, (Document)source, parentCollection);
                    }
                    return source;
                }

                public Object unmarshal(Object source) throws ServiceException {
                    if (source instanceof WebDavResource) {
                        return ((WebDavResource)source).getObject();
                    }
                    return source;
                }
            }, entries);
        }
    }

    static class DocumentResourceCollectionBasedOnFolderEntries
    extends MarshallingCollection<Resource> {
        private static final long serialVersionUID = 6257982279508324945L;

        public DocumentResourceCollectionBasedOnFolderEntries(final RequestContext requestContext, Collection<DocumentBasedFolderEntry> entries, final DocumentCollectionResource parentCollection) {
            super(new Marshaller(){

                public Object marshal(Object source) throws ServiceException {
                    if (source instanceof DocumentBasedFolderEntry) {
                        return new DocumentResource(requestContext, (Document)((DocumentBasedFolderEntry)source).getDocument(), parentCollection);
                    }
                    return source;
                }

                public Object unmarshal(Object source) throws ServiceException {
                    if (source instanceof WebDavResource) {
                        return ((WebDavResource)source).getObject();
                    }
                    return source;
                }
            }, entries);
        }
    }
}

