/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.activity1.cci2.ActivityGroupIsCreatedBy;
import org.opencrx.kernel.activity1.cci2.ActivityProcessTransitionQuery;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.cci2.EMailRecipientQuery;
import org.opencrx.kernel.activity1.cci2.IncidentPartyQuery;
import org.opencrx.kernel.activity1.cci2.MeetingPartyQuery;
import org.opencrx.kernel.activity1.cci2.NewActivityParams;
import org.opencrx.kernel.activity1.cci2.TaskPartyQuery;
import org.opencrx.kernel.activity1.jmi1.Absence;
import org.opencrx.kernel.activity1.jmi1.AbstractActivityParty;
import org.opencrx.kernel.activity1.jmi1.AbstractFilterActivity;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityProcess;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessState;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessTransition;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.EMailRecipient;
import org.opencrx.kernel.activity1.jmi1.ExternalActivity;
import org.opencrx.kernel.activity1.jmi1.Incident;
import org.opencrx.kernel.activity1.jmi1.IncidentParty;
import org.opencrx.kernel.activity1.jmi1.Mailing;
import org.opencrx.kernel.activity1.jmi1.Meeting;
import org.opencrx.kernel.activity1.jmi1.MeetingParty;
import org.opencrx.kernel.activity1.jmi1.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.NewActivityResult;
import org.opencrx.kernel.activity1.jmi1.PhoneCall;
import org.opencrx.kernel.activity1.jmi1.Resource;
import org.opencrx.kernel.activity1.jmi1.Task;
import org.opencrx.kernel.activity1.jmi1.TaskParty;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.base.cci2.ImportItemParams;
import org.opencrx.kernel.base.jmi1.ImportItemParams;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.cci2.TimerQuery;
import org.opencrx.kernel.home1.jmi1.Timer;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.ActivityQueryHelper;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.cci2.ContextCapable;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class ICalendar
extends AbstractImpl {
    public static final String DATETIME_FORMAT = "yyyyMMdd'T'HHmmss";
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String PROD_ID = "//OPENCRX//V2//EN";
    public static final String MIME_TYPE = "text/calendar";
    public static final String FILE_EXTENSION = ".ics";
    public static final String ICAL_SCHEMA = "ICAL:";
    public static final String ICAL_RECURRENCE_ID_SCHEMA = "ICAL-RECURRENCE-ID:";
    public static final Short USAGE_EMAIL_PRIMARY = new Short(300);
    public static final String X_OPENCRX_RENDER_ALARMS = "X-OPENCRX-RENDER-ALARMS";
    public static final String X_OPENCRX_RENDER_ALARMS_TRUE = "X-OPENCRX-RENDER-ALARMS:TRUE";
    public static final String X_OPENCRX_RENDER_ALARMS_FALSE = "X-OPENCRX-RENDER-ALARMS:FALSE";
    public static final int MIME_TYPE_CODE = 4;
    public static final short ICAL_TYPE_VTODO = 2;
    public static final short ICAL_TYPE_VEVENT = 1;
    public static final short ICAL_TYPE_NA = 0;

    public static void register() {
        ICalendar.registerImpl(new ICalendar());
    }

    public static ICalendar getInstance() throws ServiceException {
        return ICalendar.getInstance(ICalendar.class);
    }

    protected ICalendar() {
    }

    private String escapeControlChars(String from) {
        if (from == null) {
            return null;
        }
        Object to = "";
        for (int i = 0; i < from.length(); ++i) {
            char c = from.charAt(i);
            to = c == '\n' ? (String)to + "\\n" : (!Character.isValidCodePoint(c) || c < ' ' ? (String)to + " " : (String)to + c);
        }
        return to;
    }

    private String escapeCommas(String from) {
        return from.replace("\\,", ",").replace(",", "\\,");
    }

    protected boolean isFlagRenderAlarms(Activity activity) {
        return !JDOHelper.isNew((Object)activity) && !activity.getAssignedTimer().isEmpty();
    }

    public String mergeIcal(Activity activity, String sourceIcal, List<String> statusMessage) throws ServiceException {
        Short percentComplete;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)activity);
        int icalType = activity.getIcalType();
        if (icalType == 0) {
            if (sourceIcal != null && ((String)sourceIcal).indexOf("BEGIN:VEVENT") > 0) {
                icalType = 1;
            } else if (sourceIcal != null && ((String)sourceIcal).indexOf("BEGIN:VTODO") > 0) {
                icalType = 2;
            } else {
                ActivityCreator activityCreator = null;
                try {
                    activityCreator = activity.getLastAppliedCreator();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (activityCreator != null && activityCreator.getIcalType() != 0) {
                    icalType = activityCreator.getIcalType();
                } else if (activity instanceof Absence) {
                    icalType = 1;
                } else if (activity instanceof EMail) {
                    icalType = 1;
                } else if (activity instanceof ExternalActivity) {
                    icalType = 1;
                } else if (activity instanceof Incident) {
                    icalType = 2;
                } else if (activity instanceof Mailing) {
                    icalType = 1;
                } else if (activity instanceof Meeting) {
                    icalType = 1;
                } else if (activity instanceof PhoneCall) {
                    icalType = 1;
                } else if (activity instanceof Task) {
                    icalType = 2;
                }
            }
        }
        Object dtStart = null;
        if (activity.getScheduledStart() != null) {
            dtStart = DateTimeFormat.BASIC_UTC_FORMAT.format(activity.getScheduledStart());
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            dtStart = cal.get(1) + "0101T000000.000Z";
        }
        String dtEnd = null;
        if (activity.getScheduledEnd() != null) {
            dtEnd = DateTimeFormat.BASIC_UTC_FORMAT.format(activity.getScheduledEnd());
        }
        String recurrenceRule = null;
        if (activity.getRecurrenceRule() != null) {
            recurrenceRule = activity.getRecurrenceRule();
        }
        String dueBy = null;
        if (activity.getDueBy() != null) {
            dueBy = DateTimeFormat.BASIC_UTC_FORMAT.format(activity.getDueBy());
        }
        String completed = null;
        if (activity.getActualEnd() != null) {
            completed = DateTimeFormat.BASIC_UTC_FORMAT.format(activity.getActualEnd());
        }
        String lastModified = DateTimeFormat.BASIC_UTC_FORMAT.format(new Date());
        Short priority = activity.getPriority();
        Object summary = activity.getName() == null ? "" : activity.getName();
        summary = (String)summary + (String)(activity.getActivityNumber() == null ? "" : " // #" + activity.getActivityNumber());
        String misc1 = activity.getMisc1();
        if (misc1 != null && misc1.startsWith("[") && misc1.endsWith("]")) {
            summary = (String)summary + " " + misc1;
        }
        String description = activity.getDescription() == null ? "" : activity.getDescription();
        String location = activity.getLocation() == null ? "" : activity.getLocation();
        String status = null;
        ICalClass icalClass = ICalClass.valueOf(activity.getIcalClass());
        if (icalType == 2) {
            percentComplete = activity.getPercentComplete();
            status = Boolean.TRUE.equals(activity.isDisabled()) ? "CANCELLED" : (percentComplete == null || ((Number)percentComplete).intValue() == 0 ? "NEEDS-ACTION" : (percentComplete != null && ((Number)percentComplete).intValue() >= 100 ? (activity.getActivityState() == Activities.ActivityState.CANCELLED.getValue() ? "CANCELLED" : "COMPLETED") : "IN-PROCESS"));
        } else {
            percentComplete = activity.getPercentComplete();
            status = Boolean.TRUE.equals(activity.isDisabled()) ? "CANCELLED" : (percentComplete == null || ((Number)percentComplete).intValue() == 0 ? "TENTATIVE" : (percentComplete != null && ((Number)percentComplete).intValue() < 100 ? "CONFIRMED" : (activity.getActivityState() == Activities.ActivityState.CANCELLED.getValue() ? "CANCELLED" : "COMPLETED")));
        }
        ArrayList<CallSite> attendees = new ArrayList<CallSite>();
        List<AbstractActivityParty> parties = Activities.getInstance().getActivityParties(activity);
        String organizerEMail = null;
        for (AbstractActivityParty party : parties) {
            RefObject_1_0 partyHolder = null;
            try {
                partyHolder = (RefObject_1_0)party.refGetValue("party");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (partyHolder == null) continue;
            try {
                String fullName;
                Account account = null;
                String emailAddress = null;
                if (partyHolder instanceof Account) {
                    account = (Account)partyHolder;
                    emailAddress = Accounts.getInstance().getPrimaryBusinessEMail(account, party.getEmailHint());
                } else if (partyHolder instanceof EMailAddress) {
                    account = (Account)pm.getObjectById((Object)partyHolder.refGetPath().getParent().getParent());
                    emailAddress = ((EMailAddress)partyHolder).getEmailAddress();
                }
                if (emailAddress == null) continue;
                if (party.getPartyType() == Activities.PartyType.ORGANIZER.getValue() || party.getPartyType() == Activities.PartyType.EMAIL_FROM.getValue()) {
                    organizerEMail = emailAddress;
                    continue;
                }
                String partyType = null;
                if (party.getPartyType() == Activities.PartyType.OPTIONAL.getValue() || party.getPartyType() == Activities.PartyType.EMAIL_CC.getValue()) {
                    partyType = "OPT-PARTICIPANT";
                } else if (party.getPartyType() == Activities.PartyType.REQUIRED.getValue() || party.getPartyType() == Activities.PartyType.EMAIL_TO.getValue()) {
                    partyType = "REQ-PARTICIPANT";
                } else if (party.getPartyType() != Activities.PartyType.EMAIL_BCC.getValue()) {
                    partyType = "NON-PARTICIPANT";
                }
                if (partyType == null) continue;
                String partyStatus = null;
                if (party.getPartyStatus() == Activities.PartyStatus.NEEDS_ACTION.getValue()) {
                    partyStatus = "NEEDS-ACTION";
                } else if (party.getPartyStatus() == Activities.PartyStatus.ACCEPTED.getValue()) {
                    partyStatus = "ACCEPTED";
                } else if (party.getPartyStatus() == Activities.PartyStatus.DECLINED.getValue()) {
                    partyStatus = "DECLINED";
                } else if (party.getPartyStatus() == Activities.PartyStatus.TENTATIVE.getValue()) {
                    partyStatus = "TENTATIVE";
                } else if (party.getPartyStatus() == Activities.PartyStatus.DELEGATED.getValue()) {
                    partyStatus = "DELEGATED";
                } else if (party.getPartyStatus() == Activities.PartyStatus.COMPLETED.getValue()) {
                    partyStatus = "COMPLETED";
                }
                String string = fullName = account == null ? null : account.getFullName();
                if (fullName == null || fullName.startsWith("admin" + SecurityKeys.ID_SEPARATOR)) {
                    attendees.add((CallSite)((Object)(";CN=" + emailAddress + (String)(partyStatus == null ? "" : ";PARTSTAT=" + partyStatus) + ";ROLE=" + partyType + ";RSVP=TRUE:MAILTO:" + emailAddress)));
                    continue;
                }
                attendees.add((CallSite)((Object)(";CN=\"" + fullName + " (" + emailAddress + ")\"" + (String)(partyStatus == null ? "" : ";PARTSTAT=" + partyStatus) + ";ROLE=" + partyType + ";RSVP=TRUE:MAILTO:" + emailAddress)));
            }
            catch (ServiceException e) {
                if (e.getExceptionCode() == -9) continue;
                throw e;
            }
        }
        if (organizerEMail == null) {
            if (activity.getAssignedTo() != null) {
                organizerEMail = Accounts.getInstance().getPrimaryBusinessEMail(activity.getAssignedTo(), null);
            } else if (activity.getReportingContact() != null) {
                organizerEMail = Accounts.getInstance().getPrimaryBusinessEMail(activity.getReportingContact(), null);
            }
        }
        boolean flagRenderAlarms = this.isFlagRenderAlarms(activity);
        if (!statusMessage.isEmpty()) {
            return null;
        }
        if (sourceIcal == null || ((String)sourceIcal).isEmpty()) {
            UUID uid = null;
            try {
                uid = UUIDConversion.fromString((String)activity.refGetPath().getLastSegment().toString());
            }
            catch (Exception e) {
                uid = UUIDs.newUUID();
            }
            sourceIcal = "BEGIN:VCALENDAR\nPRODID://OPENCRX//V2//EN\nVERSION:2.0\n" + (icalType == 2 ? "BEGIN:VTODO\n" : "BEGIN:VEVENT\n") + "UID:" + UUIDConversion.toUID((UUID)uid) + "\nLAST-MODIFIED:" + lastModified.substring(0, 15) + "Z\nDTSTART:\nDTEND:\nDUE:\nCOMPLETED:\nLOCATION:\nDTSTAMP:\nSUMMARY:\nDESCRIPTION:\nPRIORITY:\nSTATUS:\nATTENDEE:\nCLASS:" + icalClass.name() + "\n" + (flagRenderAlarms ? X_OPENCRX_RENDER_ALARMS_TRUE : X_OPENCRX_RENDER_ALARMS_FALSE) + "\n" + (icalType == 2 ? "END:VTODO\n" : "END:VEVENT\n") + "END:VCALENDAR";
        }
        try {
            QuotaByteArrayOutputStream targetIcalBos = new QuotaByteArrayOutputStream(ICalendar.class.getName());
            PrintWriter targetIcal = new PrintWriter(new OutputStreamWriter((OutputStream)targetIcalBos, "UTF-8"));
            String lSourceIcal = null;
            BufferedReader readerSourceIcal = new BufferedReader(new StringReader((String)sourceIcal));
            boolean isEventOrTodo = false;
            boolean isAlarm = false;
            boolean isTimezone = false;
            String tagStart = null;
            int nEvents = 0;
            while ((lSourceIcal = readerSourceIcal.readLine()) != null) {
                if (!lSourceIcal.startsWith(" ")) {
                    tagStart = lSourceIcal;
                }
                if (lSourceIcal.startsWith("PRODID") || lSourceIcal.startsWith("prodid")) {
                    targetIcal.println("PRODID://OPENCRX//V2//EN");
                    continue;
                }
                if (lSourceIcal.startsWith("TZID") || lSourceIcal.startsWith("tzid")) continue;
                if (lSourceIcal.toUpperCase().startsWith("BEGIN:VTIMEZONE")) {
                    isTimezone = true;
                    continue;
                }
                if (lSourceIcal.toUpperCase().startsWith("END:VTIMEZONE")) {
                    isTimezone = false;
                    continue;
                }
                if (lSourceIcal.toUpperCase().startsWith("BEGIN:VALARM")) {
                    targetIcal.println("BEGIN:VALARM");
                    isAlarm = true;
                    continue;
                }
                if (lSourceIcal.toUpperCase().startsWith("END:VALARM")) {
                    targetIcal.println("END:VALARM");
                    isAlarm = false;
                    continue;
                }
                if (lSourceIcal.toUpperCase().startsWith("BEGIN:VEVENT") || lSourceIcal.toUpperCase().startsWith("BEGIN:VTODO")) {
                    targetIcal.println(icalType == 2 ? "BEGIN:VTODO" : "BEGIN:VEVENT");
                    isEventOrTodo = true;
                    continue;
                }
                if (nEvents == 0 && lSourceIcal.toUpperCase().startsWith("END:VEVENT") || lSourceIcal.toUpperCase().startsWith("END:VTODO")) {
                    boolean isAllDay;
                    boolean bl = isAllDay = !(dtStart == null || !((String)dtStart).endsWith("T000000.000Z") && !((String)dtStart).endsWith("T000000Z") || dtEnd == null || !dtEnd.endsWith("T000000.000Z") && !dtEnd.endsWith("T000000Z"));
                    if (icalClass != null) {
                        targetIcal.println("CLASS:" + icalClass.name());
                    }
                    if (dtStart != null) {
                        if (isAllDay) {
                            targetIcal.println("DTSTART;VALUE=DATE:" + ((String)dtStart).substring(0, 8));
                        } else {
                            targetIcal.println("DTSTART:" + ((String)dtStart).substring(0, 15) + "Z");
                        }
                    }
                    if (dtEnd != null) {
                        if (isAllDay) {
                            targetIcal.println("DTEND;VALUE=DATE:" + dtEnd.substring(0, 8));
                        } else {
                            targetIcal.println("DTEND:" + dtEnd.substring(0, 15) + "Z");
                        }
                    }
                    if (recurrenceRule != null) {
                        targetIcal.println("RRULE:" + recurrenceRule);
                    }
                    if (dueBy != null) {
                        if (dueBy.endsWith("T000000.000Z")) {
                            targetIcal.println("DUE;VALUE=DATE:" + dueBy.substring(0, 8));
                        } else {
                            targetIcal.println("DUE:" + dueBy.substring(0, 15) + "Z");
                        }
                    }
                    if (completed != null) {
                        if (completed.endsWith("T000000.000Z")) {
                            targetIcal.println("COMPLETED;VALUE=DATE:" + completed.substring(0, 8));
                        } else {
                            targetIcal.println("COMPLETED:" + completed.substring(0, 15) + "Z");
                        }
                    }
                    if (lastModified != null) {
                        targetIcal.println("LAST-MODIFIED:" + lastModified.substring(0, 15) + "Z");
                    }
                    if (location != null && !location.isEmpty()) {
                        targetIcal.println("LOCATION:" + this.escapeControlChars(this.escapeCommas(location)));
                    }
                    targetIcal.println("DTSTAMP:" + DateTimeFormat.BASIC_UTC_FORMAT.format(new Date()).substring(0, 15) + "Z");
                    if (description != null && !description.isEmpty()) {
                        targetIcal.println("DESCRIPTION:" + this.escapeControlChars(description));
                    }
                    if (summary != null && !((String)summary).isEmpty()) {
                        targetIcal.println("SUMMARY:" + (String)summary);
                    }
                    if (priority != null) {
                        int icalPriority = 9;
                        switch (((Number)priority).intValue()) {
                            case 1: {
                                icalPriority = 9;
                                break;
                            }
                            case 2: {
                                icalPriority = 5;
                                break;
                            }
                            case 3: {
                                icalPriority = 3;
                                break;
                            }
                            case 4: {
                                icalPriority = 2;
                                break;
                            }
                            case 5: {
                                icalPriority = 1;
                            }
                        }
                        targetIcal.println("PRIORITY:" + icalPriority);
                    }
                    if (status != null) {
                        targetIcal.println("STATUS:" + status);
                    }
                    for (int i = 0; i < attendees.size(); ++i) {
                        targetIcal.println("ATTENDEE" + (String)attendees.get(i));
                    }
                    if (organizerEMail != null) {
                        targetIcal.println("ORGANIZER:MAILTO:" + organizerEMail);
                    }
                    targetIcal.println(flagRenderAlarms ? X_OPENCRX_RENDER_ALARMS_TRUE : X_OPENCRX_RENDER_ALARMS_FALSE);
                    if (lSourceIcal.toUpperCase().startsWith("END:VEVENT") || lSourceIcal.toUpperCase().startsWith("END:VTODO")) {
                        targetIcal.println(icalType == 2 ? "END:VTODO" : "END:VEVENT");
                    }
                    isEventOrTodo = false;
                    ++nEvents;
                    continue;
                }
                if (isTimezone) continue;
                if (isEventOrTodo && !isAlarm && nEvents == 0) {
                    boolean isUpdatableTag = tagStart.toUpperCase().startsWith("DTSTART");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("DTEND");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("RRULE");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("DUE");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("COMPLETED");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("LOCATION");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("DTSTAMP");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("DESCRIPTION");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("LAST-MODIFIED");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("SUMMARY");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("PRIORITY");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("STATUS");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("ATTENDEE");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("ORGANIZER");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("CLASS");
                    if (isUpdatableTag |= tagStart.toUpperCase().startsWith(X_OPENCRX_RENDER_ALARMS)) continue;
                    targetIcal.println(lSourceIcal);
                    continue;
                }
                targetIcal.println(lSourceIcal);
            }
            targetIcal.flush();
            targetIcalBos.close();
            try {
                return targetIcalBos.toString("UTF-8");
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public void removeProprietaryProperties(Map<String, ICalField> ical) {
        Iterator<String> i = ical.keySet().iterator();
        while (i.hasNext()) {
            String prop = i.next();
            if (!prop.startsWith("X-")) continue;
            i.remove();
        }
    }

    public Map<String, ICalField> parseICal(BufferedReader reader, StringBuilder icalAsString) throws ServiceException {
        HashMap<String, ICalField> ical = new HashMap<String, ICalField>();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                Object lineNoControls = new String();
                for (int i = 0; i < line.length(); ++i) {
                    int ch = line.charAt(i);
                    lineNoControls = (String)lineNoControls + (char)(Character.isWhitespace((char)ch) || ch >= 32 ? ch : 63);
                }
                lines.add((String)lineNoControls);
            }
        }
        catch (Exception line) {
            // empty catch block
        }
        boolean isEvent = false;
        int nEvents = 0;
        try {
            int l = 0;
            while (l < lines.size()) {
                int pos;
                boolean addProperty;
                Object line = (String)lines.get(l++);
                while (l < lines.size() && ((String)lines.get(l)).startsWith(" ")) {
                    line = (String)line + ((String)lines.get(l++)).substring(1);
                }
                if ((((String)line).startsWith("URL:") || ((String)line).startsWith("url:") || ((String)line).startsWith("URL;VALUE=URI:") || ((String)line).startsWith("ATTACH:") || ((String)line).startsWith("attach:")) && Base.getInstance().isAccessUrl(((String)line).substring(((String)line).indexOf(":") + 1))) continue;
                while (((String)line).endsWith("\n")) {
                    line = ((String)line).substring(0, ((String)line).length() - 1);
                }
                while (((String)line).endsWith("\\n")) {
                    line = ((String)line).substring(0, ((String)line).length() - 2);
                }
                if (((String)line).isEmpty()) continue;
                icalAsString.append((String)line).append("\n");
                boolean bl = addProperty = isEvent && nEvents == 0;
                if (((String)line).startsWith("BEGIN:VEVENT") || ((String)line).startsWith("begin:vevent") || ((String)line).startsWith("BEGIN:VTODO") || ((String)line).startsWith("begin:vtodo")) {
                    isEvent = true;
                } else if (((String)line).startsWith("END:VEVENT") || ((String)line).startsWith("end:vevent") || ((String)line).startsWith("END:VTODO") || ((String)line).startsWith("end:vtodo")) {
                    ++nEvents;
                    isEvent = false;
                    addProperty = false;
                }
                if (!addProperty) continue;
                boolean inQuotes = false;
                for (pos = 0; pos < ((String)line).length(); ++pos) {
                    char c = ((String)line).charAt(pos);
                    if (c == '\"') {
                        inQuotes = !inQuotes;
                        continue;
                    }
                    if (c == ':' && !inQuotes) break;
                }
                Object qualifiedFieldName = ((String)line).substring(0, pos);
                String[] fieldNameParts = ((String)qualifiedFieldName).split(";");
                HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
                for (int i = 1; i < fieldNameParts.length; ++i) {
                    String fieldNamePart = fieldNameParts[i];
                    String parameterName = "TYPE";
                    String[] parameterValues = new String[]{};
                    if (fieldNamePart.indexOf("=") > 0) {
                        int index = fieldNamePart.indexOf("=");
                        parameterName = fieldNamePart.substring(0, index);
                        parameterValues = fieldNamePart.substring(index + 1).split(",");
                    } else {
                        parameterName = "TYPE";
                        parameterValues = fieldNamePart.split(",");
                    }
                    if (parameters.get(parameterName) != null) {
                        ((List)parameters.get(parameterName)).addAll(Arrays.asList(parameterValues));
                        continue;
                    }
                    parameters.put(parameterName, new ArrayList<String>(Arrays.asList(parameterValues)));
                }
                if (fieldNameParts.length <= 0 || fieldNameParts[0].isEmpty()) continue;
                String attributeName = fieldNameParts[0];
                String attributeValue = "";
                if (pos < ((String)line).length()) {
                    attributeValue = ((String)line).substring(pos + 1, ((String)line).length()).replace("\\n", "\n").replace("\\", "");
                }
                if (attributeName.equalsIgnoreCase("ATTENDEE") && parameters.get("CN") == null && attributeValue.startsWith("mailto:") || attributeValue.startsWith("MAILTO:")) {
                    String cn = attributeValue.substring(7);
                    qualifiedFieldName = (String)qualifiedFieldName + ";CN=" + cn;
                    parameters.put("CN", Collections.singletonList(cn));
                }
                ICalField existingField = (ICalField)ical.get(qualifiedFieldName);
                ICalField newField = new ICalField(attributeName, attributeValue, parameters);
                if (ical.get(qualifiedFieldName) != null) {
                    SysLog.log((Level)Level.WARNING, (String)"ICAL has duplicate fields. Existing={0}, Ignored={1}, ICAL={2}", (Object[])new Object[]{existingField, newField, lines});
                    continue;
                }
                ical.put((String)qualifiedFieldName, newField);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        this.removeProprietaryProperties(ical);
        return ical;
    }

    public BasicObject importItem(byte[] item, Activity activity, short locale, List<String> errors, List<String> report) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)activity);
        Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, activity.refGetPath().getSegment(2).toString(), activity.refGetPath().getSegment(4).toString());
        ByteArrayInputStream is = new ByteArrayInputStream(item);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder ical = new StringBuilder();
        Map<String, ICalField> icalFields = this.parseICal(reader, ical);
        SysLog.trace((String)"ICalendar", icalFields);
        return this.importItem(ical.toString(), icalFields, activity, accountSegment, locale, errors, report);
    }

    protected Account getAttendeeAsContact(String attendeeAsString, Segment accountSegment, Contact existingContact, short locale, List<String> report) throws ServiceException {
        int pos = attendeeAsString.indexOf("MAILTO:");
        if (pos < 0) {
            pos = attendeeAsString.indexOf("mailto:");
        }
        String emailInternet = attendeeAsString.substring(pos + 7);
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        String providerName = accountSegment.refGetPath().getSegment(2).toString();
        String segmentName = accountSegment.refGetPath().getSegment(4).toString();
        List<EMailAddress> emailAddresses = Accounts.getInstance().lookupEmailAddress(pm, providerName, segmentName, emailInternet);
        if (!emailAddresses.isEmpty()) {
            if (existingContact != null) {
                for (EMailAddress emailAddress : emailAddresses) {
                    if (!emailAddress.refGetPath().startsWith(existingContact.refGetPath())) continue;
                    return existingContact;
                }
            }
            EMailAddress emailAddress = emailAddresses.iterator().next();
            return (Account)pm.getObjectById((Object)emailAddress.refGetPath().getParent().getParent());
        }
        return null;
    }

    protected Date getUtcDate(String dateTime, TimeZone tz) throws ParseException {
        Date date = null;
        if (dateTime.endsWith("Z")) {
            date = dateTime.length() == 16 ? DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime.substring(0, 15) + ".000Z") : DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime);
        } else if (dateTime.length() == 8) {
            date = DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime + "T000000.000Z");
        } else {
            SimpleDateFormat dateTimeFormatter = new SimpleDateFormat(DATETIME_FORMAT);
            dateTimeFormatter.setLenient(false);
            dateTimeFormatter.setTimeZone(tz);
            date = dateTimeFormatter.parse(dateTime);
        }
        return date;
    }

    protected String unescapeField(String s) {
        String t = s.replace("\\\\", "\\");
        t = t.replace("\\;", ";");
        t = t.replace("\\,", ",");
        t = t.replace("\\\"", "\"");
        return t;
    }

    protected void updateActivityPartyType(AbstractActivityParty party, Activities.PartyType newPartyType) {
        switch (newPartyType) {
            case REQUIRED: 
            case OPTIONAL: 
            case ORGANIZER: {
                party.setPartyType(newPartyType.getValue());
                break;
            }
            case NA: {
                if (party.getPartyType() != Activities.PartyType.REQUIRED.getValue() && party.getPartyType() != Activities.PartyType.OPTIONAL.getValue() && party.getPartyType() != Activities.PartyType.ORGANIZER.getValue()) break;
                party.setPartyType(Activities.PartyType.NA.getValue());
                break;
            }
        }
    }

    protected void updateActivityPartyStatus(AbstractActivityParty party, Activities.PartyStatus newPartyStatus) {
        if (newPartyStatus != Activities.PartyStatus.NA) {
            party.setPartyStatus(newPartyStatus.getValue());
        }
    }

    protected List<EMailAddress> mapPartyEMail(PersistenceManager pm, String providerName, String segmentName, String email, Activities.PartyType partyType, Activities.PartyStatus partyStatus) throws ServiceException {
        if (Activities.PartyType.ORGANIZER.equals((Object)partyType)) {
            return Accounts.getInstance().lookupEmailAddress(pm, providerName, segmentName, email, false, true);
        }
        return Accounts.getInstance().lookupEmailAddress(pm, providerName, segmentName, email);
    }

    public Activity importItem(String icalAsString, Map<String, ICalField> ical, Activity activity, Segment accountSegment, short locale, List<String> errors, List<String> report) throws ServiceException {
        String recurrenceRule;
        String dtEnd;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        String providerName = activity.refGetPath().getSegment(2).toString();
        String segmentName = activity.refGetPath().getSegment(4).toString();
        ArrayList<EMailAddress> partyEmails = new ArrayList<EMailAddress>();
        ArrayList<Activities.PartyType> partyTypes = new ArrayList<Activities.PartyType>();
        ArrayList<Activities.PartyStatus> partyStatuses = new ArrayList<Activities.PartyStatus>();
        for (ICalField attendee : ICalField.findFields("ATTENDEE", null, null, ical)) {
            if (attendee.getValue().indexOf("MAILTO:") < 0 && attendee.getValue().indexOf("mailto:") < 0) continue;
            int pos = attendee.getValue().indexOf("MAILTO:");
            if (pos < 0) {
                pos = attendee.getValue().indexOf("mailto:");
            }
            if (pos < 0) continue;
            try {
                Object emailAddresses;
                InternetAddress email = new InternetAddress(attendee.getValue().substring(pos + 7), true);
                Activities.PartyType partyType = Activities.PartyType.REQUIRED;
                if (attendee.getParameters().get("ROLE") != null && !attendee.getParameters().get("ROLE").isEmpty()) {
                    String role = attendee.getParameters().get("ROLE").get(0);
                    partyType = "REQ-PARTICIPANT".equals(role) ? Activities.PartyType.REQUIRED : ("OPT-PARTICIPANT".equals(role) ? Activities.PartyType.OPTIONAL : Activities.PartyType.NA);
                }
                Activities.PartyStatus partyStatus = Activities.PartyStatus.NA;
                if (attendee.getParameters().get("PARTSTAT") != null && !attendee.getParameters().get("PARTSTAT").isEmpty()) {
                    if ("NEEDS-ACTION".equals(attendee.getParameters().get("PARTSTAT").get(0))) {
                        partyStatus = Activities.PartyStatus.NEEDS_ACTION;
                    } else if ("ACCEPTED".equals(attendee.getParameters().get("PARTSTAT").get(0))) {
                        partyStatus = Activities.PartyStatus.ACCEPTED;
                    } else if ("DECLINED".equals(attendee.getParameters().get("PARTSTAT").get(0))) {
                        partyStatus = Activities.PartyStatus.DECLINED;
                    } else if ("TENTATIVE".equals(attendee.getParameters().get("PARTSTAT").get(0))) {
                        partyStatus = Activities.PartyStatus.TENTATIVE;
                    } else if ("DELEGATED".equals(attendee.getParameters().get("PARTSTAT").get(0))) {
                        partyStatus = Activities.PartyStatus.DELEGATED;
                    } else if ("COMPLETED".equals(attendee.getParameters().get("PARTSTAT").get(0))) {
                        partyStatus = Activities.PartyStatus.COMPLETED;
                    } else {
                        partyStatuses.add(Activities.PartyStatus.NA);
                    }
                }
                if ((emailAddresses = this.mapPartyEMail(pm, providerName, segmentName, email.getAddress(), partyType, partyStatus)).isEmpty()) continue;
                partyEmails.add((EMailAddress)emailAddresses.iterator().next());
                partyTypes.add(partyType);
                partyStatuses.add(partyStatus);
            }
            catch (Exception e) {
                ServiceException e0 = new ServiceException(e, "DefaultDomain", -37, "Invalid InternetAddress. Ignoring Attendee.", new BasicException.Parameter[]{new BasicException.Parameter("address", (Object)attendee.getValue())});
                e0.log();
            }
        }
        if (!errors.isEmpty()) {
            return null;
        }
        String s = ICalField.getFieldValue("ORGANIZER", ical);
        if (s != null && !s.isEmpty()) {
            int pos = s.indexOf("MAILTO:");
            if (pos < 0) {
                pos = s.indexOf("mailto:");
            }
            if (pos >= 0) {
                String email = s.substring(pos + 7);
                List<EMailAddress> emailAddresses = Accounts.getInstance().lookupEmailAddress(pm, providerName, segmentName, email, false, true);
                if (!emailAddresses.isEmpty()) {
                    partyEmails.add(emailAddresses.iterator().next());
                    partyTypes.add(Activities.PartyType.ORGANIZER);
                    partyStatuses.add(Activities.PartyStatus.ACCEPTED);
                }
            }
        }
        boolean hasUid = false;
        boolean hasRecurrenceId = false;
        String uid = ical.get("UID") == null ? activity.refGetPath().getLastSegment().toString() : ICalField.getFieldValue("UID", ical);
        String recurrenceId = ICalField.getFieldValue("RECURRENCE-ID", ical);
        ArrayList<Object> externalLinks = new ArrayList<Object>();
        for (String externalLink : activity.getExternalLink()) {
            if (externalLink.startsWith(ICAL_SCHEMA)) {
                externalLinks.add(ICAL_SCHEMA + uid);
                hasUid = true;
                continue;
            }
            if (externalLink.startsWith(ICAL_RECURRENCE_ID_SCHEMA)) {
                if (recurrenceId == null || recurrenceId.isEmpty()) continue;
                externalLinks.add(ICAL_RECURRENCE_ID_SCHEMA + recurrenceId);
                hasRecurrenceId = true;
                continue;
            }
            externalLinks.add(externalLink);
        }
        if (!hasUid) {
            externalLinks.add(ICAL_SCHEMA + uid);
        }
        if (!hasRecurrenceId && recurrenceId != null && !recurrenceId.isEmpty()) {
            externalLinks.add(ICAL_RECURRENCE_ID_SCHEMA + recurrenceId);
        }
        activity.getExternalLink().clear();
        activity.getExternalLink().addAll(externalLinks);
        String dtStart = ICalField.getFieldValue("DTSTART", ical);
        if (dtStart != null && !dtStart.isEmpty()) {
            try {
                activity.setScheduledStart(this.getUtcDate(dtStart, ICalField.getField("DTSTART", null, null, ical).getTimeZone()));
            }
            catch (Exception e) {
                errors.add("DTSTART (" + dtStart + ")");
            }
        }
        if ((dtEnd = ICalField.getFieldValue("DTEND", ical)) != null && !dtEnd.isEmpty()) {
            try {
                activity.setScheduledEnd(this.getUtcDate(dtEnd, ICalField.getField("DTEND", null, null, ical).getTimeZone()));
                if (activity.getScheduledStart() != null && activity.getScheduledEnd().getTime() - activity.getScheduledStart().getTime() == 86400000L && (dtStart.length() > 8 || dtEnd.length() > 8)) {
                    activity.setScheduledEnd(new Date(activity.getScheduledEnd().getTime() - 1000L));
                }
            }
            catch (Exception e) {
                errors.add("DTEND (" + dtEnd + ")");
            }
        }
        if ((recurrenceRule = ICalField.getFieldValue("RRULE", ical)) != null && !recurrenceRule.isEmpty()) {
            activity.setRecurrenceRule(recurrenceRule);
        }
        if ((s = ICalField.getFieldValue("DUE", ical)) != null && !s.isEmpty()) {
            try {
                activity.setDueBy(this.getUtcDate(s, ICalField.getField("DUE", null, null, ical).getTimeZone()));
            }
            catch (Exception e) {
                errors.add("DUE (" + s + ")");
            }
        }
        if ((s = ICalField.getFieldValue("COMPLETED", ical)) != null && !s.isEmpty()) {
            try {
                activity.setActualEnd(this.getUtcDate(s, ICalField.getField("COMPLETED", null, null, ical).getTimeZone()));
            }
            catch (Exception e) {
                errors.add("COMPLETED (" + s + ")");
            }
        } else {
            activity.setActualEnd(null);
        }
        s = ICalField.getFieldValue("PRIORITY", ical);
        if (s != null && !s.isEmpty()) {
            try {
                int priority = 1;
                switch (Integer.valueOf(s)) {
                    case 1: {
                        priority = 5;
                        break;
                    }
                    case 2: {
                        priority = 4;
                        break;
                    }
                    case 3: 
                    case 4: {
                        priority = 3;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        priority = 2;
                        break;
                    }
                    case 9: {
                        priority = 1;
                    }
                }
                activity.setPriority(new Short((short)priority));
            }
            catch (Exception e) {
                errors.add("PRIORITY (" + s + ")");
            }
        }
        if ((s = ICalField.getFieldValue("SUMMARY", ical)) != null && !s.isEmpty()) {
            int posComment = s.startsWith("//") ? 0 : s.lastIndexOf(" //");
            String name = null;
            String misc1 = null;
            if (posComment >= 0) {
                String comment = s.substring(posComment + " //".length());
                name = s.substring(0, posComment).trim();
                int posMiscSuffix = comment.indexOf("[");
                if (posMiscSuffix > 0 && comment.endsWith("]")) {
                    misc1 = comment.substring(posMiscSuffix);
                }
            } else {
                name = s;
            }
            name = this.unescapeField(name);
            if (name.length() > 1000) {
                name = name.substring(0, 1000);
            }
            activity.setName(name);
            if (activity.getMisc1() == null || activity.getMisc1().startsWith("[") && activity.getMisc1().endsWith("]")) {
                activity.setMisc1(misc1 == null ? null : misc1);
            }
        }
        if ((s = ICalField.getFieldValue("DESCRIPTION", ical)) != null && !s.isEmpty()) {
            int posComment = s.startsWith("//") ? 0 : s.lastIndexOf(" //");
            s = posComment >= 0 ? s.substring(0, posComment) : s;
            Object temp = "";
            int pos = 0;
            while ((pos = s.indexOf("\\n")) >= 0) {
                temp = (String)temp + (((String)temp).length() == 0 ? "" : "\n");
                temp = (String)temp + s.substring(0, pos);
                s = s.substring(pos + 2);
            }
            temp = (String)temp + (((String)temp).length() == 0 ? "" : "\n");
            String description = this.unescapeField((String)(temp = (String)temp + s));
            if (description.length() > 1000) {
                description = description.substring(0, 1000);
            }
            activity.setDescription(description);
        }
        if ((s = ICalField.getFieldValue("LOCATION", ical)) != null && !s.isEmpty()) {
            activity.setLocation(this.unescapeField(s));
        }
        if ((s = ICalField.getFieldValue("CLASS", ical)) != null && !s.isEmpty()) {
            try {
                activity.setIcalClass(ICalClass.valueOf(s.toUpperCase()).getValue());
            }
            catch (Exception posComment) {
                // empty catch block
            }
        }
        if ((s = ICalField.getFieldValue("STATUS", ical)) != null && !s.isEmpty() && !JDOHelper.isNew((Object)activity)) {
            Short percentComplete = activity.getPercentComplete();
            if (percentComplete == null) {
                percentComplete = 0;
            }
            if (activity.getProcessState() != null) {
                ActivityProcessState processState = activity.getProcessState();
                ActivityProcess activityProcess = (ActivityProcess)pm.getObjectById((Object)processState.refGetPath().getParent().getParent());
                ActivityProcessTransitionQuery processTransitionQuery = (ActivityProcessTransitionQuery)pm.newQuery(ActivityProcessTransition.class);
                if ("CANCELLED".equalsIgnoreCase(s)) {
                    if (!Boolean.TRUE.equals(activity.isDisabled())) {
                        activity.setDisabled(true);
                    }
                    if (percentComplete < 100) {
                        processTransitionQuery.orderByNewActivityState().ascending();
                        processTransitionQuery.thereExistsNewPercentComplete().equalTo((Object)100);
                    } else {
                        processTransitionQuery = null;
                    }
                } else if ("NEEDS-ACTION".equalsIgnoreCase(s) || "TENTATIVE".equalsIgnoreCase(s)) {
                    if (Boolean.TRUE.equals(activity.isDisabled())) {
                        activity.setDisabled(false);
                    }
                    if (percentComplete != 0) {
                        processTransitionQuery.orderByNewActivityState().descending();
                        processTransitionQuery.thereExistsNewPercentComplete().equalTo((Object)0);
                    } else {
                        processTransitionQuery = null;
                    }
                } else if ("COMPLETED".equalsIgnoreCase(s)) {
                    if (Boolean.TRUE.equals(activity.isDisabled())) {
                        activity.setDisabled(false);
                    }
                    if (percentComplete < 100) {
                        processTransitionQuery.orderByNewActivityState().ascending();
                        processTransitionQuery.thereExistsNewPercentComplete().equalTo((Object)100);
                    } else {
                        processTransitionQuery = null;
                    }
                } else if ("IN-PROCESS".equalsIgnoreCase(s) || "CONFIRMED".equalsIgnoreCase(s)) {
                    if (Boolean.TRUE.equals(activity.isDisabled())) {
                        activity.setDisabled(false);
                    }
                    if (percentComplete <= 0) {
                        processTransitionQuery.orderByNewActivityState().ascending();
                        processTransitionQuery.thereExistsNewPercentComplete().greaterThan((Comparable)Short.valueOf((short)0));
                    } else if (percentComplete >= 100) {
                        processTransitionQuery.orderByNewActivityState().descending();
                        processTransitionQuery.thereExistsNewPercentComplete().lessThan((Comparable)Short.valueOf((short)100));
                    } else {
                        processTransitionQuery = null;
                    }
                }
                if (processTransitionQuery != null) {
                    ActivityProcessTransition processTransition = null;
                    List processTransitions = activityProcess.getTransition(processTransitionQuery);
                    for (ActivityProcessTransition candidate : processTransitions) {
                        if (!candidate.getPrevState().equals(activity.getProcessState())) continue;
                        processTransition = candidate;
                        break;
                    }
                    if (processTransition == null && !processTransitions.isEmpty()) {
                        processTransition = (ActivityProcessTransition)processTransitions.iterator().next();
                    }
                    if (processTransition != null) {
                        Activities.getInstance().doFollowUp(activity, s + " @ " + new Date(), "Set STATUS:" + s, processTransition, null, null, false);
                    }
                }
            }
        }
        activity.setIcal(icalAsString);
        if (!errors.isEmpty()) {
            return null;
        }
        report.add("Update activity");
        ArrayList<Account> accountParties = new ArrayList<Account>();
        for (int i = 0; i < partyEmails.size(); ++i) {
            TaskParty taskParty;
            Account partyHolder;
            EMailAddress partyEmail = (EMailAddress)partyEmails.get(i);
            if (activity instanceof EMail) {
                EMailRecipient emailRecipient;
                EMailRecipientQuery query = (EMailRecipientQuery)pm.newQuery(EMailRecipient.class);
                query.thereExistsParty().equalTo(partyEmail);
                List emailRecipients = ((EMail)activity).getEmailRecipient(query);
                EMailRecipient eMailRecipient = emailRecipient = emailRecipients.isEmpty() ? null : (EMailRecipient)emailRecipients.iterator().next();
                if (emailRecipient == null) {
                    emailRecipient = (EMailRecipient)pm.newInstance(EMailRecipient.class);
                    ((EMail)activity).addEmailRecipient(this.getUidAsString(), emailRecipient);
                }
                emailRecipient.setParty(partyEmail);
                switch ((Activities.PartyType)((Object)partyTypes.get(i))) {
                    case REQUIRED: {
                        emailRecipient.setPartyType(Activities.PartyType.EMAIL_TO.getValue());
                        break;
                    }
                    case OPTIONAL: {
                        emailRecipient.setPartyType(Activities.PartyType.EMAIL_CC.getValue());
                        break;
                    }
                    case ORGANIZER: {
                        emailRecipient.setPartyType(Activities.PartyType.EMAIL_FROM.getValue());
                        break;
                    }
                    default: {
                        emailRecipient.setPartyType(((Activities.PartyType)((Object)partyTypes.get(i))).getValue());
                    }
                }
                this.updateActivityPartyStatus(emailRecipient, (Activities.PartyStatus)((Object)partyStatuses.get(i)));
                emailRecipient.setEmailHint(partyEmail.getEmailAddress());
                continue;
            }
            if (activity instanceof Incident) {
                IncidentParty incidentParty;
                partyHolder = (Account)pm.getObjectById((Object)partyEmail.refGetPath().getParent().getParent());
                IncidentPartyQuery query = (IncidentPartyQuery)pm.newQuery(IncidentParty.class);
                if (partyTypes.get(i) == Activities.PartyType.ORGANIZER) {
                    query.partyType().equalTo((Object)Activities.PartyType.ORGANIZER.getValue());
                } else {
                    query.thereExistsParty().equalTo(partyHolder);
                    if (accountParties.contains(partyHolder)) {
                        query.thereExistsEmailHint().equalTo((Object)partyEmail.getEmailAddress());
                    }
                }
                accountParties.add(partyHolder);
                List incidentParties = ((Incident)activity).getIncidentParty(query);
                IncidentParty incidentParty2 = incidentParty = incidentParties.isEmpty() ? null : (IncidentParty)incidentParties.iterator().next();
                if (incidentParty == null) {
                    incidentParty = (IncidentParty)pm.newInstance(IncidentParty.class);
                    ((Incident)activity).addIncidentParty(this.getUidAsString(), incidentParty);
                }
                incidentParty.setParty(partyHolder);
                this.updateActivityPartyType(incidentParty, (Activities.PartyType)((Object)partyTypes.get(i)));
                this.updateActivityPartyStatus(incidentParty, (Activities.PartyStatus)((Object)partyStatuses.get(i)));
                incidentParty.setEmailHint(partyEmail.getEmailAddress());
                continue;
            }
            if (activity instanceof Mailing) continue;
            if (activity instanceof Meeting) {
                MeetingParty meetingParty;
                partyHolder = (Account)pm.getObjectById((Object)partyEmail.refGetPath().getParent().getParent());
                MeetingPartyQuery query = (MeetingPartyQuery)pm.newQuery(MeetingParty.class);
                if (partyTypes.get(i) == Activities.PartyType.ORGANIZER) {
                    query.partyType().equalTo((Object)Activities.PartyType.ORGANIZER.getValue());
                } else {
                    query.thereExistsParty().equalTo(partyHolder);
                    if (accountParties.contains(partyHolder)) {
                        query.thereExistsEmailHint().equalTo((Object)partyEmail.getEmailAddress());
                    }
                }
                List meetingParties = ((Meeting)activity).getMeetingParty(query);
                MeetingParty meetingParty2 = meetingParty = meetingParties.isEmpty() ? null : (MeetingParty)meetingParties.iterator().next();
                if (meetingParty == null) {
                    meetingParty = (MeetingParty)pm.newInstance(MeetingParty.class);
                    ((Meeting)activity).addMeetingParty(this.getUidAsString(), meetingParty);
                } else if (partyTypes.get(i) == Activities.PartyType.ORGANIZER) {
                    accountParties.add(meetingParty.getParty());
                    continue;
                }
                accountParties.add(partyHolder);
                meetingParty.setParty(partyHolder);
                this.updateActivityPartyType(meetingParty, (Activities.PartyType)((Object)partyTypes.get(i)));
                this.updateActivityPartyStatus(meetingParty, (Activities.PartyStatus)((Object)partyStatuses.get(i)));
                meetingParty.setEmailHint(partyEmail.getEmailAddress());
                continue;
            }
            if (activity instanceof PhoneCall || !(activity instanceof Task)) continue;
            partyHolder = (Account)pm.getObjectById((Object)partyEmail.refGetPath().getParent().getParent());
            TaskPartyQuery query = (TaskPartyQuery)pm.newQuery(TaskParty.class);
            if (partyTypes.get(i) == Activities.PartyType.ORGANIZER) {
                query.partyType().equalTo((Object)Activities.PartyType.ORGANIZER.getValue());
            } else {
                query.thereExistsParty().equalTo(partyHolder);
                if (accountParties.contains(partyHolder)) {
                    query.thereExistsEmailHint().equalTo((Object)partyEmail.getEmailAddress());
                }
            }
            accountParties.add(partyHolder);
            List taskParties = ((Task)activity).getTaskParty(query);
            TaskParty taskParty2 = taskParty = taskParties.isEmpty() ? null : (TaskParty)taskParties.iterator().next();
            if (taskParty == null) {
                taskParty = (TaskParty)pm.newInstance(TaskParty.class);
                ((Task)activity).addTaskParty(this.getUidAsString(), taskParty);
            }
            taskParty.setParty(partyHolder);
            this.updateActivityPartyType(taskParty, (Activities.PartyType)((Object)partyTypes.get(i)));
            this.updateActivityPartyStatus(taskParty, (Activities.PartyStatus)((Object)partyStatuses.get(i)));
            taskParty.setEmailHint(partyEmail.getEmailAddress());
        }
        return activity;
    }

    protected Activity findActivity(ActivityQueryHelper activitiesHelper, String icalUid, String icalRecurrenceId) {
        PersistenceManager pm = activitiesHelper.getPersistenceManager();
        ActivityQuery query = (ActivityQuery)pm.newQuery(Activity.class);
        query.thereExistsExternalLink().equalTo((Object)(ICAL_SCHEMA + icalUid));
        if (icalRecurrenceId == null) {
            query.forAllExternalLink().startsNotWith((Object)ICAL_RECURRENCE_ID_SCHEMA);
        } else {
            query.thereExistsExternalLink().equalTo((Object)(ICAL_RECURRENCE_ID_SCHEMA + icalRecurrenceId));
        }
        Collection<Activity> activities = activitiesHelper.getFilteredActivities(query);
        if (activities.isEmpty()) {
            query = (ActivityQuery)pm.newQuery(Activity.class);
            query.thereExistsExternalLink().equalTo((Object)(ICAL_SCHEMA + icalUid.replace('.', '+')));
            if (icalRecurrenceId == null) {
                query.forAllExternalLink().startsNotWith((Object)ICAL_RECURRENCE_ID_SCHEMA);
            } else {
                query.thereExistsExternalLink().equalTo((Object)(ICAL_RECURRENCE_ID_SCHEMA + icalRecurrenceId));
            }
            activities = activitiesHelper.getFilteredActivities(query);
            if (activities.isEmpty()) {
                return null;
            }
            if (activities.size() > 1) {
                SysLog.warning((String)"Duplicate activities. Will be handled as not found", activities);
                return null;
            }
            return activities.iterator().next();
        }
        if (activities.size() > 1) {
            SysLog.warning((String)"Duplicate activities. Will not update", (Object)activities.iterator().next().refMofId());
            return null;
        }
        return activities.iterator().next();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PutICalResult putICal(BufferedReader reader, ActivityQueryHelper activitiesHelper, boolean allowCreation, String resourceId) throws ServiceException {
        PersistenceManager pm = activitiesHelper.getPersistenceManager();
        PutICalResult.Status status = PutICalResult.Status.UPDATED;
        Activity activity = null;
        String calUID = null;
        try {
            String l;
            while ((l = reader.readLine()) != null) {
                boolean disabledIsModified;
                boolean isEvent = l.startsWith("BEGIN:VEVENT");
                boolean isTodo = l.startsWith("BEGIN:VTODO");
                if (!isEvent && !isTodo) continue;
                Object calendar = "";
                ArrayList<StringBuilder> alarms = new ArrayList<StringBuilder>();
                calendar = (String)calendar + "BEGIN:VCALENDAR\n";
                calendar = (String)calendar + "VERSION:2.0\n";
                calendar = (String)calendar + "PRODID:-//OPENCRX//V2//EN\n";
                calendar = (String)calendar + (isEvent ? "BEGIN:VEVENT\n" : "BEGIN:VTODO\n");
                String recurrenceId = null;
                boolean hasClass = false;
                StringBuilder alarm = null;
                while ((l = reader.readLine()) != null) {
                    if (l.startsWith("BEGIN:VALARM")) {
                        alarm = new StringBuilder();
                        alarms.add(alarm);
                    }
                    if (alarm != null) {
                        alarm.append(l);
                        alarm.append("\n");
                    } else {
                        calendar = (String)calendar + l;
                        calendar = (String)calendar + "\n";
                    }
                    if (l.startsWith("UID:")) {
                        calUID = l.substring(4);
                        continue;
                    }
                    if (l.startsWith("CLASS:")) {
                        hasClass = true;
                        continue;
                    }
                    if (l.startsWith("RECURRENCE-ID:")) {
                        recurrenceId = l.substring(14);
                        continue;
                    }
                    if (l.startsWith("END:VALARM")) {
                        alarm = null;
                        continue;
                    }
                    if (!l.startsWith("END:VEVENT") && !l.startsWith("END:VTODO")) continue;
                }
                calendar = (String)calendar + "END:VCALENDAR\n";
                SysLog.detail((String)"Calendar", (Object)calendar);
                SysLog.detail((String)"Alarms", alarms);
                if (resourceId == null) continue;
                BasicObject source = activitiesHelper.getSource();
                activity = activitiesHelper.getActivitySegment().getActivity(resourceId);
                if (activity != null) {
                    ActivityQuery activityQuery = (ActivityQuery)pm.newQuery(Activity.class);
                    activityQuery.thereExistsActivityNumber().equalTo((Object)activity.getActivityNumber());
                    if (source instanceof ActivityGroup) {
                        ActivityGroup activityGroup = (ActivityGroup)source;
                        activity = activityGroup.getFilteredActivity(activityQuery).isEmpty() ? null : activity;
                    } else if (source instanceof AbstractFilterActivity) {
                        AbstractFilterActivity activityFilter = (AbstractFilterActivity)source;
                        activity = activityFilter.getFilteredActivity(activityQuery).isEmpty() ? null : activity;
                    } else if (source instanceof UserHome) {
                        UserHome userHome = (UserHome)source;
                        activity = userHome.getAssignedActivity(activityQuery).isEmpty() ? null : activity;
                    } else if (source instanceof Resource) {
                        Resource resource = (Resource)source;
                        activity = resource.getAssignedActivity(activityQuery).isEmpty() ? null : activity;
                    }
                }
                StringBuilder dummy = new StringBuilder();
                Map<Object, Object> newICal = new HashMap();
                newICal = this.parseICal(new BufferedReader(new StringReader(((String)calendar).toString())), dummy);
                newICal.remove("LAST-MODIFIED");
                newICal.remove("DTSTAMP");
                newICal.remove("CREATED");
                dummy.setLength(0);
                Map<String, ICalField> oldICal = null;
                if (activity == null) {
                    int pos2;
                    int pos1;
                    boolean rewriteUID = true;
                    if (recurrenceId != null && !recurrenceId.isEmpty()) {
                        boolean bl = rewriteUID = this.findActivity(activitiesHelper, calUID, null) == null;
                    }
                    if (rewriteUID && (pos1 = ((String)calendar).indexOf("UID:")) > 0 && (pos2 = ((String)calendar).indexOf("\n", pos1)) > pos1) {
                        String newUID = Base.getInstance().getUidAsString();
                        calendar = ((String)calendar).substring(0, pos1) + "UID:" + newUID + "\n" + ((String)calendar).substring(pos2 + 1);
                    }
                } else {
                    try {
                        oldICal = ICalendar.getInstance().parseICal(new BufferedReader(new StringReader(activity.getIcal())), dummy);
                        oldICal.remove("LAST-MODIFIED");
                        oldICal.remove("DTSTAMP");
                        oldICal.remove("CREATED");
                        oldICal.keySet().retainAll(newICal.keySet());
                    }
                    catch (Exception e) {
                        SysLog.log((Level)Level.WARNING, (String)"Unable to parse ical of {0}. Error is {1}", (Object[])new Object[]{activity.refGetPath().toXRI(), e.getMessage()});
                        throw new ServiceException(e);
                    }
                }
                ActivityGroup activityGroup = activitiesHelper.getActivityGroup();
                boolean bl = activity == null ? false : (disabledIsModified = !Utils.areEqual(activity.isDisabled(), activitiesHelper.isDisabledFilter()));
                if (activity != null) {
                    this.updateTimers(activity, (String)calendar, alarms);
                    if (newICal.equals(oldICal) && !disabledIsModified) continue;
                    try {
                        if (!newICal.equals(oldICal)) {
                            boolean isTxLocal;
                            boolean bl2 = isTxLocal = !pm.currentTransaction().isActive();
                            if (isTxLocal) {
                                pm.currentTransaction().begin();
                            }
                            if (!hasClass) {
                                calendar = isEvent ? ((String)calendar).replace("BEGIN:VEVENT", "BEGIN:VEVENT\nCLASS:" + ICalClass.CONFIDENTIAL.name()) : ((String)calendar).replace("BEGIN:VTODO", "BEGIN:VTODO\nCLASS:" + ICalClass.CONFIDENTIAL.name());
                            }
                            ImportItemParams importItemParams = (ImportItemParams)Structures.create(ImportItemParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ImportItemParams.Member.item, (Object)((String)calendar).toString().getBytes("UTF-8")), Datatypes.member((Enum)ImportItemParams.Member.itemMimeType, (Object)MIME_TYPE), Datatypes.member((Enum)ImportItemParams.Member.itemName, (Object)"import.ics")});
                            activity.importItem(importItemParams);
                            if (isTxLocal) {
                                pm.currentTransaction().commit();
                                pm.refresh((Object)activity);
                            }
                        }
                        if (!disabledIsModified) continue;
                        pm.currentTransaction().begin();
                        status = PutICalResult.Status.CREATED;
                        activity.setDisabled(activitiesHelper.isDisabledFilter());
                        pm.currentTransaction().commit();
                        continue;
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception importItemParams) {
                            // empty catch block
                        }
                        status = PutICalResult.Status.ERROR;
                        continue;
                    }
                }
                if (allowCreation && activity == null && activityGroup != null) {
                    ActivityGroupIsCreatedBy.ActivityCreator activityCreators = activityGroup.getActivityCreator();
                    ActivityCreator activityCreator = Activities.getInstance().findActivityCreator((Collection<ActivityCreator>)((Object)activityCreators), isTodo ? Activities.ActivityClass.TASK.getValue() : (isEvent ? Activities.ActivityClass.MEETING.getValue() : Activities.ActivityClass.INCIDENT.getValue()));
                    if (activityCreator == null) {
                        activityCreator = Activities.getInstance().findActivityCreator((Collection<ActivityCreator>)((Object)activityCreators), isTodo ? Activities.ActivityClass.MEETING.getValue() : (isEvent ? Activities.ActivityClass.INCIDENT.getValue() : Activities.ActivityClass.INCIDENT.getValue()));
                    }
                    if (activityCreator == null) {
                        activityCreator = Activities.getInstance().findActivityCreator((Collection<ActivityCreator>)((Object)activityCreators), isTodo ? Activities.ActivityClass.INCIDENT.getValue() : (isEvent ? Activities.ActivityClass.INCIDENT.getValue() : Activities.ActivityClass.INCIDENT.getValue()));
                    }
                    if (activityCreator == null) {
                        activityCreator = activitiesHelper.getActivityGroup().getDefaultCreator();
                    }
                    if (activityCreator != null) {
                        try {
                            String name = "NA";
                            int posSummary = ((String)calendar).indexOf("SUMMARY:");
                            if (posSummary > 0 && ((String)calendar).indexOf("\n", posSummary) > 0) {
                                name = ((String)calendar).substring(posSummary + 8, ((String)calendar).indexOf("\n", posSummary));
                            }
                            pm.currentTransaction().begin();
                            NewActivityParams newActivityParams = (NewActivityParams)Datatypes.create(NewActivityParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)NewActivityParams.Member.icalType, (Object)((short)(isEvent ? 1 : (isTodo ? 2 : 0)))), Datatypes.member((Enum)NewActivityParams.Member.name, (Object)name), Datatypes.member((Enum)NewActivityParams.Member.priority, (Object)0)});
                            NewActivityResult result = activityCreator.newActivity(newActivityParams);
                            pm.currentTransaction().commit();
                            try {
                                activity = (Activity)pm.getObjectById((Object)result.getActivity().refGetPath());
                                pm.currentTransaction().begin();
                                ImportItemParams importItemParams = (ImportItemParams)Datatypes.create(ImportItemParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ImportItemParams.Member.item, (Object)((String)calendar).toString().getBytes("UTF-8")), Datatypes.member((Enum)ImportItemParams.Member.itemMimeType, (Object)MIME_TYPE), Datatypes.member((Enum)ImportItemParams.Member.itemName, (Object)"import.ics")});
                                activity.importItem(importItemParams);
                                pm.currentTransaction().commit();
                                this.updateTimers(activity, (String)calendar, alarms);
                                pm.refresh((Object)activity);
                                if (activitiesHelper.isDisabledFilter() && (activity.isDisabled() == null || !activity.isDisabled().booleanValue())) {
                                    pm.currentTransaction().begin();
                                    activity.setDisabled(Boolean.TRUE);
                                    pm.currentTransaction().commit();
                                }
                                status = PutICalResult.Status.CREATED;
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Error importing calendar. Reason is", (Object)new String[]{((String)calendar).toString(), e.getMessage()});
                                new ServiceException(e).log();
                                try {
                                    pm.currentTransaction().rollback();
                                }
                                catch (Exception exception) {}
                            }
                            continue;
                        }
                        catch (Exception e) {
                            SysLog.warning((String)"Can not create activity. Reason is", (Object)e.getMessage());
                            new ServiceException(e).log();
                            try {
                                pm.currentTransaction().rollback();
                                continue;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                        }
                    }
                    SysLog.detail((String)"Skipping calendar. No activity creator found", (Object)calendar);
                    continue;
                }
                SysLog.detail((String)"Skipping ", (Object)new String[]{"UID: " + calUID, "Activity.number: " + (activity == null ? null : activity.refMofId()), "Activity.modifiedAt:" + (activity == null ? null : activity.getModifiedAt())});
            }
            return new PutICalResult(status, activity);
        }
        catch (IOException e) {
            throw new ServiceException((Exception)e);
        }
    }

    public void printAlarms(PrintWriter p, Activity event) throws ServiceException {
        if (event.getIcal().indexOf(X_OPENCRX_RENDER_ALARMS_TRUE) > 0) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)event);
            TimerQuery timerQuery = (TimerQuery)pm.newQuery(Timer.class);
            timerQuery.forAllDisabled().isFalse();
            List timers = event.getAssignedTimer(timerQuery);
            UserHome userHome = UserHomes.getInstance().getUserHome(event.refGetPath(), pm);
            for (Timer timer : timers) {
                if (!timer.refGetPath().get(6).equals(userHome.refGetPath().getLastSegment().toString())) continue;
                p.println("BEGIN:VALARM");
                p.println("ACTION:DISPLAY");
                long triggerMinutes = (timer.getTimerStartAt().getTime() - event.getScheduledStart().getTime()) / 60000L;
                p.println("TRIGGER;VALUE=DURATION:" + (triggerMinutes < 0L ? "-" : "") + "PT" + Math.abs(triggerMinutes) + "M");
                p.println("REPEAT:" + (timer.getTriggerRepeat() == null ? 1 : timer.getTriggerRepeat()));
                p.println("DURATION:PT" + (timer.getTriggerIntervalMinutes() == null ? 15 : timer.getTriggerIntervalMinutes()) + "M");
                p.println("SUMMARY:" + timer.getName());
                if (timer.getDescription() != null) {
                    p.println("DESCRIPTION:" + timer.getDescription());
                }
                p.println("END:VALARM");
            }
        }
    }

    public void updateTimers(Activity event, String calendar, List<StringBuilder> alarms) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)event);
        UserHome userHome = UserHomes.getInstance().getUserHome(event.refGetPath(), pm);
        for (StringBuilder alarm : alarms) {
            Map<String, ICalField> alarmFields = this.parseICal(new BufferedReader(new StringReader("BEGIN:VEVENT\n" + alarm + "\nEND:VEVENT")), new StringBuilder());
            TimerQuery timerQuery = (TimerQuery)pm.newQuery(Timer.class);
            timerQuery.thereExistsTarget().equalTo((Object)event);
            List<Object> timers = userHome.getTimer(timerQuery);
            if (timers.isEmpty()) {
                try {
                    pm.currentTransaction().begin();
                    String summary = ICalField.getFieldValue("SUMMARY", alarmFields);
                    String description = ICalField.getFieldValue("DESCRIPTION", alarmFields);
                    Timer timer = (Timer)pm.newInstance(Timer.class);
                    timer.setName((String)(summary == null ? (description == null ? "Timer " + event.getName() : description) : summary));
                    timer.setTarget((ContextCapable)event);
                    userHome.addTimer(this.getUidAsString(), timer);
                    pm.currentTransaction().commit();
                    timers = Collections.singletonList(timer);
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception description) {
                        // empty catch block
                    }
                }
            }
            for (Timer timer : timers) {
                try {
                    pm.currentTransaction().begin();
                    String trigger = ICalField.getFieldValue("TRIGGER", alarmFields);
                    if (trigger != null) {
                        long minutes = -60L;
                        if (trigger.startsWith("-P")) {
                            try {
                                int factor = -1;
                                if (trigger.endsWith("M")) {
                                    factor = -1;
                                } else if (trigger.endsWith("H")) {
                                    factor = -60;
                                } else if (trigger.endsWith("D")) {
                                    factor = -1440;
                                }
                                minutes = factor * Integer.valueOf(trigger.substring(trigger.startsWith("-PT") ? 3 : 2, trigger.length() - 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        timer.setTimerStartAt(new Date(event.getScheduledStart().getTime() + minutes * 60000L));
                    } else {
                        timer.setTimerStartAt(new Date(event.getScheduledStart().getTime() - 3600000L));
                    }
                    String repeat = ICalField.getFieldValue("REPEAT", alarmFields);
                    if (repeat != null) {
                        timer.setTriggerRepeat(Integer.valueOf(repeat));
                    } else {
                        timer.setTriggerRepeat(1);
                    }
                    String duration = ICalField.getFieldValue("DURATION", alarmFields);
                    if (duration != null) {
                        Integer minutes = 5;
                        if (duration.startsWith("PT") && duration.endsWith("M")) {
                            try {
                                minutes = Integer.valueOf(duration.substring(2, duration.length() - 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        timer.setTriggerIntervalMinutes(minutes);
                    } else {
                        timer.setTriggerIntervalMinutes(5);
                    }
                    timer.setLastTriggerAt(new Date());
                    timer.setDisabled(calendar.indexOf("X-MOZ-LASTACK:") > 0 || alarm.indexOf("ACKNOWLEDGED:") > 0);
                    timer.setTimerState(new Short(10));
                    timer.setTimerEndAt(new Date(event.getScheduledStart().getTime() + 3600000L));
                    pm.currentTransaction().commit();
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public String getUid(String event) {
        int start;
        int end;
        String uid = null;
        if (event.indexOf("UID:") > 0 && (end = event.indexOf("\n", start = event.indexOf("UID:"))) > start) {
            uid = event.substring(start + 4, end).trim();
        }
        return uid;
    }

    public boolean validateUid() {
        return false;
    }

    public void printCalendar(PrintWriter pw, Activity activity, ActivityQueryHelper queryHelper, String runAs, boolean eventsOnly, HttpServletRequest req, String accessUrlContext) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)activity);
        Object ical = activity.getIcal();
        ArrayList<Activity> events = new ArrayList<Activity>();
        events.add(activity);
        String uid = this.getUid((String)ical);
        if (uid != null && ((String)ical).indexOf("RRULE:") > 0 && queryHelper != null) {
            ActivityQuery relatedActivitiesQuery = (ActivityQuery)pm.newQuery(Activity.class);
            relatedActivitiesQuery.thereExistsExternalLink().equalTo((Object)(ICAL_SCHEMA + uid));
            relatedActivitiesQuery.thereExistsExternalLink().startsWith((Object)ICAL_RECURRENCE_ID_SCHEMA);
            Collection<Activity> members = queryHelper.getFilteredActivities(relatedActivitiesQuery);
            events.addAll(members);
        }
        if (!eventsOnly) {
            pw.println("BEGIN:VCALENDAR");
            pw.println("PRODID://OPENCRX//V2//EN");
            pw.println("VERSION:2.0");
            pw.println("CALSCALE:GREGORIAN");
        }
        for (Activity event : events) {
            String url;
            ical = event.getIcal();
            if (runAs != null && ((String)ical).indexOf("CLASS:PUBLIC") < 0) {
                int pos2;
                int pos22;
                int pos23;
                int pos24;
                int pos25;
                int pos26;
                String oUID = null;
                int pos1 = ((String)ical).indexOf("UID");
                if (pos1 >= 0 && (pos26 = ((String)ical).indexOf("\n", pos1)) > pos1) {
                    oUID = ((String)ical).substring(pos1, pos26);
                }
                String oDTSTAMP = null;
                pos1 = ((String)ical).indexOf("DTSTAMP");
                if (pos1 >= 0 && (pos25 = ((String)ical).indexOf("\n", pos1)) > pos1) {
                    oDTSTAMP = ((String)ical).substring(pos1, pos25);
                }
                String oORGANIZER = null;
                pos1 = ((String)ical).indexOf("ORGANIZER");
                if (pos1 >= 0 && (pos24 = ((String)ical).indexOf("\n", pos1)) > pos1) {
                    oORGANIZER = ((String)ical).substring(pos1, pos24);
                }
                String oDTSTART = null;
                pos1 = ((String)ical).indexOf("DTSTART");
                if (pos1 >= 0 && (pos23 = ((String)ical).indexOf("\n", pos1)) > pos1) {
                    oDTSTART = ((String)ical).substring(pos1, pos23);
                }
                String oDTEND = null;
                pos1 = ((String)ical).indexOf("DTEND");
                if (pos1 >= 0 && (pos22 = ((String)ical).indexOf("\n", pos1)) > pos1) {
                    oDTEND = ((String)ical).substring(pos1, pos22);
                }
                String oRRULE = null;
                pos1 = ((String)ical).indexOf("RRULE");
                if (pos1 >= 0 && (pos2 = ((String)ical).indexOf("\n", pos1)) > pos1) {
                    oRRULE = ((String)ical).substring(pos1, pos2);
                }
                ical = "BEGIN:VEVENT\n" + (String)(oUID == null ? "" : oUID + "\n") + "CLASS:CONFIDENTIAL\n" + (String)(oDTSTAMP == null ? "" : oDTSTAMP + "\n") + (String)(oORGANIZER == null ? "" : oORGANIZER + "\n") + "SUMMARY:*** (" + runAs + ")\n" + (String)(oDTSTART == null ? "" : oDTSTART + "\n") + (String)(oDTEND == null ? "" : oDTEND + "\n") + (String)(oRRULE == null ? "" : oRRULE + "\n") + "END:VEVENT\n";
            }
            uid = this.getUid((String)ical);
            if (this.validateUid()) {
                boolean externalLinkMatchesUid = false;
                if (uid != null) {
                    for (String externalLink : event.getExternalLink()) {
                        if (!externalLink.startsWith(ICAL_SCHEMA) || !externalLink.endsWith(uid)) continue;
                        externalLinkMatchesUid = true;
                        break;
                    }
                }
                if (!externalLinkMatchesUid) {
                    ServiceException e0 = new ServiceException("DefaultDomain", -2, "Mismatch of activity's external link and ical's UID. Use updateIcal() to fix event.", new BasicException.Parameter[]{new BasicException.Parameter("activity", (Object)activity.refGetPath().toXRI()), new BasicException.Parameter("externalLink", activity.getExternalLink()), new BasicException.Parameter("uid", (Object)uid), new BasicException.Parameter("ical", ical)});
                    SysLog.warning((String)"Mismatch of activity's external link and ical's UID. Use updateIcal() to fix event.", Arrays.asList(activity.refGetPath().toString(), activity.getActivityNumber()));
                    SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                }
            }
            if (((String)(ical = ((String)ical).replace("\r\n", "\n"))).indexOf("BEGIN:VEVENT") >= 0) {
                int start = ((String)ical).indexOf("BEGIN:VEVENT");
                int end = ((String)ical).indexOf("END:VEVENT");
                if (end < 0 || start < 0 || end < start) {
                    SysLog.log((Level)Level.WARNING, (String)"ICAL {0} of activity {1} has bad format and will be ignored", (Object[])new Object[]{ical, event.refGetPath().toXRI()});
                    continue;
                }
                Object vevent = ((String)ical).substring(start, end);
                url = null;
                try {
                    url = Base.getInstance().getAccessUrl(req, accessUrlContext, event);
                }
                catch (Exception oDTSTART) {
                    // empty catch block
                }
                start = ((String)vevent).indexOf("SUMMARY:");
                if (start > 0) {
                    end = ((String)vevent).indexOf("\n", start);
                    vevent = ((String)vevent).substring(0, start) + ((String)vevent).substring(start, end).replace(",", "\\,") + ((String)vevent).substring(end);
                }
                if ((start = ((String)vevent).indexOf("DESCRIPTION:")) > 0) {
                    end = ((String)vevent).indexOf("\n", start);
                    vevent = ((String)vevent).substring(0, start) + ((String)vevent).substring(start, end).replace(",", "\\,") + ((String)vevent).substring(end);
                }
                if ((start = ((String)vevent).indexOf("ORGANIZER:")) > 0) {
                    end = ((String)vevent).indexOf("\n", start);
                    vevent = ((String)vevent).substring(0, start) + ((String)vevent).substring(end + 1);
                }
                pw.print((String)vevent);
                SysLog.detail((String)vevent);
                if (((String)vevent).indexOf("TRANSP:") < 0) {
                    try {
                        String transp = "OPAQUE";
                        if (transp != null) {
                            pw.println("TRANSP:" + transp);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (((String)vevent).indexOf("\nURL:") < 0 && url != null) {
                    pw.println("URL:" + url);
                }
                try {
                    this.printAlarms(pw, event);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pw.println("END:VEVENT");
                continue;
            }
            if (((String)ical).indexOf("BEGIN:VTODO") < 0) continue;
            int start = ((String)ical).indexOf("BEGIN:VTODO");
            int end = ((String)ical).indexOf("END:VTODO");
            if (end < 0 || start < 0 || end < start) {
                SysLog.log((Level)Level.WARNING, (String)"ICAL {0} of activity {1} has bad format and will be ignored", (Object[])new Object[]{ical, event.refGetPath().toXRI()});
                continue;
            }
            Object vtodo = ((String)ical).substring(start, end);
            url = null;
            try {
                url = Base.getInstance().getAccessUrl(req, accessUrlContext, event);
            }
            catch (Exception exception) {
                // empty catch block
            }
            start = ((String)vtodo).indexOf("SUMMARY:");
            if (start > 0) {
                end = ((String)vtodo).indexOf("\n", start);
                vtodo = ((String)vtodo).substring(0, start) + ((String)vtodo).substring(start, end).replace(",", "\\,") + ((String)vtodo).substring(end);
            }
            if ((start = ((String)vtodo).indexOf("DESCRIPTION:")) > 0) {
                end = ((String)vtodo).indexOf("\n", start);
                vtodo = ((String)vtodo).substring(0, start) + ((String)vtodo).substring(start, end).replace(",", "\\,") + ((String)vtodo).substring(end);
            }
            pw.print((String)vtodo);
            SysLog.detail((String)vtodo);
            if (((String)vtodo).indexOf("\nURL:") < 0 && url != null) {
                pw.println("URL:" + url);
            }
            try {
                this.printAlarms(pw, event);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pw.println("END:VTODO");
        }
        if (!eventsOnly) {
            pw.print("END:VCALENDAR");
        }
    }

    public static enum ICalClass {
        NA(0),
        PRIVATE(1),
        CONFIDENTIAL(2),
        PUBLIC(3);

        private short value;

        private ICalClass(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public static ICalClass valueOf(short value) {
            switch (value) {
                case 0: {
                    return NA;
                }
                case 1: {
                    return PRIVATE;
                }
                case 2: {
                    return CONFIDENTIAL;
                }
                case 3: {
                    return PUBLIC;
                }
            }
            return NA;
        }
    }

    public static enum AlarmAction {
        AUDIO(10),
        DISPLAY(20),
        EMAIL(30),
        PROCEDURE(40);

        private short value;

        private AlarmAction(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public static AlarmAction valueOf(short value) {
            switch (value) {
                case 10: {
                    return AUDIO;
                }
                case 20: {
                    return DISPLAY;
                }
                case 30: {
                    return EMAIL;
                }
                case 40: {
                    return PROCEDURE;
                }
            }
            return DISPLAY;
        }
    }

    public static class PutICalResult {
        private final Status status;
        private final Activity activity;

        public PutICalResult(Status status, Activity activity) {
            this.status = status;
            this.activity = activity;
        }

        public Status getStatus() {
            return this.status;
        }

        public Activity getActivity() {
            return this.activity;
        }

        public static enum Status {
            CREATED,
            UPDATED,
            ERROR;

        }
    }

    public static class ICalField {
        private final String name;
        private String value;
        private final Map<String, List<String>> parameters;

        public ICalField(String name, String value, Map<String, List<String>> parameters) {
            this.name = name;
            this.value = value;
            this.parameters = parameters;
        }

        public static ICalField getField(String name, String parameterName, List<String> parameterValues, Map<String, ICalField> ical) {
            List<ICalField> matchingFields = ICalField.findFields(name, parameterName, parameterValues, ical);
            return matchingFields.isEmpty() ? null : matchingFields.get(0);
        }

        public static List<ICalField> findFields(String name, String parameterName, List<String> parameterValues, Map<String, ICalField> ical) {
            ArrayList<ICalField> matchingFields = new ArrayList<ICalField>();
            for (ICalField field : ical.values()) {
                if (!name.equals(field.getName()) || parameterName != null && (field.getParameters().get(parameterName) == null || !field.getParameters().get(parameterName).containsAll(parameterValues))) continue;
                matchingFields.add(field);
            }
            return matchingFields;
        }

        public static String getFieldValue(String name, String parameterName, List<String> parameterValues, Map<String, ICalField> ical) {
            ICalField field = ICalField.getField(name, parameterName, parameterValues, ical);
            return field == null ? null : field.getValue();
        }

        public static String getFieldValue(String name, Map<String, ICalField> ical) {
            return ICalField.getFieldValue(name, null, null, ical);
        }

        public TimeZone getTimeZone() {
            List<String> tzids = this.getParameters().get("TZID");
            TimeZone tz = TimeZone.getDefault();
            if (tzids != null && !tzids.isEmpty()) {
                String tzid = tzids.get(0).toUpperCase();
                String[] availableIds = TimeZone.getAvailableIDs();
                for (int i = 0; i < availableIds.length; ++i) {
                    if (!tzid.endsWith(availableIds[i].toUpperCase())) continue;
                    tz = TimeZone.getTimeZone(availableIds[i]);
                    break;
                }
            }
            return tz;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Map<String, List<String>> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ICalField) {
                ICalField that = (ICalField)obj;
                return this.name.equals(that.name) && this.parameters.equals(that.parameters) && this.value.equals(that.value);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.name + this.parameters.toString() + ":" + this.value;
        }
    }
}

