/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.cci2.ActivityFollowUpQuery;
import org.opencrx.kernel.activity1.cci2.ActivityHasTrackerAndGroupAssignment;
import org.opencrx.kernel.activity1.cci2.MeetingPartyQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityFollowUp;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityGroupAssignment;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessState;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessTransition;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.Incident;
import org.opencrx.kernel.activity1.jmi1.Meeting;
import org.opencrx.kernel.activity1.jmi1.MeetingParty;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.home1.jmi1.Alert;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.DataproviderOperation;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.HtmlEncoder;
import org.openmdx.portal.servlet.Action;
import org.openmdx.portal.servlet.CssClass;

public class Notifications
extends AbstractImpl {
    public static final short CHANGE_PASSWORD_OK = 0;
    public static final short MISSING_NEW_PASSWORD = 1;
    public static final short MISSING_NEW_PASSWORD_VERIFICATION = 2;
    public static final short PASSWORD_VERIFICATION_MISMATCH = 3;
    public static final short CAN_NOT_RETRIEVE_REQUESTED_PRINCIPAL = 4;
    public static final short CAN_NOT_CHANGE_PASSWORD = 5;
    public static final short MISSING_OLD_PASSWORD = 6;
    protected static final String PRE_STYLE = "white-space:pre-wrap; word-break:normal;";
    protected static final String BOOTSTRAP_MIN_CSS_URL = "https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css";

    public static void register() {
        Notifications.registerImpl(new Notifications());
    }

    public static Notifications getInstance() throws ServiceException {
        return Notifications.getInstance(Notifications.class);
    }

    protected Notifications() {
    }

    public String getAccessUrl(Path targetIdentity, UserHome userHome) throws ServiceException {
        String webAccessUrl = UserHomes.getInstance().getWebAccessUrl(userHome);
        Action selectTargetAction = targetIdentity == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", targetIdentity.toXRI())}, "", true);
        return webAccessUrl + "?event=6&parameter=" + selectTargetAction.getParameter();
    }

    public String getNotificationText(PersistenceManager pm, ContextCapable target, Path wfProcessInstanceIdentity, UserHome userHome, Map<String, Object> params) throws ServiceException {
        Action selectTriggeredByAction;
        Action selectTargetAction;
        Object text = "#ERR";
        String webAccessUrl = UserHomes.getInstance().getWebAccessUrl(userHome);
        Path targetIdentity = target == null ? null : target.refGetPath();
        Action action = selectTargetAction = targetIdentity == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", targetIdentity.toXRI())}, "", true);
        Path triggeredBy = params.get("triggeredBy") instanceof String ? new Path((String)params.get("triggeredBy")) : (params.get("triggeredBy") instanceof Path ? (Path)params.get("triggeredBy") : null);
        String triggeredById = triggeredBy == null ? "N/A" : triggeredBy.getLastSegment().toString();
        Action selectWfProcessInstanceAction = wfProcessInstanceIdentity == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", wfProcessInstanceIdentity.toXRI())}, "", true);
        Action action2 = selectTriggeredByAction = triggeredBy == null ? null : new Action(6, new Action.Parameter[]{new Action.Parameter("xri", triggeredBy.toXRI())}, "", true);
        if (target instanceof Alert) {
            Alert alert = (Alert)target;
            ContextCapable referencedObj = null;
            try {
                referencedObj = alert.getReference();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (referencedObj != null && !(referencedObj instanceof UserHome)) {
                text = this.getNotificationText(pm, referencedObj, wfProcessInstanceIdentity, userHome, params);
            } else {
                text = "<!DOCTYPE html>";
                text = (String)text + "<html lang=\"en\">";
                text = (String)text + "<head>";
                text = (String)text + "\t<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">";
                text = (String)text + "\t<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\">";
                text = (String)text + "</head>";
                text = (String)text + "<body>";
                text = (String)text + "<div class=\"container\">";
                if (selectTargetAction != null) {
                    text = (String)text + "<div class=\"alert alert-warning\" style=\"margin-bottom:0px\">";
                    text = (String)text + "<h4><a href=\"" + this.getAccessUrl(targetIdentity, userHome) + "\">" + (alert.getName() == null ? "Alert" : alert.getName()) + "</a></h4>";
                    text = (String)text + "</div>";
                    text = (String)text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
                } else {
                    text = (String)text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
                    text = (String)text + "Name:\n";
                    text = (String)text + (alert.getName() == null ? "---" : alert.getName()) + "\n\n";
                }
                text = (String)text + "Description:\n";
                text = (String)text + (alert.getDescription() == null ? "---" : alert.getDescription()) + "\n\n";
                text = (String)text + "</pre>";
                text = (String)text + "</div>";
                text = (String)text + "</body>";
                text = (String)text + "</html>";
            }
        } else if (target instanceof Activity || target instanceof ActivityFollowUp) {
            Activity activity = target instanceof Activity ? (Activity)target : (Activity)pm.getObjectById((Object)new Path(target.refMofId()).getParent().getParent());
            Contact reportingContact = null;
            try {
                reportingContact = activity.getReportingContact();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Account reportingAccount = null;
            try {
                reportingAccount = activity.getReportingAccount();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Contact assignedTo = null;
            try {
                assignedTo = activity.getAssignedTo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ActivityProcessState activityState = activity.getProcessState();
            ActivityProcessTransition lastTransition = activity.getLastTransition();
            String activityName = activity.getName();
            text = "<!DOCTYPE html>";
            text = (String)text + "<html lang=\"en\">";
            text = (String)text + "<head>";
            text = (String)text + "\t<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">";
            text = (String)text + "\t<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\">";
            text = (String)text + "</head>";
            text = (String)text + "<body>";
            text = (String)text + "<div class=\"container\">";
            text = (String)text + "<div class=\"" + CssClass.alert + " " + CssClass.alert_warning + "\" style=\"margin-bottom:0px\">";
            text = (String)text + "<h4><a href=\"" + webAccessUrl + "?event=6&parameter=" + selectTargetAction.getParameter() + "\">#" + activity.getActivityNumber() + ": " + HtmlEncoder.encode((String)(activityName == null ? "---" : activityName), (boolean)false) + "</a></h4>";
            text = (String)text + "</div>";
            text = (String)text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
            text = (String)text + "=========================================================\n";
            text = (String)text + "Reporting Contact:          " + (reportingContact == null ? "---" : reportingContact.getFullName()) + "\n";
            text = (String)text + "Reporting Account:          " + (reportingAccount == null ? "---" : reportingAccount.getFullName()) + "\n";
            text = (String)text + "Handler:                    " + (assignedTo == null ? "---" : assignedTo.getFullName()) + "\n";
            text = (String)text + "=========================================================\n";
            boolean ii = false;
            ActivityHasTrackerAndGroupAssignment.AssignedGroup assignedGroups = activity.getAssignedGroup();
            Iterator iterator = assignedGroups.iterator();
            while (iterator.hasNext()) {
                ActivityGroupAssignment assignedGroup = (ActivityGroupAssignment)iterator.next();
                ActivityGroup group = assignedGroup.getActivityGroup();
                if (group == null) continue;
                if (!ii) {
                    text = (String)text + "Activity Group:             " + group.getName() + "\n";
                    continue;
                }
                text = (String)text + "                            " + group.getName() + "\n";
            }
            text = (String)text + "Activity#:                  " + activity.getActivityNumber() + "\n";
            if (activity instanceof Incident) {
                Incident incident = (Incident)activity;
                try {
                    text = (String)text + "Category:                   " + incident.getCategory() + "\n";
                }
                catch (Exception assignedGroup) {
                    // empty catch block
                }
                try {
                    text = (String)text + "Reproducibility:            " + incident.getReproducibility() + "\n";
                }
                catch (Exception assignedGroup) {
                    // empty catch block
                }
                try {
                    text = (String)text + "Severity:                   " + incident.getSeverity() + "\n";
                }
                catch (Exception assignedGroup) {
                    // empty catch block
                }
            }
            text = (String)text + "Priority:                   " + activity.getPriority() + "\n";
            text = (String)text + "Status:                     " + (activityState == null ? "---" : activityState.getName()) + "\n";
            text = (String)text + "Last transition:            " + (lastTransition == null ? "---" : lastTransition.getName()) + "\n";
            text = (String)text + "=========================================================\n";
            text = (String)text + "Scheduled start:            " + (Serializable)(activity.getScheduledStart() == null ? "---" : activity.getScheduledStart()) + "\n";
            text = (String)text + "Scheduled end:              " + (Serializable)(activity.getScheduledEnd() == null ? "---" : activity.getScheduledEnd()) + "\n";
            text = (String)text + "Due by:                     " + (Serializable)(activity.getDueBy() == null ? "---" : activity.getDueBy()) + "\n";
            text = (String)text + "Actual start:               " + (Serializable)(activity.getActualStart() == null ? "---" : activity.getActualStart()) + "\n";
            text = (String)text + "Actual end:                 " + (Serializable)(activity.getActualEnd() == null ? "---" : activity.getActualEnd()) + "\n";
            text = (String)text + "=========================================================\n";
            text = (String)text + "Date Submitted:             " + activity.getCreatedAt() + "\n";
            text = (String)text + "Last Modified:              " + activity.getModifiedAt() + "\n";
            text = (String)text + "=========================================================\n";
            if (activity instanceof Meeting) {
                text = (String)text + "Organizer:\n";
                text = (String)text + "*  " + activity.getAssignedTo().getFullName() + "\n";
                text = (String)text + "Attendees:\n";
                Meeting meeting = (Meeting)activity;
                MeetingPartyQuery partyQuery = (MeetingPartyQuery)pm.newQuery(MeetingParty.class);
                partyQuery.orderByPartyStatus().ascending();
                List meetingParties = meeting.getMeetingParty(partyQuery);
                for (MeetingParty meetingParty : meetingParties) {
                    String partyStatus = meetingParty.getPartyStatus() == Activities.PartyStatus.ACCEPTED.getValue() ? "+" : (meetingParty.getPartyStatus() == Activities.PartyStatus.DECLINED.getValue() ? "-" : "?");
                    text = (String)text + partyStatus + "  " + (meetingParty.getEmailHint() == null ? meetingParty.getParty().getFullName() : meetingParty.getEmailHint()) + "\n";
                }
                text = (String)text + "=========================================================\n";
            }
            String activityDescription = activity.getDescription();
            String activityDetailedDescription = activity.getDetailedDescription();
            String messageBody = activity instanceof EMail ? ((EMail)activity).getMessageBody() : null;
            text = (String)text + "Summary:\n";
            text = (String)text + (activityName == null ? "---" : activityName) + "\n\n";
            text = (String)text + "Description:\n";
            text = (String)text + (activityDescription == null ? "---" : activityDescription) + "\n\n";
            text = (String)text + "Details:\n";
            text = (String)text + (activityDetailedDescription == null ? "---" : activityDetailedDescription) + "\n\n";
            if (messageBody != null) {
                text = (String)text + "Message Body:\n";
                text = (String)text + messageBody + "\n\n";
            }
            text = (String)text + "</pre>";
            ActivityFollowUpQuery followUpQuery = (ActivityFollowUpQuery)pm.newQuery(ActivityFollowUp.class);
            followUpQuery.orderByCreatedAt().descending();
            List followUps = activity.getFollowUp(followUpQuery);
            for (ActivityFollowUp followUp : followUps) {
                Contact followUpAssignedTo = null;
                try {
                    followUpAssignedTo = followUp.getAssignedTo();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ActivityProcessTransition followUpTransition = null;
                try {
                    followUpTransition = followUp.getTransition();
                }
                catch (Exception meetingParty) {
                    // empty catch block
                }
                text = (String)text + "<div class=\"" + CssClass.alert + " " + CssClass.alert_info + "\" style=\"padding:10px;margin-bottom:0px\">";
                if (followUp.getTitle() != null && !followUp.getTitle().isEmpty()) {
                    text = (String)text + "<div class=\"" + CssClass.row + "\">";
                    text = (String)text + "\t<div class=\"\"><h4>" + HtmlEncoder.encode((String)followUp.getTitle(), (boolean)false) + "</h4></div>";
                    text = (String)text + "</div>";
                }
                text = (String)text + "<div class=\"row\">";
                text = (String)text + "\t<div class=\" text-left\">" + (followUpTransition == null ? "---" : followUpTransition.getName()) + "</div>";
                text = (String)text + "\t<div class=\" text-right\">" + (followUpAssignedTo == null ? "---" : followUpAssignedTo.getFullName()) + "</div>";
                text = (String)text + "\t<div class=\" text-right\">" + followUp.getCreatedAt() + "</div>";
                text = (String)text + "</div>";
                text = (String)text + "</div>";
                String followUpText = followUp.getText();
                if (followUpText != null && !HtmlEncoder.containsWiki((String)followUpText) && HtmlEncoder.containsHtml((String)followUpText)) {
                    text = (String)text + "<div class=\"" + CssClass.panel + " panel-default\">";
                    text = (String)text + "<div class=\"panel-body\">";
                    text = (String)text + followUpText;
                    text = (String)text + "</div>";
                    text = (String)text + "</div>";
                    continue;
                }
                text = (String)text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
                text = (String)text + (followUpText == null || followUpText.isEmpty() ? "---" : HtmlEncoder.encode((String)followUpText, (boolean)false));
                text = (String)text + "</pre>";
            }
            text = (String)text + "</div>";
            text = (String)text + "</body>";
            text = (String)text + "</html>";
        } else {
            text = "<!DOCTYPE html>";
            text = (String)text + "<html lang=\"en\">";
            text = (String)text + "<head>";
            text = (String)text + "\t<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">";
            text = (String)text + "\t<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\">";
            text = (String)text + "</head>";
            text = (String)text + "<body>";
            text = (String)text + "<div class=\"container\">";
            text = (String)text + "<pre style=\"white-space:pre-wrap; word-break:normal;\">";
            text = (String)text + "=========================================================\n";
            text = (String)text + "Event:           " + (params.get("triggeredByEventType") == null ? "N/A" : DataproviderOperation.valueOf(((Number)params.get("triggeredByEventType")).shortValue()).name()) + "\n";
            text = (String)text + "Trigger Id:      " + triggeredById + "\n";
            if (selectTargetAction != null) {
                text = (String)text + "Object Invoked:  \"" + webAccessUrl + "?event=6&parameter=" + selectTargetAction.getParameter() + "\"\n";
            }
            text = (String)text + "Workflow:        " + (String)(selectWfProcessInstanceAction == null ? "N/A" : "\"" + webAccessUrl + "?event=6&parameter=" + selectWfProcessInstanceAction.getParameter()) + "\"\n";
            text = (String)text + "Trigger URL:     " + (String)(selectTriggeredByAction == null ? "N/A" : "\"" + webAccessUrl + "?event=6&parameter=" + selectTriggeredByAction.getParameter()) + "\"\n";
            text = (String)text + "=========================================================\n";
            text = (String)text + "</pre>";
            text = (String)text + "</div>";
            text = (String)text + "</body>";
            text = (String)text + "</html>";
        }
        return text;
    }

    public String getNotificationSubject(PersistenceManager pm, ContextCapable target, Path wfProcessInstanceIdentity, UserHome userHome, Map<String, Object> params, boolean useSendMailSubjectPrefix) throws ServiceException {
        String webAccessUrl;
        Object sendMailSubjectPrefix;
        String triggeredById;
        Object title;
        String segmentName;
        String providerName;
        Path userHomeIdentity;
        block17: {
            userHomeIdentity = userHome.refGetPath();
            providerName = userHomeIdentity.getSegment(2).toString();
            segmentName = userHomeIdentity.getSegment(4).toString();
            title = null;
            Path triggeredBy = params.get("triggeredBy") instanceof String ? new Path((String)params.get("triggeredBy")) : (params.get("triggeredBy") instanceof Path ? (Path)params.get("triggeredBy") : null);
            triggeredById = triggeredBy == null ? "N/A" : triggeredBy.getLastSegment().toString();
            sendMailSubjectPrefix = userHome.getSendMailSubjectPrefix() == null ? "[" + providerName + ":" + segmentName + "]" : userHome.getSendMailSubjectPrefix();
            webAccessUrl = UserHomes.getInstance().getWebAccessUrl(userHome);
            if (target != null && !Boolean.TRUE.equals(params.get("confidential"))) {
                try {
                    if (target instanceof EMail) {
                        EMail emailActivity = (EMail)target;
                        title = (String)(useSendMailSubjectPrefix ? (String)sendMailSubjectPrefix + ": " : "") + emailActivity.getMessageSubject();
                        break block17;
                    }
                    if (target instanceof Alert) {
                        Alert alert = (Alert)target;
                        title = alert.getName() != null && !alert.getName().isEmpty() ? (String)(useSendMailSubjectPrefix ? (String)sendMailSubjectPrefix + ": " : "") + alert.getName() : (alert.getReference() != null && !(alert.getReference() instanceof UserHome) ? this.getNotificationSubject(pm, alert.getReference(), wfProcessInstanceIdentity, userHome, params, useSendMailSubjectPrefix) : alert.refGetPath().toXRI());
                        break block17;
                    }
                    if (title == null) {
                        try {
                            if (target.refGetValue("name") != null) {
                                title = (String)sendMailSubjectPrefix + ": " + target.refGetValue("name");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (title == null) {
                        try {
                            if (target.refGetValue("title") != null) {
                                title = (String)sendMailSubjectPrefix + ": " + target.refGetValue("title");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (title != null) break block17;
                    try {
                        if (target.refGetValue("fullName") != null) {
                            title = (String)sendMailSubjectPrefix + ": " + target.refGetValue("fullName");
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (title == null) {
            title = (String)sendMailSubjectPrefix + ": from=" + providerName + "/" + segmentName + "/" + userHomeIdentity.getSegment(6).toString() + "; trigger=" + triggeredById + "; access=" + webAccessUrl;
        }
        return title;
    }
}

