/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.Group;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.ActivityTracker;
import org.opencrx.kernel.activity1.jmi1.Resource;
import org.opencrx.kernel.aop2.Configuration;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Admin;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.backend.ICalendar;
import org.opencrx.kernel.backend.SecureObject;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.cci2.SetOwningUserParams;
import org.opencrx.kernel.base.jmi1.AuditEntry;
import org.opencrx.kernel.base.jmi1.ObjectCreationAuditEntry;
import org.opencrx.kernel.base.jmi1.ObjectModificationAuditEntry;
import org.opencrx.kernel.base.jmi1.ObjectRemovalAuditEntry;
import org.opencrx.kernel.base.jmi1.SetOwningUserParams;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.cci2.AlertQuery;
import org.opencrx.kernel.home1.cci2.EMailAccountQuery;
import org.opencrx.kernel.home1.cci2.SubscriptionQuery;
import org.opencrx.kernel.home1.cci2.WorkListFeedQuery;
import org.opencrx.kernel.home1.cci2.WorkListSnapshotQuery;
import org.opencrx.kernel.home1.jmi1.AccessHistory;
import org.opencrx.kernel.home1.jmi1.ActivityGroupCalendarFeed;
import org.opencrx.kernel.home1.jmi1.Alert;
import org.opencrx.kernel.home1.jmi1.CalendarProfile;
import org.opencrx.kernel.home1.jmi1.CardProfile;
import org.opencrx.kernel.home1.jmi1.ContactsFeed;
import org.opencrx.kernel.home1.jmi1.DocumentFeed;
import org.opencrx.kernel.home1.jmi1.DocumentProfile;
import org.opencrx.kernel.home1.jmi1.EMailAccount;
import org.opencrx.kernel.home1.jmi1.ObjectFinder;
import org.opencrx.kernel.home1.jmi1.QuickAccess;
import org.opencrx.kernel.home1.jmi1.Subscription;
import org.opencrx.kernel.home1.jmi1.Timer;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.home1.jmi1.WorkList;
import org.opencrx.kernel.home1.jmi1.WorkListFeed;
import org.opencrx.kernel.home1.jmi1.WorkListItem;
import org.opencrx.kernel.home1.jmi1.WorkListSnapshot;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.kernel.workflow1.cci2.SegmentContainsTopic;
import org.opencrx.kernel.workflow1.jmi1.Topic;
import org.opencrx.kernel.workflow1.jmi1.WfProcess;
import org.opencrx.security.realm1.jmi1.Principal;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.opencrx.security.realm1.jmi1.User;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.persistence.spi.PersistenceManagers;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.UserSettings;
import org.openmdx.security.authentication1.cci2.PasswordChangeParams;
import org.openmdx.security.authentication1.jmi1.Credential;
import org.openmdx.security.authentication1.jmi1.Password;
import org.openmdx.security.authentication1.jmi1.PasswordChangeParams;
import org.openmdx.security.authentication1.jmi1.Segment;
import org.openmdx.security.realm1.cci2.Subject;
import org.openmdx.security.realm1.jmi1.Realm;
import org.openmdx.security.realm1.jmi1.Role;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class UserHomes
extends AbstractImpl {
    public static final short CHANGE_PASSWORD_OK = 0;
    public static final short MISSING_NEW_PASSWORD = 1;
    public static final short MISSING_NEW_PASSWORD_VERIFICATION = 2;
    public static final short PASSWORD_VERIFICATION_MISMATCH = 3;
    public static final short CAN_NOT_RETRIEVE_REQUESTED_PRINCIPAL = 4;
    public static final short CAN_NOT_CHANGE_PASSWORD = 5;
    public static final short MISSING_OLD_PASSWORD = 6;
    public static final short OLD_PASSWORD_VERIFICATION_MISMATCH = 7;
    public static final short PASSWORD_POLICY_VIOLATION = 8;
    public static final String RESET_PASSWORD_PREFIX = "{RESET}";
    public static final long TTL_PASSWORD_RESET_TOKEN = 600000L;
    private static final Path PATH_PATTERN_USER_HOME = new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "userHome", ":*"});

    public static void register() {
        UserHomes.registerImpl(new UserHomes());
    }

    public static UserHomes getInstance() throws ServiceException {
        return UserHomes.getInstance(UserHomes.class);
    }

    protected UserHomes() {
    }

    public void markAsAccepted(Alert alert) throws ServiceException {
        alert.setAlertState(AlertState.ACCEPTED.getValue());
    }

    public void markAsRead(Alert alert) throws ServiceException {
        alert.setAlertState(AlertState.READ.getValue());
    }

    public void markAsNew(Alert alert) throws ServiceException {
        alert.setAlertState(AlertState.NEW.getValue());
    }

    public org.opencrx.kernel.home1.jmi1.Segment getUserHomeSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (org.opencrx.kernel.home1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    public void refreshItems(UserHome userHome) throws ServiceException {
        if (userHome.getContact() != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
            Date NOW_MINUS_1M = new Date(System.currentTimeMillis() - 2592000000L);
            Date NOW_MINUS_3M = new Date(System.currentTimeMillis() - 7776000000L);
            AlertQuery alertQuery = (AlertQuery)pm.newQuery(Alert.class);
            alertQuery.alertState().lessThan((Comparable)Short.valueOf(AlertState.EXPIRED.getValue()));
            alertQuery.orderByCreatedAt().descending();
            ArrayList<Path> alertIdentities = new ArrayList<Path>();
            List alerts = userHome.getAlert(alertQuery);
            int count = 0;
            for (Alert alert : alerts) {
                alertIdentities.add(alert.refGetPath());
                if (++count <= 200) continue;
                break;
            }
            HashSet<Path> references = new HashSet<Path>();
            for (Path alertIdentity : alertIdentities) {
                Alert alert = (Alert)pm.getObjectById((Object)alertIdentity);
                Path reference = null;
                try {
                    reference = alert.getReference().refGetPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (alert.getAlertState() == AlertState.READ.getValue() && alert.getCreatedAt().compareTo(NOW_MINUS_3M) < 0) {
                    alert.setAlertState(AlertState.EXPIRED.getValue());
                } else if (reference == null || references.contains(reference) || alert.getAlertState() < AlertState.READ.getValue() && alert.getCreatedAt().compareTo(NOW_MINUS_1M) < 0) {
                    alert.setAlertState(AlertState.READ.getValue());
                }
                if (reference == null) continue;
                references.add(reference);
            }
        }
    }

    protected String getRequestPasswordResetNotificationTemplate(UserHome userHome) throws ServiceException {
        String providerName = userHome.refGetPath().getSegment(2).toString();
        String segmentName = userHome.refGetPath().getSegment(4).toString();
        return "Did you request a password reset for your openCRX account (" + providerName + "/" + segmentName + ")?\n\nIf you requested this password reset, go here:\n<a href=\"{RESET_CONFIRM_URL}\">{RESET_CONFIRM_URL}</a>\n\nIf you didn't make this request, use this link to cancel it:\n<a href=\"{RESET_CANCEL_URL}\">{RESET_CANCEL_URL}</a>\n\nThanks,\nThe " + providerName + "/" + segmentName + " administrator";
    }

    public void requestPasswordReset(UserHome userHome) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
        String providerName = userHome.refGetPath().getSegment(2).toString();
        String segmentName = userHome.refGetPath().getSegment(4).toString();
        String principalName = userHome.refGetPath().getLastSegment().toString();
        Principal loginPrincipal = (Principal)SecureObject.getInstance().findPrincipal(principalName, SecureObject.getInstance().getLoginRealmIdentity(userHome.refGetPath().getSegment(2).toString()), pm);
        String webAccessUrl = userHome.getWebAccessUrl();
        if (webAccessUrl != null) {
            String resetToken = Utils.getRandomBase62(40);
            org.opencrx.kernel.workflow1.jmi1.Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, providerName, segmentName);
            String name = providerName + "/" + segmentName + " Password Reset";
            String resetConfirmUrl = webAccessUrl + (webAccessUrl.endsWith("/") ? "" : "/") + "PasswordResetConfirm.jsp?t=" + resetToken + "&p=" + providerName + "&s=" + segmentName + "&id=" + principalName;
            String resetCancelUrl = webAccessUrl + (webAccessUrl.endsWith("/") ? "" : "/") + "PasswordResetCancel.jsp?t=" + resetToken + "&p=" + providerName + "&s=" + segmentName + "&id=" + principalName;
            String description = this.getRequestPasswordResetNotificationTemplate(userHome);
            description = description.replace("{RESET_CONFIRM_URL}", resetConfirmUrl);
            description = description.replace("{RESET_CANCEL_URL}", resetCancelUrl);
            List<Path> alertIdentities = Base.getInstance().sendAlert((ContextCapable)userHome, principalName, name, description, (short)2, 0, null);
            Topic alertTopic = Workflows.getInstance().findTopic("Alert Modifications", workflowSegment);
            if (alertTopic != null) {
                SubscriptionQuery subscriptionQuery = (SubscriptionQuery)pm.newQuery(Subscription.class);
                subscriptionQuery.isActive().isTrue();
                subscriptionQuery.thereExistsTopic().equalTo(alertTopic);
                if (userHome.getSubscription(subscriptionQuery).isEmpty()) {
                    for (WfProcess wfProcess : alertTopic.getPerformAction()) {
                        for (Path alertIdentity : alertIdentities) {
                            Alert alert = (Alert)pm.getObjectById((Object)alertIdentity);
                            Workflows.getInstance().executeWorkflow(name, userHome, wfProcess, (ContextCapable)alert, null, null, null, null, null, null, null);
                        }
                    }
                }
            }
            SysLog.warning((String)"Password reset request", Arrays.asList(resetConfirmUrl, resetCancelUrl));
            this.changePassword((Password)loginPrincipal.getCredential(), null, RESET_PASSWORD_PREFIX + resetToken);
        }
    }

    public UserHome getUserHome(Path from, PersistenceManager pm) throws ServiceException {
        return this.getUserHome(from, pm, false);
    }

    public UserHome getUserHome(Path from, PersistenceManager pm, boolean useRunAsPrincipal) throws ServiceException {
        List principalChain = UserObjects.getPrincipalChain((PersistenceManager)pm);
        return (UserHome)pm.getObjectById((Object)new Path(new String[]{"org:opencrx:kernel:home1", "provider", from.getSegment(2).toString(), "segment", from.getSegment(4).toString(), "userHome", useRunAsPrincipal && principalChain.size() > 1 ? (String)principalChain.get(1) : (String)principalChain.get(0)}));
    }

    public UserHome getUserHome(String user, Path from, PersistenceManager pm) throws ServiceException {
        return this.getUserHome(user, from, pm, false);
    }

    public UserHome getUserHome(String user, Path from, PersistenceManager pm, boolean useRunAsPrincipal) throws ServiceException {
        List principalChain = PersistenceManagers.toPrincipalChain((String)user);
        if (principalChain.isEmpty()) {
            return null;
        }
        Path userHomePath = new Path(new String[]{"org:opencrx:kernel:home1", "provider", from.getSegment(2).toString(), "segment", from.getSegment(4).toString(), "userHome", useRunAsPrincipal && principalChain.size() > 1 ? (String)principalChain.get(1) : (String)principalChain.get(0)});
        return (UserHome)pm.getObjectById((Object)userHomePath);
    }

    private byte[] getPasswordDigest(String password, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(password.getBytes("UTF-8"));
            return md.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public Password createPasswordCredential(org.openmdx.security.realm1.jmi1.Subject subject, List<String> errors) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)subject);
        String providerName = subject.refGetPath().getSegment(2).toString();
        Segment authenticationSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.authentication1").getDescendant(new String[]{"provider", providerName, "segment", "Root"}));
        Password passwordCredential = (Password)pm.newInstance(Password.class);
        passwordCredential.setSubject((Subject)subject);
        passwordCredential.setLocked(Boolean.FALSE.booleanValue());
        authenticationSegment.addCredential(false, this.getUidAsString(), (Credential)passwordCredential);
        return passwordCredential;
    }

    public short changePassword(Password passwordCredential, String oldPassword, String password) {
        if (password == null) {
            return 1;
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)passwordCredential);
        PersistenceManager pmRoot = null;
        Password passwordCredentialByRoot = null;
        if (JDOHelper.isNew((Object)passwordCredential)) {
            passwordCredentialByRoot = passwordCredential;
        } else {
            pmRoot = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
            passwordCredentialByRoot = (Password)pmRoot.getObjectById((Object)passwordCredential.refGetPath());
        }
        try {
            Configuration config = (Configuration)pm.getUserObject((Object)Configuration.class.getSimpleName());
            byte[] oldPasswordDigest = null;
            if (oldPassword == null) {
                oldPasswordDigest = null;
            } else if (oldPassword.startsWith(RESET_PASSWORD_PREFIX)) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                bytes.write(RESET_PASSWORD_PREFIX.getBytes("UTF-8"));
                bytes.write(this.getPasswordDigest(oldPassword.substring(RESET_PASSWORD_PREFIX.length()), config.getPasswordEncodingAlgorithm()));
                bytes.close();
                oldPasswordDigest = bytes.toByteArray();
            } else {
                oldPasswordDigest = this.getPasswordDigest(oldPassword, config.getPasswordEncodingAlgorithm());
            }
            byte[] newPasswordDigest = null;
            if (password.startsWith(RESET_PASSWORD_PREFIX)) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                bytes.write(RESET_PASSWORD_PREFIX.getBytes("UTF-8"));
                bytes.write(this.getPasswordDigest(password.substring(RESET_PASSWORD_PREFIX.length()), config.getPasswordEncodingAlgorithm()));
                bytes.close();
                newPasswordDigest = bytes.toByteArray();
            } else {
                newPasswordDigest = this.getPasswordDigest(password, config.getPasswordEncodingAlgorithm());
            }
            if (pmRoot != null) {
                pmRoot.currentTransaction().begin();
            }
            PasswordChangeParams changePasswordParams = (PasswordChangeParams)Structures.create(PasswordChangeParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PasswordChangeParams.Member.oldPassword, (Object)oldPasswordDigest), Datatypes.member((Enum)PasswordChangeParams.Member.password, (Object)newPasswordDigest)});
            passwordCredentialByRoot.change(changePasswordParams);
            if (pmRoot != null) {
                pmRoot.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            ServiceException e0 = new ServiceException(e);
            if (e0.getCause("OpenCrxDomain").getExceptionCode() == -2) {
                return 7;
            }
            SysLog.warning((String)e.getMessage(), (Throwable)e.getCause());
            return 5;
        }
        return 0;
    }

    public boolean testPasswordPolicy(String password) {
        return true;
    }

    public short changePassword(UserHome userHome, String oldPassword, String newPassword, String newPasswordVerification) {
        boolean verifyOldPassword;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
        if (newPassword == null) {
            return 1;
        }
        if (newPasswordVerification == null) {
            return 2;
        }
        if (!newPassword.equals(newPasswordVerification)) {
            return 3;
        }
        if (!this.testPasswordPolicy(newPassword)) {
            return 8;
        }
        List principalChain = UserObjects.getPrincipalChain((PersistenceManager)pm);
        String requestingPrincipalName = !principalChain.isEmpty() ? (String)principalChain.get(0) : "guest";
        String segmentName = userHome.refGetPath().getSegment(4).toString();
        boolean requestingPrincipalOwnsUserHome = userHome.refGetPath().getLastSegment().toString().equals(requestingPrincipalName);
        boolean requestingPrincipalIsAdmin = requestingPrincipalName.equals("admin" + SecurityKeys.ID_SEPARATOR + segmentName);
        if (!requestingPrincipalOwnsUserHome && !requestingPrincipalIsAdmin) {
            return 5;
        }
        boolean bl = verifyOldPassword = oldPassword != null && oldPassword.startsWith(RESET_PASSWORD_PREFIX) || !requestingPrincipalIsAdmin;
        if (verifyOldPassword && oldPassword == null) {
            return 6;
        }
        String principalName = userHome.refGetPath().getLastSegment().toString();
        Principal principal = null;
        try {
            principal = (Principal)SecureObject.getInstance().findPrincipal(principalName, SecureObject.getInstance().getLoginRealmIdentity(userHome.refGetPath().getSegment(2).toString()), pm);
        }
        catch (Exception e) {
            ServiceException e0 = new ServiceException(e);
            SysLog.warning((String)e0.getMessage(), (Throwable)e0.getCause());
            return 4;
        }
        if (principal.getCredential() instanceof Password) {
            Password passwordCredential = (Password)principal.getCredential();
            if (oldPassword.startsWith(RESET_PASSWORD_PREFIX) && passwordCredential.getModifiedAt().getTime() + 600000L < System.currentTimeMillis()) {
                return 5;
            }
            return this.changePassword(passwordCredential, verifyOldPassword ? oldPassword : null, newPassword);
        }
        ArrayList<String> errors = new ArrayList<String>();
        this.validateCredential(principal, errors);
        if (errors.isEmpty()) {
            return 0;
        }
        SysLog.warning((String)"Principal has no credential. Unable to change password", errors);
        return 5;
    }

    protected String getSubjectName(String principalName, Contact contact) throws ServiceException {
        return principalName;
    }

    protected void validateCredential(org.openmdx.security.realm1.jmi1.Principal principal, List<String> errors) {
        if (principal.getCredential() == null) {
            errors.add("ERROR: No credential specified for principal '" + principal.refGetPath().getLastSegment() + "'");
        }
    }

    public UserHome createUserHome(Realm realm, Contact contact, PrincipalGroup primaryGroup, String principalId, List<org.openmdx.security.realm1.jmi1.Group> requiredGroups, boolean isAdministrator, String initialPassword, String initialPasswordVerification, String eMailAddress, String timezone, List<String> errors) throws ServiceException {
        Path loginRealmIdentity;
        if (principalId == null) {
            errors.add("ERROR: Missing principal name");
            return null;
        }
        if (contact == null) {
            errors.add("ERROR: Missing contact");
            return null;
        }
        if (!this.testPasswordPolicy(initialPassword)) {
            errors.add("ERROR: Password policy violation");
            return null;
        }
        if (!Admin.getInstance().isValidPrincipalId(principalId)) {
            errors.add("ERROR: Principal name is not valid");
            return null;
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)realm);
        String providerName = contact.refGetPath().getSegment(2).toString();
        String segmentName = contact.refGetPath().getSegment(4).toString();
        String subjectName = this.getSubjectName(principalId, contact);
        User user = null;
        PrincipalGroup groupAdministrators = null;
        org.openmdx.security.realm1.jmi1.Subject subject = null;
        PersistenceManager pmRoot = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
        Realm loginRealm = (Realm)pmRoot.getObjectById((Object)(loginRealmIdentity = SecureObject.getInstance().getLoginRealmIdentity(providerName)));
        if (loginRealm.getPrincipal(principalId) != null && realm.getPrincipal(principalId) == null) {
            boolean hasAcceptedCreateUserConfirmations = false;
            TreeSet<String> realmNames = new TreeSet<String>();
            org.openmdx.security.realm1.jmi1.Segment realmSegment = (org.openmdx.security.realm1.jmi1.Segment)pmRoot.getObjectById((Object)loginRealm.refGetPath().getParent().getParent());
            for (Object aRealm : realmSegment.getRealm()) {
                if (aRealm.getPrincipal(principalId) == null) continue;
                Path userHomeIdentity = new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName, "segment", aRealm.getName(), "userHome", principalId});
                UserHome userHome = null;
                try {
                    userHome = (UserHome)pmRoot.getObjectById((Object)userHomeIdentity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (userHome == null) continue;
                realmNames.add(aRealm.getName());
                String alertName = "CreateUserConfirmationRequest " + principalId + "@" + realm.refGetPath().getLastSegment().toString();
                AlertQuery alertQuery = (AlertQuery)pm.newQuery(Alert.class);
                alertQuery.name().equalTo((Object)alertName);
                alertQuery.alertState().equalTo((Object)AlertState.ACCEPTED.getValue());
                alertQuery.createdAt().greaterThanOrEqualTo((Comparable)new Date(System.currentTimeMillis() - 86400000L));
                List alerts = userHome.getAlert(alertQuery);
                if (alerts.isEmpty()) continue;
                hasAcceptedCreateUserConfirmations = true;
                break;
            }
            if (!hasAcceptedCreateUserConfirmations) {
                Object users = "";
                for (String realmName : realmNames) {
                    Path userHomeIdentity = new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", providerName, "segment", realmName, "userHome", principalId});
                    UserHome userHome = (UserHome)pmRoot.getObjectById((Object)userHomeIdentity);
                    Base.getInstance().sendAlert((ContextCapable)userHome, principalId, "CreateUserConfirmationRequest " + principalId + "@" + realm.refGetPath().getLastSegment().toString(), "[%\nMessage from 'admin" + SecurityKeys.ID_SEPARATOR + realm.refGetPath().getLastSegment().toString() + "': Mark this alert as accepted to allow the creation of user '" + principalId + "' in segment '" + segmentName + "'.\n\nIMPORTANT: ONLY accept if you requested that '" + principalId + "' is to be added to segment '" + segmentName + "'!\n%]", (short)2, 0, null);
                    users = (String)users + (((String)users).isEmpty() ? "" : ", ") + principalId + "@" + realmName;
                }
                errors.add("ERROR: Principal already in use. CreateUserConfirmationRequests are sent to users {" + (String)users + "}. Waiting for acceptance.");
                pmRoot.close();
                return null;
            }
        }
        pmRoot.currentTransaction().begin();
        try {
            QuotaByteArrayOutputStream item = new QuotaByteArrayOutputStream(UserHomes.class.getName());
            PrintWriter pw = new PrintWriter(item);
            pw.println("Subject;" + subjectName + ";" + contact.getFullName());
            pw.println("Principal;" + principalId + ";" + segmentName + "\\\\" + principalId + ";" + subjectName + ";Users");
            pw.close();
            Admin.getInstance().importLoginPrincipals((org.opencrx.kernel.admin1.jmi1.Segment)pmRoot.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.admin1").getDescendant(new String[]{"provider", providerName, "segment", "Root"})), item.toByteArray());
            org.openmdx.security.realm1.jmi1.Principal loginPrincipal = loginRealm.getPrincipal(principalId);
            if (loginPrincipal.getSubject() == null) {
                errors.add("ERROR: Undefined subject for principal '" + principalId + "'");
                return null;
            }
            subject = loginPrincipal.getSubject();
            if (initialPassword != null && !initialPassword.isEmpty()) {
                Password passwordCredential = this.createPasswordCredential(subject, errors);
                if (passwordCredential == null) {
                    errors.add("ERROR: Creation of password credential failed for principal '" + principalId + "'");
                    return null;
                }
                short changePasswordStatus = this.changePassword(passwordCredential, null, initialPassword);
                if (changePasswordStatus != 0) {
                    errors.add("ERROR: Changing of password failed with status " + changePasswordStatus);
                    return null;
                }
                loginPrincipal.setCredential((org.openmdx.security.realm1.cci2.Credential)passwordCredential);
            }
            this.validateCredential(loginPrincipal, errors);
        }
        catch (Exception e) {
            ServiceException e1 = new ServiceException(e);
            SysLog.warning((String)e1.getMessage(), (Throwable)e1.getCause());
            errors.add("ERROR: Can not retrieve principal '" + principalId + "' in realm '" + segmentName + "'");
            errors.add("reason is " + e.getMessage());
            return null;
        }
        Realm realmByRoot = (Realm)pmRoot.getObjectById((Object)realm.refGetPath());
        user = (User)Admin.getInstance().createPrincipal(principalId + ".User", null, null, realmByRoot, Admin.PrincipalType.USER, new ArrayList<org.openmdx.security.realm1.jmi1.Group>(), subject);
        groupAdministrators = (PrincipalGroup)realmByRoot.getPrincipal("Administrators");
        PrincipalGroup groupUsers = (PrincipalGroup)realmByRoot.getPrincipal("Users");
        ArrayList<org.openmdx.security.realm1.jmi1.Group> groups = new ArrayList<org.openmdx.security.realm1.jmi1.Group>();
        if (isAdministrator) {
            groups.add(groupAdministrators);
            groups.add(user);
            groups.add(groupUsers);
        } else {
            groups.add(groupUsers);
            groups.add(user);
        }
        if (requiredGroups != null) {
            for (org.openmdx.security.realm1.jmi1.Group requiredGroup : requiredGroups) {
                groups.add((org.openmdx.security.realm1.jmi1.Group)pmRoot.getObjectById((Object)requiredGroup.refGetPath()));
            }
        }
        Admin.getInstance().createPrincipal(principalId, null, null, realmByRoot, Admin.PrincipalType.PRINCIPAL, groups, subject);
        Admin.getInstance().createPrincipal(principalId, null, null, (Realm)pmRoot.getObjectById((Object)realm.refGetPath().getParent().getChild("Root")), Admin.PrincipalType.PRINCIPAL, new ArrayList<org.openmdx.security.realm1.jmi1.Group>(), subject);
        Admin.getInstance().createPrincipal(principalId + ".User", null, null, (Realm)pmRoot.getObjectById((Object)realm.refGetPath().getParent().getChild("Root")), Admin.PrincipalType.USER, new ArrayList<org.openmdx.security.realm1.jmi1.Group>(), subject);
        initialPassword = initialPassword == null ? "" : initialPassword;
        String string = initialPasswordVerification = initialPasswordVerification == null ? "" : initialPasswordVerification;
        if (!initialPassword.equals(initialPasswordVerification)) {
            errors.add("the passwords you typed do not match");
            return null;
        }
        pmRoot.currentTransaction().commit();
        Path userHomeIdentity = null;
        PersistenceManager pmAdmin = pm.getPersistenceManagerFactory().getPersistenceManager(UserObjects.getPrincipalChain((PersistenceManager)pm).toString(), null);
        org.opencrx.kernel.home1.jmi1.Segment userHomeSegment = this.getUserHomeSegment(pmAdmin, providerName, segmentName);
        UserHome userHome = null;
        pmAdmin.currentTransaction().begin();
        user = (User)pmAdmin.getObjectById((Object)user.refGetPath());
        groupAdministrators = (PrincipalGroup)pmAdmin.getObjectById((Object)groupAdministrators.refGetPath());
        primaryGroup = primaryGroup == null ? null : (PrincipalGroup)pmAdmin.getObjectById((Object)primaryGroup.refGetPath());
        userHome = userHomeSegment.getUserHome(principalId);
        if (userHome != null) {
            if (primaryGroup != null) {
                userHome.setPrimaryGroup(primaryGroup);
            }
            userHomeIdentity = userHome.refGetPath();
        } else {
            userHome = (UserHome)pmAdmin.newInstance(UserHome.class);
            userHomeSegment.addUserHome(principalId, userHome);
            userHome.setOwningUser(user);
            userHome.getOwningGroup().add(groupAdministrators);
            userHome.setAccessLevelDelete((short)0);
            userHome.setAccessLevelUpdate((short)2);
            Properties userSettings = this.getDefaultUserSettings(userHome);
            userSettings.putAll((Map<?, ?>)this.getUserSettings(userHome));
            this.applyUserSettings(userHome, 0, userSettings, true, true, primaryGroup, "-".equals(timezone) ? null : timezone, "1", null, "[" + providerName + ":" + segmentName + "]", null, "8", false, false, null, null);
            userHomeIdentity = userHome.refGetPath();
        }
        userHome.setContact((Contact)pmAdmin.getObjectById((Object)contact.refGetPath()));
        pmAdmin.currentTransaction().commit();
        if (userHome != null && eMailAddress != null && !eMailAddress.isEmpty() && !"-".equals(eMailAddress)) {
            EMailAccountQuery emailAccountQuery = (EMailAccountQuery)pmAdmin.newQuery(EMailAccount.class);
            emailAccountQuery.name().equalTo((Object)eMailAddress);
            List emailAccounts = userHome.getEMailAccount(emailAccountQuery);
            if (emailAccounts.isEmpty()) {
                pmAdmin.currentTransaction().begin();
                EMailAccount eMailAccount = (EMailAccount)pmAdmin.newInstance(EMailAccount.class);
                eMailAccount.setName(eMailAddress);
                eMailAccount.setDefault(Boolean.TRUE);
                eMailAccount.setActive(Boolean.TRUE);
                userHome.addEMailAccount(this.getUidAsString(), eMailAccount);
                pmAdmin.currentTransaction().commit();
            }
        }
        return userHomeIdentity == null ? null : (UserHome)pm.getObjectById((Object)userHomeIdentity);
    }

    private Contact retrieveContact(org.opencrx.kernel.account1.jmi1.Segment accountSegment, String aliasName, String fullName) {
        try {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
            AccountQuery accountQuery = (AccountQuery)pm.newQuery(Account.class);
            if (!"-".equals(aliasName)) {
                accountQuery.thereExistsAliasName().equalTo((Object)aliasName);
            } else if (!"-".equals(fullName)) {
                accountQuery.thereExistsFullName().equalTo((Object)fullName);
            }
            List accounts = accountSegment.getAccount(accountQuery);
            if (!accounts.isEmpty()) {
                return (Contact)accounts.iterator().next();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String importUsers(org.opencrx.kernel.home1.jmi1.Segment homeSegment, byte[] item) throws ServiceException {
        BufferedReader reader;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)homeSegment);
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException((Exception)e);
        }
        String providerName = homeSegment.refGetPath().getSegment(2).toString();
        String segmentName = homeSegment.refGetPath().getSegment(4).toString();
        Realm realm = (Realm)pm.getObjectById((Object)SecureObject.getRealmIdentity(providerName, segmentName));
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, providerName, segmentName);
        int nCreatedUsers = 0;
        int nFailedUsersNoPrimaryGroup = 0;
        int nFailedUsersNoContact = 0;
        int nFailedUsersOther = 0;
        int nExistingUsers = 0;
        while (true) {
            ArrayList<org.openmdx.security.realm1.jmi1.Group> isMemberOf;
            ArrayList<String> errors;
            PrincipalGroup primaryGroup;
            Contact contact;
            String timezone;
            String emailAddress;
            String password;
            String principalName;
            block19: {
                StringTokenizer g;
                block20: {
                    try {
                        while (reader.ready()) {
                            String l = reader.readLine();
                            if (l.indexOf("User;") < 0) continue;
                            StringTokenizer t = new StringTokenizer(l, ";");
                            t.nextToken();
                            principalName = t.nextToken();
                            String accountAlias = t.nextToken();
                            String accountFullName = t.nextToken();
                            String primaryGroupName = t.nextToken();
                            password = t.nextToken();
                            String groups = t.hasMoreTokens() ? t.nextToken() : "";
                            emailAddress = t.hasMoreTokens() ? t.nextToken() : null;
                            timezone = t.hasMoreTokens() ? t.nextToken() : null;
                            UserHome userHome = null;
                            try {
                                userHome = homeSegment.getUserHome(principalName);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (userHome == null) {
                                try {
                                    contact = this.retrieveContact(accountSegment, accountAlias, accountFullName);
                                    if (contact != null) {
                                        primaryGroup = null;
                                        try {
                                            if ("-".equals(primaryGroupName)) {
                                                primaryGroup = (PrincipalGroup)realm.getPrincipal(primaryGroupName);
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        errors = new ArrayList<String>();
                                        isMemberOf = new ArrayList<org.openmdx.security.realm1.jmi1.Group>();
                                        if ("-".equals(groups)) break block19;
                                        g = new StringTokenizer(groups, ",");
                                        break block20;
                                    }
                                    SysLog.info((String)("Contact " + accountAlias + "/" + accountFullName + " for user " + principalName + " not found"));
                                    ++nFailedUsersNoContact;
                                    continue;
                                }
                                catch (Exception e) {
                                    new ServiceException(e).log();
                                    ++nFailedUsersOther;
                                    continue;
                                }
                            }
                            ++nExistingUsers;
                        }
                        return "Users=(created:" + nCreatedUsers + ",existing:" + nExistingUsers + ",failed no primary group:" + nFailedUsersNoPrimaryGroup + ",failed no contact:" + nFailedUsersNoContact + ",failed other:" + nFailedUsersOther + ");";
                    }
                    catch (IOException e) {
                        new ServiceException((Exception)e).log();
                    }
                    return "Users=(created:" + nCreatedUsers + ",existing:" + nExistingUsers + ",failed no primary group:" + nFailedUsersNoPrimaryGroup + ",failed no contact:" + nFailedUsersNoContact + ",failed other:" + nFailedUsersOther + ");";
                }
                while (g.hasMoreTokens()) {
                    org.openmdx.security.realm1.jmi1.Group group = null;
                    try {
                        group = (org.openmdx.security.realm1.jmi1.Group)realm.getPrincipal(g.nextToken());
                        isMemberOf.add(group);
                    }
                    catch (Exception exception) {}
                }
            }
            this.createUserHome(realm, contact, primaryGroup, principalName, isMemberOf, false, password, password, emailAddress, timezone, errors);
            if (errors.isEmpty()) {
                ++nCreatedUsers;
                continue;
            }
            ++nFailedUsersOther;
        }
    }

    public ObjectFinder searchBasic(UserHome userHome, String searchExpression) throws ServiceException {
        String[] words = searchExpression.split("[\\s,]");
        StringBuilder allWords = new StringBuilder();
        StringBuilder atLeastOneOfTheWords = new StringBuilder();
        StringBuilder withoutWords = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (i < words.length - 1 && "OR".equals(words[i + 1]) || i > 0 && "OR".equals(words[i - 1])) {
                atLeastOneOfTheWords.append(" ").append(words[i]);
                continue;
            }
            if ("OR".equals(words[i])) continue;
            if (words[i].startsWith("-")) {
                withoutWords.append(" ").append(words[i].substring(1));
                continue;
            }
            allWords.append(" ").append(words[i]);
        }
        return this.searchAdvanced(userHome, allWords.toString().trim(), atLeastOneOfTheWords.toString().trim(), withoutWords.toString().trim());
    }

    public ObjectFinder searchAdvanced(UserHome userHome, String allWords, String atLeastOneOfTheWords, String withoutWords) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
        ObjectFinder objectFinder = (ObjectFinder)pm.newInstance(ObjectFinder.class);
        objectFinder.setName(allWords != null && !allWords.isEmpty() ? allWords : (atLeastOneOfTheWords != null && atLeastOneOfTheWords.length() > 0 ? atLeastOneOfTheWords : withoutWords));
        if (allWords != null) {
            objectFinder.setAllWords(allWords.toLowerCase());
        }
        if (atLeastOneOfTheWords != null) {
            objectFinder.setAtLeastOneOfTheWords(atLeastOneOfTheWords.toLowerCase());
        }
        if (withoutWords != null) {
            objectFinder.setWithoutWords(withoutWords.toLowerCase());
        }
        userHome.addObjectFinder(this.getUidAsString(), objectFinder);
        return objectFinder;
    }

    public String getWebAccessUrl(UserHome userHome) {
        Path userHomeIdentity = userHome.refGetPath();
        return userHome.getWebAccessUrl() == null ? "http://localhost/opencrx-core-" + userHomeIdentity.getSegment(2).toString() + "/ObjectInspectorServlet" : userHome.getWebAccessUrl() + "/ObjectInspectorServlet";
    }

    public void applyUserSettings(UserHome userHome, int currentPerspective, Properties settings, boolean doNotInitUserHome, boolean storeSettings, PrincipalGroup primaryGroup, String settingTimezone, String settingStoreSettingsOnLogoff, String settingDefaultEmailAccount, String settingSendmailSubjectPrefix, String settingWebAccessUrl, String settingTopNavigationShowMax, Boolean settingHideWorkspaceDashboard, Boolean settingAnchorUserDialog, List<String> settingRootObjects, Map<String, String> settingSubscriptions) throws ServiceException {
        this.applyUserSettings(userHome, currentPerspective, settings, storeSettings, primaryGroup, new OpenCrxUserSettings(settingTimezone, settingStoreSettingsOnLogoff, settingDefaultEmailAccount, settingSendmailSubjectPrefix, settingWebAccessUrl, settingTopNavigationShowMax, settingHideWorkspaceDashboard, settingAnchorUserDialog, settingRootObjects, settingSubscriptions), doNotInitUserHome);
    }

    public void applyUserSettings(UserHome userHome, int currentPerspective, Properties settings, boolean storeSettings, PrincipalGroup primaryGroup, OpenCrxUserSettings newSettings, boolean doNotInitUserHome) throws ServiceException {
        EMailAccount defaultEmailAccount;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
        String providerName = userHome.refGetPath().getSegment(2).toString();
        String segmentName = userHome.refGetPath().getSegment(4).toString();
        String principalName = userHome.refGetPath().getLastSegment().toString();
        PersistenceManager pmAdmin = pm.getPersistenceManagerFactory().getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
        pmAdmin.currentTransaction().begin();
        Realm realm = SecureObject.getInstance().getRealm(pmAdmin, providerName, segmentName);
        PrincipalGroup privatePrincipalGroup = (PrincipalGroup)SecureObject.getInstance().findPrincipal(principalName + ".Group", realm);
        if (privatePrincipalGroup == null) {
            privatePrincipalGroup = (PrincipalGroup)pmAdmin.newInstance(PrincipalGroup.class);
            privatePrincipalGroup.setDescription(segmentName + "\\\\" + principalName + ".Group");
            realm.addPrincipal(principalName + ".Group", (org.openmdx.security.realm1.jmi1.Principal)privatePrincipalGroup);
        }
        org.openmdx.security.realm1.jmi1.Principal principal = null;
        try {
            PrincipalGroup publicGroup;
            principal = SecureObject.getInstance().findPrincipal(principalName, realm);
            if (!principal.getIsMemberOf().contains(privatePrincipalGroup)) {
                principal.getIsMemberOf().add(privatePrincipalGroup);
            }
            if ((publicGroup = (PrincipalGroup)SecureObject.getInstance().findPrincipal("Public", realm)) != null && !principal.getIsMemberOf().contains(publicGroup)) {
                principal.getIsMemberOf().add(publicGroup);
            }
        }
        catch (Exception publicGroup) {
            // empty catch block
        }
        if (principal != null && privatePrincipalGroup != null) {
            privatePrincipalGroup.setSubject((Subject)principal.getSubject());
        }
        pmAdmin.currentTransaction().commit();
        pmAdmin.close();
        if (!doNotInitUserHome) {
            List currentPrincipals = UserObjects.getPrincipalChain((PersistenceManager)pm);
            if (!currentPrincipals.isEmpty() && !principalName.equals(currentPrincipals.get(0))) {
                throw new ServiceException("DefaultDomain", -2, "doNotInitUserHome=false requires that principal of invoking pm matches the user home's principal", new BasicException.Parameter[]{new BasicException.Parameter("pm.principalChain", (Object)currentPrincipals), new BasicException.Parameter("userHome.xri", (Object)userHome.refGetPath())});
            }
            this.initUserHome(userHome);
        }
        if (primaryGroup == null) {
            Realm realm2 = SecureObject.getInstance().getRealm(pm, providerName, segmentName);
            PrincipalGroup privatePrincipalGroup2 = (PrincipalGroup)SecureObject.getInstance().findPrincipal(principalName + ".Group", realm2);
            userHome.setPrimaryGroup(privatePrincipalGroup2);
        } else {
            userHome.setPrimaryGroup(primaryGroup);
        }
        if (newSettings.getTimezone() != null) {
            settings.setProperty(UserSettings.TIMEZONE_NAME.getName(), newSettings.getTimezone());
        }
        userHome.setStoreSettingsOnLogoff(Boolean.valueOf(newSettings.getStoreSettingsOnLogoff() == null ? "false" : "true"));
        if (newSettings.getWebAccessUrl() != null) {
            userHome.setWebAccessUrl(newSettings.getWebAccessUrl());
        }
        if (newSettings.getSendmailSubjectPrefix() != null) {
            userHome.setSendMailSubjectPrefix(newSettings.getSendmailSubjectPrefix());
        }
        if (newSettings.getAnchorUserDialog() != null) {
            settings.setProperty(UserSettings.ANCHOR_USER_DIALOG.getName(), Boolean.TRUE.equals(newSettings.getAnchorUserDialog()) ? "true" : "false");
        }
        EMailAccountQuery emailAccountQuery = (EMailAccountQuery)pm.newQuery(EMailAccount.class);
        emailAccountQuery.thereExistsIsActive().isTrue();
        emailAccountQuery.thereExistsIsDefault().isTrue();
        List emailAccounts = userHome.getEMailAccount(emailAccountQuery);
        EMailAccount eMailAccount = defaultEmailAccount = emailAccounts.isEmpty() ? null : (EMailAccount)emailAccounts.iterator().next();
        if (defaultEmailAccount == null && newSettings.getDefaultEmailAccount() != null && newSettings.getDefaultEmailAccount().length() > 0) {
            defaultEmailAccount = (EMailAccount)pm.newInstance(EMailAccount.class);
            defaultEmailAccount.setDefault(Boolean.TRUE);
            defaultEmailAccount.setActive(Boolean.TRUE);
            defaultEmailAccount.setName(newSettings.getDefaultEmailAccount());
            userHome.addEMailAccount(this.getUidAsString(), defaultEmailAccount);
        } else if (defaultEmailAccount != null && (newSettings.getDefaultEmailAccount() == null || newSettings.getDefaultEmailAccount().length() == 0)) {
            defaultEmailAccount.refDelete();
        } else if (defaultEmailAccount != null) {
            defaultEmailAccount.setName(newSettings.getDefaultEmailAccount());
        }
        for (int i = 0; i < 20; ++i) {
            String state = newSettings.getRootObjects() != null && i < newSettings.getRootObjects().size() ? newSettings.getRootObjects().get(i) : "1";
            settings.setProperty(UserSettings.ROOT_OBJECT_STATE.getName() + (String)(currentPerspective == 0 ? "" : "[" + Integer.toString(currentPerspective) + "]") + "." + i + ".State", state == null ? "0" : state);
        }
        if (newSettings.getTopNavigationShowMax() != null) {
            settings.setProperty(UserSettings.TOP_NAVIGATION_SHOW_MAX.getName(), newSettings.getTopNavigationShowMax());
        }
        if (newSettings.getHideWorkspaceDashboard() != null) {
            settings.setProperty(UserSettings.HIDE_WORKSPACE_DASHBOARD.getName(), Boolean.toString(newSettings.getHideWorkspaceDashboard()));
        }
        org.opencrx.kernel.workflow1.jmi1.Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, providerName, segmentName);
        SegmentContainsTopic.Topic topics = workflowSegment.getTopic();
        Iterator iterator = topics.iterator();
        while (iterator.hasNext()) {
            Topic topic = (Topic)iterator.next();
            SubscriptionQuery query = (SubscriptionQuery)pm.newQuery(Subscription.class);
            query.thereExistsTopic().equalTo(topic);
            List subscriptions = userHome.getSubscription(query);
            Subscription subscription = null;
            if (subscriptions.isEmpty()) {
                subscription = (Subscription)pm.newInstance(Subscription.class);
                subscription.setName(topic.getName());
                subscription.setTopic(topic);
                userHome.addSubscription(this.getUidAsString(), subscription);
            } else {
                subscription = (Subscription)subscriptions.iterator().next();
            }
            subscription.getEventType().clear();
            String topicId = topic.refGetPath().getLastSegment().toString();
            subscription.setActive(newSettings.getSubscriptions() != null && newSettings.getSubscriptions().get("topicIsActive-" + topicId) != null);
            if (newSettings.getSubscriptions() != null && newSettings.getSubscriptions().get("topicCreation-" + topicId) != null) {
                subscription.getEventType().add((short)1);
            }
            if (newSettings.getSubscriptions() != null && newSettings.getSubscriptions().get("topicReplacement-" + topicId) != null) {
                subscription.getEventType().add((short)3);
            }
            if (newSettings.getSubscriptions() == null || newSettings.getSubscriptions().get("topicRemoval-" + topicId) == null) continue;
            subscription.getEventType().add((short)4);
        }
        if (storeSettings) {
            try {
                QuotaByteArrayOutputStream bsSettings = new QuotaByteArrayOutputStream(UserHomes.class.getName());
                settings.store(bsSettings, "settings of user " + userHome.refMofId());
                bsSettings.close();
                userHome.setSettings(bsSettings.toString("UTF-8"));
            }
            catch (IOException e) {
                throw new ServiceException((Exception)e);
            }
        }
    }

    public void initUserHome(UserHome userHome) throws ServiceException {
        Path userHomeIdentity = userHome.refGetPath();
        String providerName = userHomeIdentity.getSegment(2).toString();
        String segmentName = userHomeIdentity.getSegment(4).toString();
        String principalName = userHomeIdentity.getLastSegment().toString();
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
        Realm realm = SecureObject.getInstance().getRealm(pm, providerName, segmentName);
        PrincipalGroup privatePrincipalGroup = (PrincipalGroup)SecureObject.getInstance().findPrincipal(principalName + ".Group", realm);
        org.opencrx.kernel.activity1.jmi1.Segment activitySegment = Activities.getInstance().getActivitySegment(pm, providerName, segmentName);
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, providerName, segmentName);
        org.opencrx.kernel.document1.jmi1.Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
        ActivityTracker privateTracker = null;
        try {
            privateTracker = (ActivityTracker)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "activityTracker", principalName}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (privateTracker == null) {
            privateTracker = (ActivityTracker)pm.newInstance(ActivityTracker.class);
            privateTracker.setName(principalName + "~Private");
            if (privatePrincipalGroup != null) {
                privateTracker.getOwningGroup().clear();
                privateTracker.getOwningGroup().add(privatePrincipalGroup);
            }
            activitySegment.addActivityTracker(principalName, privateTracker);
        }
        org.opencrx.kernel.activity1.cci2.ActivityCreator privateIncidentsCreator = null;
        try {
            privateIncidentsCreator = (ActivityCreator)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "activityCreator", principalName}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (privateIncidentsCreator == null) {
            privateIncidentsCreator = (ActivityCreator)pm.newInstance(ActivityCreator.class);
            Activities.getInstance().initActivityCreator((ActivityCreator)privateIncidentsCreator, principalName + "~Private", Activities.getInstance().findActivityType("Bugs + Features", activitySegment), (short)1, ICalendar.ICalClass.PUBLIC, privateTracker == null ? null : Collections.singletonList(privateTracker), privatePrincipalGroup == null ? null : Collections.singletonList(privatePrincipalGroup));
            activitySegment.addActivityCreator(principalName, (ActivityCreator)privateIncidentsCreator);
        }
        if (privateIncidentsCreator.getIcalType() == 0) {
            privateIncidentsCreator.setIcalType((short)1);
        }
        org.opencrx.kernel.activity1.cci2.ActivityCreator privateEMailsCreator = null;
        try {
            privateEMailsCreator = (ActivityCreator)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "activityCreator", principalName + "~E-Mails"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (privateEMailsCreator == null) {
            privateEMailsCreator = (ActivityCreator)pm.newInstance(ActivityCreator.class);
            Activities.getInstance().initActivityCreator((ActivityCreator)privateEMailsCreator, principalName + "~Private~E-Mails", Activities.getInstance().findActivityType("E-Mails", activitySegment), (short)1, ICalendar.ICalClass.PUBLIC, privateTracker == null ? null : Collections.singletonList(privateTracker), privatePrincipalGroup == null ? null : Collections.singletonList(privatePrincipalGroup));
            activitySegment.addActivityCreator(principalName + "~E-Mails", (ActivityCreator)privateEMailsCreator);
        }
        if (privateEMailsCreator.getIcalType() == 0) {
            privateEMailsCreator.setIcalType((short)1);
        }
        org.opencrx.kernel.activity1.cci2.ActivityCreator privateTasksCreator = null;
        try {
            privateTasksCreator = (ActivityCreator)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "activityCreator", principalName + "~Tasks"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (privateTasksCreator == null) {
            privateTasksCreator = (ActivityCreator)pm.newInstance(ActivityCreator.class);
            Activities.getInstance().initActivityCreator((ActivityCreator)privateTasksCreator, principalName + "~Private~Tasks", Activities.getInstance().findActivityType("Tasks", activitySegment), (short)2, ICalendar.ICalClass.PUBLIC, privateTracker == null ? null : Collections.singletonList(privateTracker), privatePrincipalGroup == null ? null : Collections.singletonList(privatePrincipalGroup));
            activitySegment.addActivityCreator(principalName + "~Tasks", (ActivityCreator)privateTasksCreator);
        }
        if (privateTasksCreator.getIcalType() == 0) {
            privateTasksCreator.setIcalType((short)2);
        }
        org.opencrx.kernel.activity1.cci2.ActivityCreator privateMeetingsCreator = null;
        try {
            privateMeetingsCreator = (ActivityCreator)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "activityCreator", principalName + "~Meetings"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (privateMeetingsCreator == null) {
            privateMeetingsCreator = (ActivityCreator)pm.newInstance(ActivityCreator.class);
            Activities.getInstance().initActivityCreator((ActivityCreator)privateMeetingsCreator, principalName + "~Private~Meetings", Activities.getInstance().findActivityType("Meetings", activitySegment), (short)1, ICalendar.ICalClass.PUBLIC, privateTracker == null ? null : Collections.singletonList(privateTracker), privatePrincipalGroup == null ? null : Collections.singletonList(privatePrincipalGroup));
            activitySegment.addActivityCreator(principalName + "~Meetings", (ActivityCreator)privateMeetingsCreator);
        }
        if (privateMeetingsCreator.getIcalType() == 0) {
            privateMeetingsCreator.setIcalType((short)1);
        }
        privateTracker.setDefaultCreator(privateIncidentsCreator);
        Resource resource = null;
        try {
            resource = activitySegment.getResource(principalName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resource == null) {
            resource = (Resource)pm.newInstance(Resource.class);
            if (userHome.getContact() != null) {
                resource.setName(userHome.getContact().getFullName());
                resource.setContact(userHome.getContact());
            } else {
                resource.setName(principalName);
            }
            activitySegment.addResource(false, principalName, resource);
        }
        Group privateAccountGroup = null;
        try {
            privateAccountGroup = (Group)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.account1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "account", principalName + "~Private"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (privateAccountGroup == null) {
            privateAccountGroup = (Group)pm.newInstance(Group.class);
            privateAccountGroup.setName(principalName + "~Private");
            if (privatePrincipalGroup != null) {
                privateAccountGroup.getOwningGroup().clear();
                privateAccountGroup.getOwningGroup().add(privatePrincipalGroup);
            }
            accountSegment.addAccount(principalName + "~Private", privateAccountGroup);
        }
        DocumentFolder privateDocumentFolder = null;
        try {
            privateDocumentFolder = (DocumentFolder)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.document1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "folder", principalName + "~Private"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (privateDocumentFolder == null) {
            privateDocumentFolder = (DocumentFolder)pm.newInstance(DocumentFolder.class);
            privateDocumentFolder.setName(principalName + "~Private");
            if (privateDocumentFolder != null) {
                privateDocumentFolder.getOwningGroup().clear();
                privateDocumentFolder.getOwningGroup().add(privatePrincipalGroup);
            }
            documentSegment.addFolder(principalName + "~Private", privateDocumentFolder);
        }
        SetOwningUserParams setOwningUserParams = (SetOwningUserParams)Structures.create(SetOwningUserParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)SetOwningUserParams.Member.mode, (Object)1), Datatypes.member((Enum)SetOwningUserParams.Member.user, (Object)userHome.getOwningUser())});
        resource.setOwningUser(setOwningUserParams);
        CardProfile cardProfile = null;
        try {
            cardProfile = (CardProfile)pm.getObjectById((Object)userHome.refGetPath().getDescendant(new String[]{"syncProfile", "Card"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cardProfile == null) {
            cardProfile = (CardProfile)pm.newInstance(CardProfile.class);
            cardProfile.setName("Contacts");
            cardProfile.setDescription("Contacts profile");
            userHome.addSyncProfile("Card", cardProfile);
            ContactsFeed feed = (ContactsFeed)pm.newInstance(ContactsFeed.class);
            feed.setName(principalName + "~Private");
            feed.setDescription("Contacts Feed");
            feed.setAccountGroup(privateAccountGroup);
            feed.setActive(true);
            feed.setAllowAddDelete(true);
            feed.setAllowChange(true);
            cardProfile.addFeed(this.getUidAsString(), feed);
        }
        CalendarProfile calendarProfile = null;
        try {
            calendarProfile = (CalendarProfile)pm.getObjectById((Object)userHome.refGetPath().getDescendant(new String[]{"syncProfile", "Calendar"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (calendarProfile == null) {
            calendarProfile = (CalendarProfile)pm.newInstance(CalendarProfile.class);
            calendarProfile.setName("Calendars");
            calendarProfile.setDescription("Calendars profile");
            userHome.addSyncProfile("Calendar", calendarProfile);
            ActivityGroupCalendarFeed feed = (ActivityGroupCalendarFeed)pm.newInstance(ActivityGroupCalendarFeed.class);
            feed.setName(principalName + "~Private");
            feed.setDescription("Calendars Feed");
            feed.setActivityGroup(privateTracker);
            feed.setActive(true);
            feed.setAllowAddDelete(true);
            feed.setAllowChange(true);
            calendarProfile.addFeed(this.getUidAsString(), feed);
        }
        DocumentProfile documentProfile = null;
        try {
            documentProfile = (DocumentProfile)pm.getObjectById((Object)userHome.refGetPath().getDescendant(new String[]{"syncProfile", "Document"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (documentProfile == null) {
            documentProfile = (DocumentProfile)pm.newInstance(DocumentProfile.class);
            documentProfile.setName("Documents");
            documentProfile.setDescription("Documents profile");
            userHome.addSyncProfile("Document", documentProfile);
            DocumentFeed documentFeed = (DocumentFeed)pm.newInstance(DocumentFeed.class);
            documentFeed.setName(principalName + "~Private");
            documentFeed.setDescription("Documents Feed");
            documentFeed.setDocumentFolder(privateDocumentFolder);
            documentFeed.setActive(true);
            documentFeed.setAllowAddDelete(true);
            documentFeed.setAllowChange(true);
            documentProfile.addFeed(this.getUidAsString(), documentFeed);
        }
    }

    public Properties getUserSettings(UserHome userHome) throws ServiceException {
        Properties settings = new Properties();
        if (userHome.getSettings() != null) {
            try {
                settings.load(new ByteArrayInputStream(userHome.getSettings().getBytes("UTF-8")));
            }
            catch (IOException e) {
                throw new ServiceException((Exception)e);
            }
        }
        return settings;
    }

    public Properties getDefaultUserSettings(UserHome userHome) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
        String providerName = userHome.refGetPath().getSegment(2).toString();
        String segmentName = userHome.refGetPath().getSegment(4).toString();
        Realm realm = SecureObject.getInstance().getRealm(pm, providerName, segmentName);
        org.openmdx.security.realm1.jmi1.Principal principal = SecureObject.getInstance().findPrincipal(userHome.refGetPath().getLastSegment().toString(), realm);
        Properties defaultSettings = new Properties();
        if (principal instanceof Principal) {
            org.opencrx.kernel.document1.jmi1.Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
            List roles = ((Principal)principal).getGrantedRole();
            for (Role role : roles) {
                Document settingsTemplateDocument = Documents.getInstance().findDocument("UserSettings." + role.getName() + ".properties", documentSegment);
                if (settingsTemplateDocument == null || !(settingsTemplateDocument.getHeadRevision() instanceof MediaContent)) continue;
                try {
                    MediaContent settingsTemplateContent = (MediaContent)settingsTemplateDocument.getHeadRevision();
                    if (!settingsTemplateContent.getModifiedBy().contains("admin" + SecurityKeys.ID_SEPARATOR + segmentName)) continue;
                    Properties roleSettings = new Properties();
                    roleSettings.load(settingsTemplateContent.getContent().getContent());
                    defaultSettings.putAll((Map<?, ?>)roleSettings);
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
        }
        return defaultSettings;
    }

    public String getUserTimezone(Properties settings) throws ServiceException {
        return settings.getProperty(UserSettings.TIMEZONE_NAME.getName());
    }

    public void updateTimer(Timer timer) throws ServiceException {
        Date now = new Date();
        if (JDOHelper.isNew((Object)timer)) {
            if (timer.getTriggerRepeat() == null) {
                timer.setTriggerRepeat(1);
            }
            if (timer.getTriggerIntervalMinutes() == null) {
                timer.setTriggerIntervalMinutes(15);
            }
            if (timer.getTimerStartAt() == null) {
                ContextCapable target = null;
                try {
                    target = timer.getTarget();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (target instanceof Activity) {
                    timer.setTimerStartAt(((Activity)target).getScheduledStart());
                    timer.setTimerState(((Activity)target).getActivityState());
                } else {
                    timer.setTimerStartAt(now);
                    timer.setTimerState((short)TimerState.OPEN.getValue());
                }
            }
        } else {
            ContextCapable target = null;
            try {
                target = timer.getTarget();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target instanceof Activity) {
                Activities.getInstance().markActivityAsDirty((Activity)target);
            }
        }
        if (timer.getTimerStartAt() != null && (timer.getLastTriggerAt() == null || timer.getTimerStartAt().compareTo(now) > 0)) {
            timer.setLastTriggerAt(new Date(timer.getTimerStartAt().getTime() - (long)timer.getTriggerIntervalMinutes().intValue() * 60000L));
        }
    }

    protected Object getMessageValue(Object message, String feature) {
        Object value = null;
        if (message instanceof RefObject) {
            try {
                value = ((RefObject)message).refGetValue(feature);
            }
            catch (Exception e) {
                SysLog.warning((String)"Can not get filter value", (Object)e.getMessage());
            }
        } else {
            int start;
            int end;
            String messageAsString = message.toString();
            String indexedFilterName = feature + ":\n0: ";
            int pos = -1;
            pos = messageAsString.indexOf(indexedFilterName);
            if (pos >= 0 && (end = messageAsString.indexOf("\n", start = pos + indexedFilterName.length())) > start) {
                value = messageAsString.substring(start, end);
            }
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            value = values.isEmpty() ? null : value;
        }
        return value;
    }

    protected boolean subscriptionEventTypeMatches(Subscription subscription, ContextCapable message) {
        if (subscription.getEventType().isEmpty()) {
            return true;
        }
        Workflows.EventType eventType = Workflows.getEventType(message);
        for (Short e : subscription.getEventType()) {
            if (e.shortValue() != eventType.getValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean subscriptionFilterMatches(Subscription subscription, Object message, String filterName, Set<String> filterValues) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)subscription);
        if (message instanceof AuditEntry) {
            PersistenceManager pmUser = null;
            try {
                AuditEntry auditEntry = (AuditEntry)message;
                if (auditEntry.getAuditee() != null) {
                    Path userHomeIdentity = subscription.refGetPath().getParent().getParent();
                    String principalName = userHomeIdentity.getLastSegment().toString();
                    pmUser = pm.getPersistenceManagerFactory().getPersistenceManager(principalName, null);
                    Object auditee = null;
                    if (auditEntry instanceof ObjectModificationAuditEntry) {
                        try {
                            auditee = pmUser.getObjectById((Object)new Path(auditEntry.getAuditee()));
                        }
                        catch (Exception e) {
                            SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
                        }
                    } else if (auditEntry instanceof ObjectRemovalAuditEntry) {
                        auditee = ((ObjectRemovalAuditEntry)auditEntry).getBeforeImage();
                    } else if (auditEntry instanceof ObjectCreationAuditEntry) {
                        try {
                            auditee = pmUser.getObjectById((Object)new Path(auditEntry.getAuditee()));
                        }
                        catch (Exception e) {
                            SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
                        }
                    }
                    if (auditee != null) {
                        boolean e = this.subscriptionFilterMatches(subscription, auditee, filterName, filterValues);
                        return e;
                    }
                    boolean e = false;
                    return e;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (pmUser != null) {
                    try {
                        pmUser.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        Object value = this.getMessageValue(message, filterName);
        boolean matches = false;
        for (String filterValue : filterValues) {
            boolean negate = false;
            if (filterValue != null && filterValue.startsWith("!")) {
                filterValue = filterValue.substring(1);
                negate = true;
            }
            try {
                boolean isEqual = Utils.areEqual(value instanceof RefObject ? ((RefObject)value).refMofId() : value.toString(), filterValue);
                matches |= negate ? !isEqual : isEqual;
            }
            catch (Exception e) {
                SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
                SysLog.warning((String)"Can not get filter value", Arrays.asList(filterName, e.getMessage()));
            }
        }
        return matches;
    }

    public boolean subscriptionTopicMatches(Subscription subscription, ContextCapable message) {
        String topicPatternXri = subscription.getTopic().getTopicPathPattern();
        String providerName = subscription.refGetPath().getSegment(2).toString();
        String segmentName = subscription.refGetPath().getSegment(4).toString();
        if (topicPatternXri != null) {
            Path topicPattern = new Path(topicPatternXri);
            Path objectPath = message instanceof AuditEntry ? new Path(((AuditEntry)message).getAuditee()) : (message instanceof RefObject_1_0 ? message.refGetPath() : null);
            Path userHomeIdentity = subscription.refGetPath().getParent().getParent();
            if (objectPath.size() >= PATH_PATTERN_USER_HOME.size() && objectPath.getPrefix(PATH_PATTERN_USER_HOME.size()).isLike(PATH_PATTERN_USER_HOME) && !objectPath.startsWith(userHomeIdentity)) {
                return false;
            }
            if (topicPattern.size() < 7) {
                return false;
            }
            return objectPath != null && objectPath.isLike(topicPattern) && providerName.equals(objectPath.getSegment(2).toString()) && segmentName.equals(objectPath.getSegment(4).toString());
        }
        return false;
    }

    public boolean subscriptionMatches(Subscription subscription, ContextCapable message) throws ServiceException {
        if (!this.subscriptionTopicMatches(subscription, message)) {
            return false;
        }
        if (!this.subscriptionEventTypeMatches(subscription, message)) {
            return false;
        }
        if (subscription.getFilterName0() != null && subscription.getFilterName0().length() > 0 && !this.subscriptionFilterMatches(subscription, message, subscription.getFilterName0(), subscription.getFilterValue0())) {
            return false;
        }
        if (subscription.getFilterName1() != null && subscription.getFilterName1().length() > 0 && !this.subscriptionFilterMatches(subscription, message, subscription.getFilterName1(), subscription.getFilterValue1())) {
            return false;
        }
        if (subscription.getFilterName2() != null && subscription.getFilterName2().length() > 0 && !this.subscriptionFilterMatches(subscription, message, subscription.getFilterName2(), subscription.getFilterValue2())) {
            return false;
        }
        if (subscription.getFilterName3() != null && subscription.getFilterName3().length() > 0 && !this.subscriptionFilterMatches(subscription, message, subscription.getFilterName3(), subscription.getFilterValue3())) {
            return false;
        }
        return subscription.getFilterName4() == null || subscription.getFilterName4().length() <= 0 || this.subscriptionFilterMatches(subscription, message, subscription.getFilterName4(), subscription.getFilterValue4());
    }

    public void createSnapshot(WorkList workList) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)workList);
        WorkListSnapshot snapshot = (WorkListSnapshot)pm.newInstance(WorkListSnapshot.class);
        snapshot.setName(workList.getName() + " / " + new Date());
        workList.addSnapshot(Utils.getUidAsString(), snapshot);
        snapshot.setPredecessor(workList.getCurrentSnapshot());
        workList.setCurrentSnapshot(snapshot);
        WorkListFeedQuery workListFeedQuery = (WorkListFeedQuery)pm.newQuery(WorkListFeed.class);
        workListFeedQuery.thereExistsActive().isTrue();
        for (WorkListFeed feed : workList.getFeed(workListFeedQuery)) {
            if (feed.getSource() == null || feed.getSourceReferenceName() == null) continue;
            ContextCapable source = feed.getSource();
            Collection items = (Collection)source.refGetValue(feed.getSourceReferenceName());
            for (ContextCapable item : items) {
                String remarks;
                String itemId = item.refGetPath().getLastSegment().toString();
                WorkListItem workListItem = workList.getItem(itemId);
                if (workListItem == null) {
                    workListItem = (WorkListItem)pm.newInstance(WorkListItem.class);
                    workList.addItem(itemId, workListItem);
                    try {
                        workListItem.setName(Base.getInstance().getTitle((RefObject_1_0)item, null, (short)0, true));
                    }
                    catch (Exception ignore) {
                        try {
                            workListItem.setName((String)item.refGetValue("name"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        workListItem.setDescription((String)item.refGetValue("description"));
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    workListItem.setOrigin((org.openmdx.base.cci2.ContextCapable)item);
                    workListItem.setOriginXri(item.refGetPath().toXRI());
                    workListItem.setOriginType(item.refClass().refMofId());
                }
                if (!workListItem.getSnapshot().contains(snapshot)) {
                    workListItem.getSnapshot().add(snapshot);
                }
                if ((remarks = workListItem.getRemarks()) != null && remarks.indexOf(feed.getName()) >= 0) continue;
                workListItem.setRemarks((String)(remarks == null ? "" : remarks + "\n") + feed.getName());
            }
        }
    }

    @Override
    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
        super.preDelete(object, preDelete);
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
        if (object instanceof WorkListSnapshot) {
            WorkListSnapshot snapshot = (WorkListSnapshot)object;
            ArrayList items = new ArrayList();
            items.addAll(snapshot.getCurrentItem());
            for (WorkListItem item : items) {
                item.getSnapshot().remove(snapshot);
            }
            WorkList workList = (WorkList)pm.getObjectById((Object)snapshot.refGetPath().getParent().getParent());
            WorkListSnapshotQuery snapshotQuery = (WorkListSnapshotQuery)pm.newQuery(WorkListSnapshot.class);
            snapshotQuery.thereExistsPredecessor().equalTo(snapshot);
            for (WorkListSnapshot predecessor : workList.getSnapshot(snapshotQuery)) {
                predecessor.setPredecessor(snapshot.getPredecessor());
            }
            if (workList.getCurrentSnapshot() != null && workList.getCurrentSnapshot().equals(snapshot)) {
                workList.setCurrentSnapshot(snapshot.getPredecessor());
            }
        }
    }

    @Override
    public void preStore(RefObject_1_0 object) throws ServiceException {
        super.preStore(object);
        if (object instanceof Timer) {
            this.updateTimer((Timer)object);
        } else if (object instanceof Alert) {
            try {
                Alert alert = (Alert)object;
                alert.setReferencedObjectType(alert.getReference() == null ? null : alert.getReference().refClass().refMofId());
            }
            catch (Exception alert) {}
        } else if (object instanceof AccessHistory) {
            try {
                AccessHistory accessHistory = (AccessHistory)object;
                accessHistory.setReferencedObjectType(accessHistory.getReference() == null ? null : accessHistory.getReference().refClass().refMofId());
            }
            catch (Exception accessHistory) {}
        } else if (object instanceof QuickAccess) {
            try {
                QuickAccess quickAccess = (QuickAccess)object;
                quickAccess.setReferencedObjectType(quickAccess.getReference() == null ? null : quickAccess.getReference().refClass().refMofId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum AlertState {
        NA(0),
        NEW(1),
        READ(2),
        ACCEPTED(3),
        EXPIRED(4);

        private short value;

        private AlertState(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    public static enum TimerState {
        NA(0),
        OPEN(10),
        CLOSED(20),
        CANCELLED(30);

        private final int value;

        private TimerState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class OpenCrxUserSettings {
        private final String timezone;
        private final String storeSettingsOnLogoff;
        private final String defaultEmailAccount;
        private final String sendmailSubjectPrefix;
        private final String webAccessUrl;
        private final String topNavigationShowMax;
        private final Boolean hideWorkspaceDashboard;
        private final Boolean anchorUserDialog;
        private final List<String> rootObjects;
        private final Map<String, String> subscriptions;

        public OpenCrxUserSettings(String timezone, String storeSettingsOnLogoff, String defaultEmailAccount, String sendmailSubjectPrefix, String webAccessUrl, String topNavigationShowMax, Boolean hideWorkspaceDashboard, Boolean anchorUserDialog, List<String> rootObjects, Map<String, String> subscriptions) {
            this.timezone = timezone;
            this.storeSettingsOnLogoff = storeSettingsOnLogoff;
            this.defaultEmailAccount = defaultEmailAccount;
            this.sendmailSubjectPrefix = sendmailSubjectPrefix;
            this.webAccessUrl = webAccessUrl;
            this.topNavigationShowMax = topNavigationShowMax;
            this.hideWorkspaceDashboard = hideWorkspaceDashboard;
            this.anchorUserDialog = anchorUserDialog;
            this.rootObjects = rootObjects;
            this.subscriptions = subscriptions;
        }

        public Boolean getAnchorUserDialog() {
            return this.anchorUserDialog;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public String getStoreSettingsOnLogoff() {
            return this.storeSettingsOnLogoff;
        }

        public String getDefaultEmailAccount() {
            return this.defaultEmailAccount;
        }

        public String getSendmailSubjectPrefix() {
            return this.sendmailSubjectPrefix;
        }

        public String getWebAccessUrl() {
            return this.webAccessUrl;
        }

        public String getTopNavigationShowMax() {
            return this.topNavigationShowMax;
        }

        public Boolean getHideWorkspaceDashboard() {
            return this.hideWorkspaceDashboard;
        }

        public List<String> getRootObjects() {
            return this.rootObjects;
        }

        public Map<String, String> getSubscriptions() {
            return this.subscriptions;
        }
    }
}

