/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import javax.resource.cci.MappedRecord;
import org.oasisopen.cci2.QualifierType;
import org.oasisopen.jmi1.RefContainer;
import org.opencrx.kernel.backend.AbstractImpl;
import org.openmdx.application.dataprovider.cci.JmiHelper;
import org.openmdx.application.xml.Importer;
import org.openmdx.application.xml.spi.ImportHelper;
import org.openmdx.application.xml.spi.ImportTarget;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.Authority;
import org.openmdx.base.jmi1.Segment;
import org.openmdx.base.naming.Path;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.xml.sax.InputSource;

public class XmlImporter
extends AbstractImpl {
    public static final String MIME_TYPE = "application/xml";
    public static final String FILE_EXTENSION = ".xml";

    public static void register() {
        XmlImporter.registerImpl(new XmlImporter());
    }

    public static XmlImporter getInstance() throws ServiceException {
        return XmlImporter.getInstance(XmlImporter.class);
    }

    protected XmlImporter() {
    }

    public RefObject importItem(byte[] item, short locale, Segment targetSegment, List<String> errors, List<String> report) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)targetSegment);
        LinkedHashMap data = new LinkedHashMap();
        String itemAsXml = null;
        try {
            itemAsXml = new String(item, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Importer.importObjects((ImportTarget)Importer.asTarget(data), (Iterable)ImportHelper.asSource((InputSource)new InputSource(new StringReader(itemAsXml))));
        HashMap<Path, RefObject_1_0> loadedObjects = new HashMap<Path, RefObject_1_0>();
        for (int runs = 0; runs < 5; ++runs) {
            for (MappedRecord entry : data.values()) {
                try {
                    RefObject_1_0 existing = null;
                    try {
                        existing = (RefObject_1_0)pm.getObjectById((Object)Object_2Facade.getPath((MappedRecord)entry));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (existing != null) {
                        loadedObjects.put(existing.refGetPath(), existing);
                        JmiHelper.toRefObject((MappedRecord)entry, (RefObject)existing, loadedObjects, null, (boolean)true);
                        continue;
                    }
                    String qualifiedClassName = Object_2Facade.getObjectClass((MappedRecord)entry);
                    String packageName = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf(58));
                    RefObject_1_0 newEntry = (RefObject_1_0)((Authority)pm.getObjectById(Authority.class, (Object)("xri://@openmdx*" + packageName.replace(":", ".")))).refImmediatePackage().refClass(qualifiedClassName).refCreateInstance(null);
                    newEntry.refInitialize(false, false, false);
                    JmiHelper.toRefObject((MappedRecord)entry, (RefObject)newEntry, loadedObjects, null, (boolean)true);
                    Path entryPath = Object_2Facade.getPath((MappedRecord)entry);
                    Path parentIdentity = entryPath.getParent().getParent();
                    RefObject_1_0 parent = null;
                    try {
                        parent = loadedObjects.containsKey(parentIdentity) ? (RefObject_1_0)loadedObjects.get(parentIdentity) : (RefObject_1_0)pm.getObjectById((Object)parentIdentity);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (parent != null) {
                        RefContainer container = (RefContainer)parent.refGetValue(entryPath.get(entryPath.size() - 2));
                        container.refAdd(new Object[]{QualifierType.REASSIGNABLE, entryPath.get(entryPath.size() - 1), newEntry});
                    }
                    loadedObjects.put(entryPath, newEntry);
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    System.out.println("STATUS: " + e.getMessage() + " (for more info see log)");
                }
            }
        }
        return loadedObjects.isEmpty() ? null : (RefObject)loadedObjects.values().iterator().next();
    }
}

