/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.base.aop2;

import java.util.ArrayList;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.ICalendar;
import org.opencrx.kernel.backend.VCard;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.backend.XmlImporter;
import org.opencrx.kernel.base.cci2.ImportItemResult;
import org.opencrx.kernel.base.jmi1.ImportItemParams;
import org.opencrx.kernel.base.jmi1.ImportItemResult;
import org.opencrx.kernel.base.jmi1.Importer;
import org.opencrx.kernel.workflow1.jmi1.RunImportResult;
import org.openmdx.base.accessor.jmi.cci.JmiServiceException;
import org.openmdx.base.aop2.AbstractObject;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.jmi1.Segment;
import org.openmdx.base.text.conversion.Base64;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class ImporterImpl<S extends Importer, N extends org.opencrx.kernel.base.cci2.Importer, C extends Void>
extends AbstractObject<S, N, C> {
    public ImporterImpl(S same, N next) {
        super(same, next);
    }

    public ImportItemResult importItem(ImportItemParams params) {
        try {
            byte[] item = params.getItem();
            String itemName = params.getItemName();
            String itemMimeType = params.getItemMimeType();
            ArrayList<String> report = new ArrayList<String>();
            ArrayList<String> errors = new ArrayList<String>();
            BasicObject importedObject = null;
            if ("text/x-vcard".equals(itemMimeType) || itemName.endsWith(".vcf")) {
                if (this.sameObject() instanceof Account) {
                    importedObject = VCard.getInstance().importItem(item, (Account)this.sameObject(), (short)0, errors, report);
                }
            } else if ("text/calendar".equals(itemMimeType) || itemName.endsWith(".ics")) {
                if (this.sameObject() instanceof Activity) {
                    importedObject = ICalendar.getInstance().importItem(item, (Activity)this.sameObject(), (short)0, errors, report);
                }
            } else if ("application/xml".equals(itemMimeType) || itemName.endsWith(".xml")) {
                if (this.sameObject() instanceof Segment) {
                    importedObject = (BasicObject)XmlImporter.getInstance().importItem(item, (short)0, (Segment)this.sameObject(), errors, report);
                }
            } else {
                ArrayList<String> runImportParams = new ArrayList<String>();
                runImportParams.add(((Importer)this.sameObject()).refGetPath().toXRI());
                runImportParams.add(Base64.encode((byte[])item));
                runImportParams.add(itemName);
                runImportParams.add(itemMimeType);
                RunImportResult result = Workflows.getInstance().runImport(params.getImporterTask(), runImportParams);
                return (ImportItemResult)Structures.create(ImportItemResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ImportItemResult.Member.importedObject, (Object)result.getImportedObject()), Datatypes.member((Enum)ImportItemResult.Member.status, (Object)result.getStatus()), Datatypes.member((Enum)ImportItemResult.Member.statusMessage, (Object)result.getStatusMessage()), Datatypes.member((Enum)ImportItemResult.Member.item, (Object)result.getFile()), Datatypes.member((Enum)ImportItemResult.Member.itemName, (Object)result.getFileName()), Datatypes.member((Enum)ImportItemResult.Member.itemMimeType, (Object)result.getFileMimeType())});
            }
            if (importedObject != null) {
                return (ImportItemResult)Structures.create(ImportItemResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ImportItemResult.Member.importedObject, (Object)importedObject), Datatypes.member((Enum)ImportItemResult.Member.status, (Object)0), Datatypes.member((Enum)ImportItemResult.Member.statusMessage, (Object)Base.getInstance().analyseReport(report))});
            }
            return (ImportItemResult)Structures.create(ImportItemResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ImportItemResult.Member.importedObject, null), Datatypes.member((Enum)ImportItemResult.Member.status, (Object)2), Datatypes.member((Enum)ImportItemResult.Member.statusMessage, (Object)Base.getInstance().analyseReport(errors))});
        }
        catch (ServiceException e) {
            throw new JmiServiceException((Throwable)e);
        }
    }
}

