/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.layer.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.MappedRecord;
import org.opencrx.kernel.utils.FileUtils;
import org.openmdx.application.dataprovider.cci.AttributeSelectors;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.Database_2;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.spi.PersistenceManagers;
import org.openmdx.base.resource.InteractionSpecs;
import org.openmdx.base.resource.Records;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.base.resource.spi.RestInteractionSpec;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryRecord;
import org.openmdx.base.rest.cci.RestConnection;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

public class Media_2
extends Database_2 {
    protected final InteractionSpecs SUPER = InteractionSpecs.getRestInteractionSpecs((boolean)false);

    public Interaction getInteraction(RestConnection connection) throws ResourceException {
        return new RestInteraction(this, connection);
    }

    public static File getMediaDir(Path path) {
        String dir = System.getProperty("org.opencrx.mediadir." + path.getSegment(2).toString());
        if (dir != null) {
            File mediadir = new File(dir);
            if (!mediadir.exists()) {
                SysLog.warning((String)"mediadir does not exist. Ignoring", (Object)mediadir);
            } else {
                return mediadir;
            }
        }
        return null;
    }

    public static File toContentDir(File mediadir, Path path) {
        return new File(mediadir, path.isContainerPath() ? path.toClassicRepresentation().replace("::", "_") : path.getParent().toClassicRepresentation().replace("::", "_"));
    }

    protected List<String> getPrincipalChain(Connection connection) throws ResourceException {
        return PersistenceManagers.toPrincipalChain((String)connection.getMetaData().getUserName());
    }

    public class RestInteraction
    extends org.openmdx.base.dataprovider.layer.persistence.jdbc.RestInteraction {
        public RestInteraction(Media_2 media, RestConnection connection) throws ResourceException {
            super((Database_2)media, connection);
        }

        protected ResultRecord newResult() throws ResourceException {
            return (ResultRecord)Records.getRecordFactory().createIndexedRecord(ResultRecord.class);
        }

        protected MappedRecord newOperationResult(String recordType) throws ResourceException {
            return Records.getRecordFactory().createMappedRecord(recordType);
        }

        public ObjectRecord retrieveObject(Path resourceIdentifier, String fetchGroupName) throws ResourceException {
            ResultRecord result = this.newResult();
            QueryRecord query = this.newQuery(resourceIdentifier);
            query.setFetchGroupName(fetchGroupName);
            super.get(Media_2.this.SUPER.GET, query, result);
            return result.isEmpty() ? null : (ObjectRecord)result.get(0);
        }

        protected void storeContent(File contentFile, BinaryLargeObject binaryContent) throws ServiceException {
            try {
                FileOutputStream target = new FileOutputStream(contentFile);
                BinaryLargeObjects.streamCopy((InputStream)binaryContent.getContent(), (long)0L, (OutputStream)target);
                target.close();
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }

        protected void setContent(Object_2Facade object) throws ServiceException {
            try {
                File mediadir = Media_2.getMediaDir(object.getPath());
                BinaryLargeObject content = (BinaryLargeObject)object.attributeValue("content");
                if (mediadir != null) {
                    File contentDir = Media_2.toContentDir(mediadir, object.getPath());
                    File contentFile = new File(contentDir, object.getPath().getLastSegment().toString());
                    if (!contentFile.exists() && content instanceof BinaryLargeObject) {
                        contentDir.mkdirs();
                        this.storeContent(contentFile, content);
                    }
                    if (contentFile.exists()) {
                        object.clearAttributeValuesAsList("content");
                        content = BinaryLargeObjects.valueOf((File)contentFile);
                        object.addToAttributeValuesAsList("content", (Object)content);
                        object.clearAttributeValuesAsList("contentLength");
                        object.addToAttributeValuesAsList("contentLength", (Object)content.getContent().available());
                    }
                } else {
                    InputStream stream = null;
                    if (content != null) {
                        stream = content.getContent();
                    }
                    object.clearAttributeValuesAsList("contentLength");
                    object.addToAttributeValuesAsList("contentLength", (Object)(stream == null ? 0L : (long)stream.available()));
                }
            }
            catch (IOException e) {
                throw new ServiceException((Exception)e);
            }
        }

        protected boolean currentUserIsRoot(Connection connection) throws ResourceException {
            List<String> principalChain = Media_2.this.getPrincipalChain(connection);
            return principalChain.isEmpty() ? false : "admin-Root".equals(principalChain.get(0));
        }

        public boolean get(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            try {
                Model_1_0 model = Model_1Factory.getModel();
                super.get(ispec, request, response);
                for (Object object : response) {
                    Object_2Facade record;
                    if (!(object instanceof ObjectRecord) || !model.isSubtypeOf((Object)(record = Facades.asObject((MappedRecord)((ObjectRecord)object))).getObjectClass(), (Object)"org:opencrx:kernel:document1:Media")) continue;
                    this.setContent(record);
                }
                return true;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public boolean find(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            try {
                Model_1_0 model = Model_1Factory.getModel();
                super.find(ispec, request, response);
                for (Object object : response) {
                    Object_2Facade record;
                    short attributeSelector = AttributeSelectors.getAttributeSelector((QueryRecord)request);
                    if (!(object instanceof MappedRecord) || !model.isSubtypeOf((Object)(record = Facades.asObject((MappedRecord)((MappedRecord)object))).getObjectClass(), (Object)"org:opencrx:kernel:document1:Media") || attributeSelector != 3) continue;
                    this.setContent(record);
                }
                return true;
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public boolean delete(RestInteractionSpec ispec, ObjectRecord request) throws ResourceException {
            Path path = request.getResourceIdentifier();
            super.delete(ispec, request);
            File mediadir = Media_2.getMediaDir(path);
            if (mediadir != null) {
                File contentDir = Media_2.toContentDir(mediadir, path);
                File contentFile = new File(contentDir, path.getLastSegment().toString());
                if (contentFile.exists()) {
                    try {
                        if (contentFile.isDirectory()) {
                            FileUtils.deleteDirectory(contentFile);
                        } else {
                            contentFile.delete();
                        }
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
                while (!contentDir.equals(mediadir) && contentDir.isDirectory() && contentDir.listFiles().length == 0) {
                    try {
                        contentDir.delete();
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                    contentDir = contentDir.getParentFile();
                }
            }
            return true;
        }

        public boolean create(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            try {
                Path path = request.getResourceIdentifier();
                Model_1_0 model = Model_1Factory.getModel();
                File mediadir = Media_2.getMediaDir(path);
                Object_2Facade input = Facades.asObject((MappedRecord)request);
                if (model.isSubtypeOf((Object)input.getObjectClass(), (Object)"org:opencrx:kernel:document1:Media") && mediadir != null) {
                    BinaryLargeObject content = (BinaryLargeObject)input.attributeValue("content");
                    File contentDir = Media_2.toContentDir(mediadir, path);
                    contentDir.mkdirs();
                    File contentFile = new File(contentDir, input.getPath().getLastSegment().toString());
                    if (content instanceof BinaryLargeObject) {
                        this.storeContent(contentFile, content);
                        input.attributeValuesAsList("content").clear();
                        if (this.currentUserIsRoot(this.getConnection())) {
                            input.addToAttributeValuesAsList("content", (Object)BinaryLargeObjects.valueOf((File)contentFile));
                        }
                    }
                }
                return super.create(ispec, request, response);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public boolean update(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            try {
                Path path = request.getResourceIdentifier();
                Model_1_0 model = Model_1Factory.getModel();
                File mediadir = Media_2.getMediaDir(path);
                Object_2Facade input = Facades.asObject((MappedRecord)request);
                if (model.isSubtypeOf((Object)input.getObjectClass(), (Object)"org:opencrx:kernel:document1:Media") && mediadir != null) {
                    BinaryLargeObject content = (BinaryLargeObject)input.attributeValue("content");
                    File contentDir = Media_2.toContentDir(mediadir, input.getPath());
                    File contentFile = new File(contentDir, input.getPath().getLastSegment().toString());
                    if (content instanceof BinaryLargeObject) {
                        input.attributeValuesAsList("content").clear();
                        if (this.currentUserIsRoot(this.getConnection())) {
                            input.addToAttributeValuesAsList("content", (Object)BinaryLargeObjects.valueOf((File)contentFile));
                        } else if (contentFile.exists()) {
                            this.storeContent(contentFile, content);
                        }
                    }
                }
                return super.update(ispec, request, response);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }
    }
}

