/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal.action;

import java.io.IOException;
import java.util.Map;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.ViewsCache;
import org.openmdx.portal.servlet.action.ActionPerformResult;
import org.openmdx.portal.servlet.action.BoundAction;
import org.openmdx.portal.servlet.component.ObjectView;
import org.openmdx.portal.servlet.component.ShowObjectView;

public class CreateSubfolderAction
extends BoundAction {
    public static final int EVENT_ID = 109;

    public ActionPerformResult perform(ObjectView view, HttpServletRequest request, HttpServletResponse response, String parameter, HttpSession session, Map<String, String[]> requestParameters, ViewsCache editViewsCache, ViewsCache showViewsCache) throws IOException, ServletException {
        ApplicationContext app = view.getApplicationContext();
        if (view instanceof ShowObjectView) {
            ShowObjectView currentView = (ShowObjectView)view;
            PersistenceManager pm = app.getNewPmData();
            try {
                if (currentView.getObject() instanceof DocumentFolder) {
                    DocumentFolder parentFolder = (DocumentFolder)currentView.getObject();
                    Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, parentFolder.refGetPath().get(2), parentFolder.refGetPath().get(4));
                    pm.currentTransaction().begin();
                    DocumentFolder folder = (DocumentFolder)pm.newInstance(DocumentFolder.class);
                    folder.setName("New folder");
                    folder.setParent((DocumentFolder)pm.getObjectById((Object)parentFolder.refGetPath()));
                    for (PrincipalGroup owningGroup : parentFolder.getOwningGroup()) {
                        folder.getOwningGroup().add((PrincipalGroup)pm.getObjectById((Object)owningGroup.refGetPath()));
                    }
                    documentSegment.addFolder(Utils.getUidAsString(), folder);
                    pm.currentTransaction().commit();
                }
            }
            catch (Exception e) {
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pm.close();
        }
        return new ActionPerformResult(view);
    }
}

