/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.tools;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FastResultSet {
    private final ResultSet rs;
    private int currentColumnIndex = -1;
    private final Map<String, Object> columnValues = new HashMap<String, Object>();
    private final List<String> columnNames;

    public FastResultSet(ResultSet rs) throws SQLException {
        this.rs = rs;
        this.columnNames = FastResultSet.getColumnNames(rs.getMetaData());
    }

    public FastResultSet(ResultSet rs, List<String> columnNames) throws SQLException {
        this.rs = rs;
        this.columnNames = columnNames;
    }

    public static List<String> getColumnNames(ResultSetMetaData rsmd) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            columnNames.add(rsmd.getColumnName(i + 1).toLowerCase());
        }
        return columnNames;
    }

    public Object getObject(String columnName) throws SQLException {
        String columnNameLowerCase = columnName.toLowerCase();
        Object value = this.columnValues.get(columnNameLowerCase);
        if (value == null) {
            int index = this.columnNames.indexOf(columnNameLowerCase);
            if (index < 0) {
                throw new SQLException("column " + columnName + " not found");
            }
            while (this.currentColumnIndex < index) {
                ++this.currentColumnIndex;
                value = this.rs.getObject(this.currentColumnIndex + 1);
                this.columnValues.put(this.columnNames.get(this.currentColumnIndex), value);
            }
        }
        return value;
    }

    public void reset() throws SQLException {
        this.columnValues.clear();
        this.currentColumnIndex = -1;
    }

    public boolean next() throws SQLException {
        boolean hasMore = this.rs.next();
        this.reset();
        return hasMore;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
    }
}

