/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class ManageDbConfig {
    public static void main(String[] args) throws IOException {
        Map<String, String> dbObjectType;
        int index;
        String value;
        String key;
        FileInputStream propertiesFile = new FileInputStream("./src/jar/opencrx-resources.jar/META-INF/Kernel.properties");
        LinkedProperties config = new LinkedProperties();
        config.load(propertiesFile);
        TreeMap dbObjectTypes = new TreeMap();
        for (Object objKey : config.orderedKeys()) {
            key = (String)objKey;
            value = config.getProperty(key);
            if (!key.startsWith("PERSISTENCE/typeName[")) continue;
            index = Integer.parseInt(key.substring(key.indexOf("[") + 1, key.indexOf("]")));
            dbObjectType = (LinkedHashMap<String, String>)dbObjectTypes.get(value);
            if (dbObjectType != null) {
                System.out.println("ERROR: duplicate typeName " + key);
                break;
            }
            dbObjectType = new LinkedHashMap<String, String>();
            dbObjectTypes.put(value, dbObjectType);
            dbObjectType.put("index", Integer.toString(index));
        }
        for (Object objKey : config.orderedKeys()) {
            key = (String)objKey;
            value = config.getProperty(key);
            if (!key.startsWith("PERSISTENCE/type[") && !key.startsWith("PERSISTENCE/typeName[") && !key.startsWith("PERSISTENCE/dbObject[") && !key.startsWith("PERSISTENCE/dbObject2[") && !key.startsWith("PERSISTENCE/pathNormalizeLevel[") && !key.startsWith("PERSISTENCE/dbObjectFormat[") && !key.startsWith("PERSISTENCE/dbObjectForQuery[") && !key.startsWith("PERSISTENCE/dbObjectForQuery2[") && !key.startsWith("PERSISTENCE/dbObjectsForQueryJoinColumn[") && !key.startsWith("PERSISTENCE/joinTable[") && !key.startsWith("PERSISTENCE/joinColumnEnd1[") && !key.startsWith("PERSISTENCE/joinColumnEnd2[")) continue;
            index = Integer.parseInt(key.substring(key.indexOf("[") + 1, key.indexOf("]")));
            dbObjectType = null;
            for (Map candidate : dbObjectTypes.values()) {
                if (Integer.parseInt((String)candidate.get("index")) != index) continue;
                dbObjectType = candidate;
                break;
            }
            if (dbObjectType == null) {
                System.out.println("ERROR: no matching type for given key " + key);
                break;
            }
            dbObjectType.put(key, value);
        }
        int count = 0;
        for (Map dbObjectType2 : dbObjectTypes.values()) {
            System.out.println("#");
            for (Map.Entry property : dbObjectType2.entrySet()) {
                String key2 = (String)property.getKey();
                if (key2.equals("index")) continue;
                key2 = key2.substring(0, key2.indexOf("["));
                System.out.println(key2 + "[" + count + "]=" + (String)property.getValue());
            }
            ++count;
        }
    }

    public static class LinkedProperties
    extends Properties {
        private final HashSet<Object> keys = new LinkedHashSet<Object>();

        public Iterable<Object> orderedKeys() {
            return Collections.list(this.keys());
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

