/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.cci2.PropertySetContainsProperty;
import org.opencrx.kernel.base.cci2.StringProperty;
import org.opencrx.kernel.base.jmi1.BooleanProperty;
import org.opencrx.kernel.base.jmi1.DateProperty;
import org.opencrx.kernel.base.jmi1.DateTimeProperty;
import org.opencrx.kernel.base.jmi1.DecimalProperty;
import org.opencrx.kernel.base.jmi1.IntegerProperty;
import org.opencrx.kernel.base.jmi1.Property;
import org.opencrx.kernel.base.jmi1.PropertySet;
import org.opencrx.kernel.base.jmi1.ReferenceProperty;
import org.opencrx.kernel.base.jmi1.UriProperty;
import org.opencrx.kernel.home1.cci2.WfProcessInstanceContainsParameter;
import org.opencrx.kernel.home1.jmi1.WfActionLogEntry;
import org.opencrx.kernel.home1.jmi1.WfBooleanParameter;
import org.opencrx.kernel.home1.jmi1.WfDateParameter;
import org.opencrx.kernel.home1.jmi1.WfDateTimeParameter;
import org.opencrx.kernel.home1.jmi1.WfDecimalParameter;
import org.opencrx.kernel.home1.jmi1.WfIntegerParameter;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.home1.jmi1.WfProcessInstanceParameter;
import org.opencrx.kernel.home1.jmi1.WfReferenceParameter;
import org.opencrx.kernel.home1.jmi1.WfStringParameter;
import org.opencrx.kernel.home1.jmi1.WfUriParameter;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.cci2.BasicObject;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;

public abstract class WorkflowHelper {
    public static void createLogEntry(WfProcessInstance wfProcessInstance, String name, String description) throws ServiceException {
        WorkflowHelper.createLogEntry(wfProcessInstance, name, description, null);
    }

    public static void createLogEntry(WfProcessInstance wfProcessInstance, String name, String description, org.openmdx.base.jmi1.BasicObject correlation) throws ServiceException {
        if (wfProcessInstance == null) {
            return;
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
        WfActionLogEntry logEntry = (WfActionLogEntry)pm.newInstance(WfActionLogEntry.class);
        try {
            boolean isTxLocal;
            boolean bl = isTxLocal = !pm.currentTransaction().isActive();
            if (isTxLocal) {
                pm.currentTransaction().begin();
            }
            wfProcessInstance.addActionLog(Workflows.getInstance().getUidAsString(), logEntry);
            logEntry.setName(name == null ? "N/A" : name);
            logEntry.setDescription(description);
            logEntry.setCorrelation((BasicObject)correlation);
            if (isTxLocal) {
                pm.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Map<String, Object> getWorkflowParameters(WfProcessInstance wfProcessInstance) {
        HashMap<String, Object> params;
        block66: {
            Iterator iterator;
            ContextCapable triggeredBy;
            block67: {
                Object val;
                params = new HashMap<String, Object>();
                PropertySetContainsProperty.Property properties = wfProcessInstance.getProcess().getProperty();
                Iterator iterator2 = properties.iterator();
                while (iterator2.hasNext()) {
                    Property property = (Property)iterator2.next();
                    val = null;
                    if (property instanceof BooleanProperty) {
                        val = ((BooleanProperty)property).isBooleanValue();
                    } else if (property instanceof IntegerProperty) {
                        val = ((IntegerProperty)property).getIntegerValue();
                    } else if (property instanceof DecimalProperty) {
                        val = ((DecimalProperty)property).getDecimalValue();
                    } else if (property instanceof UriProperty) {
                        val = ((UriProperty)property).getUriValue();
                    } else if (property instanceof StringProperty) {
                        val = ((StringProperty)((Object)property)).getStringValue();
                    } else if (property instanceof ReferenceProperty) {
                        val = ((ReferenceProperty)property).getReferenceValue();
                    } else if (property instanceof DateTimeProperty) {
                        val = ((DateTimeProperty)property).getDateTimeValue();
                    } else if (property instanceof DateProperty) {
                        val = ((DateProperty)property).getDateValue();
                    }
                    params.put(property.getName(), val);
                }
                WfProcessInstanceContainsParameter.Parameter parameters = wfProcessInstance.getParameter();
                iterator2 = parameters.iterator();
                while (iterator2.hasNext()) {
                    WfProcessInstanceParameter parameter = (WfProcessInstanceParameter)iterator2.next();
                    val = null;
                    if (parameter instanceof WfBooleanParameter) {
                        val = ((WfBooleanParameter)parameter).isBooleanValue();
                    } else if (parameter instanceof WfIntegerParameter) {
                        val = ((WfIntegerParameter)parameter).getIntegerValue();
                    } else if (parameter instanceof WfDecimalParameter) {
                        val = ((WfDecimalParameter)parameter).getDecimalValue();
                    } else if (parameter instanceof WfUriParameter) {
                        val = ((WfUriParameter)parameter).getUriValue();
                    } else if (parameter instanceof WfStringParameter) {
                        val = ((WfStringParameter)parameter).getStringValue();
                    } else if (parameter instanceof WfReferenceParameter) {
                        val = ((WfReferenceParameter)parameter).getReferenceValue();
                    } else if (parameter instanceof WfDateTimeParameter) {
                        val = ((WfDateTimeParameter)parameter).getDateTimeValue();
                    } else if (parameter instanceof WfDateParameter) {
                        val = ((WfDateParameter)parameter).getDateValue();
                    }
                    params.put(parameter.getName(), val);
                }
                if (params.get("triggeredBy") == null) break block66;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
                triggeredBy = null;
                try {
                    triggeredBy = (ContextCapable)pm.getObjectById((Object)new Path((String)params.get("triggeredBy")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(triggeredBy instanceof WfProcessInstance)) break block67;
                iterator = ((WfProcessInstance)triggeredBy).getParameter().iterator();
                while (iterator.hasNext()) {
                    WfProcessInstanceParameter parameter = (WfProcessInstanceParameter)iterator.next();
                    Object val2 = null;
                    if (parameter instanceof WfBooleanParameter) {
                        val2 = ((WfBooleanParameter)parameter).isBooleanValue();
                    } else if (parameter instanceof WfIntegerParameter) {
                        val2 = ((WfIntegerParameter)parameter).getIntegerValue();
                    } else if (parameter instanceof WfDecimalParameter) {
                        val2 = ((WfDecimalParameter)parameter).getDecimalValue();
                    } else if (parameter instanceof WfUriParameter) {
                        val2 = ((WfUriParameter)parameter).getUriValue();
                    } else if (parameter instanceof WfStringParameter) {
                        val2 = ((WfStringParameter)parameter).getStringValue();
                    } else if (parameter instanceof WfReferenceParameter) {
                        val2 = ((WfReferenceParameter)parameter).getReferenceValue();
                    } else if (parameter instanceof WfDateTimeParameter) {
                        val2 = ((WfDateTimeParameter)parameter).getDateTimeValue();
                    } else if (parameter instanceof WfDateParameter) {
                        val2 = ((WfDateParameter)parameter).getDateValue();
                    }
                    params.put(parameter.getName(), val2);
                }
                break block66;
            }
            if (!(triggeredBy instanceof PropertySet)) break block66;
            iterator = ((PropertySet)triggeredBy).getProperty().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                Object val = null;
                if (property instanceof BooleanProperty) {
                    val = ((BooleanProperty)property).isBooleanValue();
                } else if (property instanceof IntegerProperty) {
                    val = ((IntegerProperty)property).getIntegerValue();
                } else if (property instanceof DecimalProperty) {
                    val = ((DecimalProperty)property).getDecimalValue();
                } else if (property instanceof UriProperty) {
                    val = ((UriProperty)property).getUriValue();
                } else if (property instanceof StringProperty) {
                    val = ((StringProperty)((Object)property)).getStringValue();
                } else if (property instanceof ReferenceProperty) {
                    val = ((ReferenceProperty)property).getReferenceValue();
                } else if (property instanceof DateTimeProperty) {
                    val = ((DateTimeProperty)property).getDateTimeValue();
                } else if (property instanceof DateProperty) {
                    val = ((DateProperty)property).getDateValue();
                }
                params.put(property.getName(), val);
            }
        }
        return params;
    }

    public static void addParameter(WfProcessInstance wfProcessInstance, String name, org.openmdx.base.jmi1.BasicObject value) throws ServiceException {
        if (value != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
            WfReferenceParameter parameter = (WfReferenceParameter)pm.newInstance(WfReferenceParameter.class);
            parameter.setName(name);
            parameter.setReferenceValue((BasicObject)value);
            wfProcessInstance.addParameter(Utils.getUidAsString(), parameter);
        }
    }

    public static void addParameter(WfProcessInstance wfProcessInstance, String name, Boolean value) throws ServiceException {
        if (value != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
            WfBooleanParameter parameter = (WfBooleanParameter)pm.newInstance(WfBooleanParameter.class);
            parameter.setName(name);
            parameter.setBooleanValue(value);
            wfProcessInstance.addParameter(Utils.getUidAsString(), parameter);
        }
    }

    public static void addParameter(WfProcessInstance wfProcessInstance, String name, String value) throws ServiceException {
        if (value != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
            WfStringParameter parameter = (WfStringParameter)pm.newInstance(WfStringParameter.class);
            parameter.setName(name);
            parameter.setStringValue(value);
            wfProcessInstance.addParameter(Utils.getUidAsString(), parameter);
        }
    }

    public static void addParameter(WfProcessInstance wfProcessInstance, String name, Date value) throws ServiceException {
        if (value != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
            WfDateTimeParameter parameter = (WfDateTimeParameter)pm.newInstance(WfDateTimeParameter.class);
            parameter.setName(name);
            parameter.setDateTimeValue(value);
            wfProcessInstance.addParameter(Utils.getUidAsString(), parameter);
        }
    }

    public static void addParameter(WfProcessInstance wfProcessInstance, String name, Number value) throws ServiceException {
        if (value != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
            WfIntegerParameter parameter = (WfIntegerParameter)pm.newInstance(WfIntegerParameter.class);
            parameter.setName(name);
            parameter.setIntegerValue(value.intValue());
            wfProcessInstance.addParameter(Utils.getUidAsString(), parameter);
        }
    }
}

