/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtils {
    protected static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static Document convertToDoc(String xml) throws ServiceException {
        try {
            Transformer transformer = transformerFactory.newTransformer();
            StreamSource xmlSource = new StreamSource(new StringReader(xml));
            DOMResult outputTarget = new DOMResult();
            transformer.transform(xmlSource, outputTarget);
            return (Document)outputTarget.getNode();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static Document convertToDoc(InputStream in) throws ServiceException {
        try {
            Transformer transformer = transformerFactory.newTransformer();
            StreamSource xmlSource = new StreamSource(in);
            DOMResult outputTarget = new DOMResult();
            transformer.transform(xmlSource, outputTarget);
            return (Document)outputTarget.getNode();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static String getElementText(Element node) {
        Text txtElem = (Text)node.getFirstChild();
        if (txtElem == null) {
            return null;
        }
        return txtElem.getData();
    }

    public static String getElementText(Element root, String elementName) {
        NodeList list = null;
        list = root.getElementsByTagName(elementName);
        if (list.getLength() == 0) {
            return null;
        }
        return XmlUtils.getElementText((Element)list.item(0));
    }

    public static String getElementTextNS(Element root, String namespaceURI, String elementName) {
        NodeList list = null;
        list = root.getElementsByTagNameNS(namespaceURI, elementName);
        if (list.getLength() == 0) {
            return null;
        }
        return XmlUtils.getElementText((Element)list.item(0));
    }
}

