/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.workflow;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.opencrx.kernel.account1.cci2.AccountAddressQuery;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.cci2.EMailAddressQuery;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.account1.jmi1.AddressFilterGlobal;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.Group;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.cci2.AddressGroupMemberQuery;
import org.opencrx.kernel.activity1.cci2.EMailQuery;
import org.opencrx.kernel.activity1.cci2.EMailRecipientQuery;
import org.opencrx.kernel.activity1.cci2.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.AddressGroup;
import org.opencrx.kernel.activity1.jmi1.AddressGroupMember;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.EMailRecipient;
import org.opencrx.kernel.activity1.jmi1.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.NewActivityResult;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.generic.cci2.LocalizedFieldQuery;
import org.opencrx.kernel.generic.jmi1.LocalizedField;
import org.opencrx.kernel.generic.jmi1.LocalizedFieldContainer;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.utils.ScriptUtils;
import org.opencrx.kernel.utils.WorkflowHelper;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.cci2.ContextCapable;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Codes;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class BulkCreateActivityWorkflow
extends Workflows.AsynchronousWorkflow {
    public static final int NUM_OF_TEST_ACTIVITIES = 3;
    public static final int MAX_THREADS = 5;
    private static final long REFRESH_PERIOD_MILLIS = 60000L;
    private static final long QUERY_EXECUTION_TIME_LIMIT = 5000L;
    public static final String OPTION_LOCALE = "locale";
    public static final String OPTION_DEFAULT_PLACEHOLDERS = "defaultPlaceHolders";
    public static final String OPTION_ACCOUNTS_SELECTOR = "accountsSelector";
    public static final String OPTION_CREATION_TYPE = "creationType";
    public static final String OPTION_ACTIVITY_NAME = "activityName";
    public static final String OPTION_ACTIVITY_DESCRIPTION = "activityDescription";
    public static final String OPTION_ACTIVITY_DETAILED_DESCRIPTION = "activityDetailedDescription";
    public static final String OPTION_ACTIVITY_PRIORITY = "activityPriority";
    public static final String OPTION_ACTIVITY_SCHEDULED_START = "activityScheduledStart";
    public static final String OPTION_ACTIVITY_SCHEDULED_END = "activityScheduledEnd";
    public static final String OPTION_ACTIVITY_DUE_BY = "activityDueBy";
    public static final String OPTION_EMAIL_SENDER = "emailSender";
    public static final String OPTION_EMAIL_MESSAGE_SUBJECT = "emailMessageSubject";
    public static final String OPTION_EMAIL_MESSAGE_BODY = "emailMessageBody";
    public static final String OPTION_EMAIL_ADDRESS_USAGE = "emailAddressUsage";
    public static final String OPTION_TEST_ACCOUNT = "testAccount";
    public static final String OPTION_TEST_EMAIL = "testEMail";
    public static final String OPTION_EXCLUDE_NO_BULK_EMAIL = "excludeNoBulkEMail";
    public static final String OPTION_IGNORE_EXECUTION_TIME_LIMIT = "ignoreExecutionTimeLimit";
    private Date scriptLastModifiedAt = null;
    private Long lastRefreshAt = null;
    private Class<?> script = null;

    protected List<?> getSelectedObjects(RefObject_1_0 selector) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)selector);
        if (selector instanceof AccountFilterGlobal) {
            AccountQuery accountQuery = (AccountQuery)pm.newQuery(Account.class);
            accountQuery.forAllDisabled().isFalse();
            QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)accountQuery);
            queryExtension.setClause("/*!COUNT*/(1=1)");
            List resultSet = ((AccountFilterGlobal)selector).getFilteredAccount(accountQuery);
            return resultSet;
        }
        if (selector instanceof Group) {
            MemberQuery memberQuery = (MemberQuery)pm.newQuery(Member.class);
            memberQuery.forAllDisabled().isFalse();
            QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)memberQuery);
            queryExtension.setClause("/*!COUNT*/(1=1)");
            List resultSet = ((Group)selector).getMember(memberQuery);
            return resultSet;
        }
        if (selector instanceof AddressFilterGlobal) {
            AccountAddressQuery accountAddressQuery = (AccountAddressQuery)pm.newQuery(AccountAddress.class);
            accountAddressQuery.forAllDisabled().isFalse();
            QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)accountAddressQuery);
            queryExtension.setClause("/*!COUNT*/(1=1)");
            List resultSet = ((AddressFilterGlobal)selector).getFilteredAddress(accountAddressQuery);
            return resultSet;
        }
        if (selector instanceof AddressGroup) {
            AddressGroupMemberQuery addressGroupMemberQuery = (AddressGroupMemberQuery)pm.newQuery(AddressGroupMember.class);
            addressGroupMemberQuery.forAllDisabled().isFalse();
            QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)addressGroupMemberQuery);
            queryExtension.setClause("/*!COUNT*/(1=1)");
            List resultSet = ((AddressGroup)selector).getMember(addressGroupMemberQuery);
            return resultSet;
        }
        return Collections.emptyList();
    }

    private Class<?> getScript(RefObject_1_0 context) throws ServiceException {
        if (this.lastRefreshAt == null || System.currentTimeMillis() > this.lastRefreshAt + 60000L) {
            try {
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)context);
                String providerName = context.refGetPath().get(2);
                String segmentName = context.refGetPath().get(4);
                Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
                Document scriptDocument = Documents.getInstance().findDocument(BulkCreateActivityWorkflow.class.getSimpleName() + ".script", documentSegment);
                if (scriptDocument == null || !(scriptDocument.getHeadRevision() instanceof MediaContent)) {
                    return null;
                }
                MediaContent script = (MediaContent)scriptDocument.getHeadRevision();
                if (this.scriptLastModifiedAt == null || script.getModifiedAt().compareTo(this.scriptLastModifiedAt) > 0) {
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    BinaryLargeObjects.streamCopy((InputStream)script.getContent().getContent(), (long)0L, (OutputStream)content);
                    this.script = ScriptUtils.getClass(content.toString("UTF-8"));
                    this.lastRefreshAt = System.currentTimeMillis();
                    this.scriptLastModifiedAt = script.getModifiedAt();
                }
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }
        return this.script;
    }

    public String getPlaceHolderValue(String name, String defaultValue, short locale, RefObject_1_0 context, Codes codes) throws ServiceException {
        block9: {
            if (context instanceof LocalizedFieldContainer) {
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)context);
                LocalizedFieldContainer container = (LocalizedFieldContainer)context;
                LocalizedFieldQuery query = (LocalizedFieldQuery)pm.newQuery(LocalizedField.class);
                query.name().equalTo((Object)name);
                query.locale().equalTo((Object)locale);
                query.orderByCreatedAt().descending();
                List localizedFields = container.getLocalizedField(query);
                if (!localizedFields.isEmpty()) {
                    return ((LocalizedField)localizedFields.iterator().next()).getLocalizedValue();
                }
            }
            try {
                Object value = context.refGetValue(name);
                if (value == null) break block9;
                if (codes != null && value instanceof Short && name.endsWith("Code")) {
                    Map longTexts = codes.getLongTextByCode(context.refClass().refMofId() + ":" + name, locale, true);
                    if (longTexts != null) {
                        return (String)longTexts.get(value);
                    }
                    break block9;
                }
                return value.toString();
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        try {
            Map longTexts;
            String nameWithCodeSuffix;
            Short code;
            if (codes != null && (code = (Short)context.refGetValue(nameWithCodeSuffix = name + "Code")) != null && (longTexts = codes.getLongTextByCode(context.refClass().refMofId() + ":" + nameWithCodeSuffix, locale, true)) != null) {
                return (String)longTexts.get(code);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public String replacePlaceHolders(RefObject_1_0 context, short locale, String text, Properties defaultPlaceHolders, Codes codes) throws ServiceException {
        if (text == null) {
            return null;
        }
        int pos = ((String)text).indexOf("${");
        while (pos >= 0) {
            int start;
            int end;
            for (end = start = pos + 2; ((String)text).charAt(end) != '}' && end < ((String)text).length(); ++end) {
            }
            if (end < ((String)text).length()) {
                String placeHolderName = ((String)text).substring(start, end);
                Class<?> script = this.getScript(context);
                Method getPlaceHolderValueMethod = null;
                if (script != null) {
                    try {
                        getPlaceHolderValueMethod = script.getMethod("get" + Character.toUpperCase(placeHolderName.charAt(0)) + placeHolderName.substring(1) + "Value", String.class, Short.TYPE, RefObject_1_0.class, Codes.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String placeHolderValue = null;
                if (getPlaceHolderValueMethod != null) {
                    try {
                        placeHolderValue = (String)getPlaceHolderValueMethod.invoke(null, defaultPlaceHolders.getProperty(placeHolderName), locale, context, codes);
                    }
                    catch (Exception e) {
                        throw new ServiceException(e);
                    }
                } else {
                    placeHolderValue = this.getPlaceHolderValue(placeHolderName, defaultPlaceHolders.getProperty(placeHolderName), locale, context, codes);
                }
                if (placeHolderValue == null) {
                    placeHolderValue = "";
                }
                text = ((String)text).substring(0, pos) + placeHolderValue + ((String)text).substring(end + 1);
                end = pos + placeHolderValue.length();
            }
            pos = ((String)text).indexOf("${", end);
        }
        return text;
    }

    public void updatePlaceHolders(Properties placeHolders, String text) {
        if (text == null) {
            return;
        }
        int pos = text.indexOf("${");
        while (pos >= 0) {
            String placeHolderName;
            int start;
            int end;
            for (end = start = pos + 2; text.charAt(end) != '}' && end < text.length(); ++end) {
            }
            if (end < text.length() && placeHolders.get(placeHolderName = text.substring(start, end)) == null) {
                placeHolders.put(placeHolderName, "N/A");
            }
            pos = text.indexOf("${", end);
        }
    }

    protected void createLogEntry(String name, WfProcessInstance wfProcessInstance, int numberOfActivities, int numberOfAccountsWithoutEmailAddress, int numberOfActivitiesCreated, int numberOfActivitiesUpdated, int numberOfActivitiesSkipped, int numberFailed) throws ServiceException {
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("Total", Integer.toString(numberOfActivities));
        report.put("Missing e-mail", Integer.toString(numberOfAccountsWithoutEmailAddress));
        report.put("Created", Integer.toString(numberOfActivitiesCreated));
        report.put("Updated", Integer.toString(numberOfActivitiesUpdated));
        report.put("Skipped", Integer.toString(numberOfActivitiesSkipped));
        report.put("Failed", Integer.toString(numberFailed));
        report.put("Pending", Integer.toString(numberOfActivities - numberOfAccountsWithoutEmailAddress - numberOfActivitiesCreated - numberOfActivitiesUpdated - numberOfActivitiesSkipped - numberFailed));
        WorkflowHelper.createLogEntry(wfProcessInstance, name, ((Object)report).toString());
    }

    protected void createLogEntry(String name, WfProcessInstance wfProcessInstance, long queryExecutionTime, long queryExecutionTimeLimit, int numberOfActivities) throws ServiceException {
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("Total", Integer.toString(numberOfActivities));
        report.put("Query execution time (ms)", Long.toString(queryExecutionTime));
        report.put("Query execution time limit (ms)", Long.toString(queryExecutionTimeLimit));
        WorkflowHelper.createLogEntry(wfProcessInstance, name, ((Object)report).toString());
    }

    @Override
    public void execute(WfProcessInstance wfProcessInstance) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
        try {
            PersistenceManagerFactory pmf = pm.getPersistenceManagerFactory();
            PersistenceManager pmUser = pmf.getPersistenceManager(wfProcessInstance.refGetPath().get(6), null);
            UserObjects.setBulkLoad((PersistenceManager)pmUser, (boolean)true);
            Map<String, Object> params = WorkflowHelper.getWorkflowParameters((WfProcessInstance)pmUser.getObjectById((Object)wfProcessInstance.refGetPath()));
            Properties defaultPlaceHolders = new Properties();
            if (params.get(OPTION_DEFAULT_PLACEHOLDERS) instanceof String) {
                try {
                    defaultPlaceHolders.load(new StringReader((String)params.get(OPTION_DEFAULT_PLACEHOLDERS)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CreationType creationType = CreationType.CREATE_TEST;
            if (params.get(OPTION_CREATION_TYPE) instanceof String) {
                try {
                    creationType = CreationType.valueOf((String)params.get(OPTION_CREATION_TYPE));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            RefObject_1_0 selector = null;
            if (params.get(OPTION_ACCOUNTS_SELECTOR) instanceof RefObject_1_0) {
                selector = (RefObject_1_0)pmUser.getObjectById((Object)((RefObject_1_0)params.get(OPTION_ACCOUNTS_SELECTOR)).refGetPath());
            }
            String name = null;
            if (params.get(OPTION_ACTIVITY_NAME) instanceof String) {
                name = (String)params.get(OPTION_ACTIVITY_NAME);
            }
            String description = null;
            if (params.get(OPTION_ACTIVITY_DESCRIPTION) instanceof String) {
                description = (String)params.get(OPTION_ACTIVITY_DESCRIPTION);
            }
            String detailedDescription = null;
            if (params.get(OPTION_ACTIVITY_DETAILED_DESCRIPTION) instanceof String) {
                detailedDescription = (String)params.get(OPTION_ACTIVITY_DETAILED_DESCRIPTION);
            }
            short priority = 0;
            if (params.get(OPTION_ACTIVITY_PRIORITY) instanceof Number) {
                priority = ((Number)params.get(OPTION_ACTIVITY_PRIORITY)).shortValue();
            }
            Date scheduledStart = null;
            if (params.get(OPTION_ACTIVITY_SCHEDULED_START) instanceof Date) {
                scheduledStart = (Date)params.get(OPTION_ACTIVITY_SCHEDULED_START);
            }
            Date scheduledEnd = null;
            if (params.get(OPTION_ACTIVITY_SCHEDULED_END) instanceof Date) {
                scheduledEnd = (Date)params.get(OPTION_ACTIVITY_SCHEDULED_END);
            }
            Date dueBy = null;
            if (params.get(OPTION_ACTIVITY_DUE_BY) instanceof Date) {
                dueBy = (Date)params.get(OPTION_ACTIVITY_DUE_BY);
            }
            short locale = 0;
            if (params.get(OPTION_LOCALE) instanceof Number) {
                locale = ((Number)params.get(OPTION_LOCALE)).shortValue();
            }
            AccountAddress emailSender = null;
            if (params.get(OPTION_EMAIL_SENDER) instanceof AccountAddress) {
                emailSender = (AccountAddress)pmUser.getObjectById((Object)((AccountAddress)params.get(OPTION_EMAIL_SENDER)).refGetPath());
            }
            String emailMessageSubject = null;
            if (params.get(OPTION_EMAIL_MESSAGE_SUBJECT) instanceof String) {
                emailMessageSubject = (String)params.get(OPTION_EMAIL_MESSAGE_SUBJECT);
            }
            Object emailMessageBody = "";
            int idx = 0;
            while (params.get(OPTION_EMAIL_MESSAGE_BODY + idx) instanceof String) {
                emailMessageBody = (String)emailMessageBody + params.get(OPTION_EMAIL_MESSAGE_BODY + idx);
                ++idx;
            }
            ArrayList<Short> emailAddressUsages = new ArrayList<Short>();
            idx = 0;
            while (params.get(OPTION_EMAIL_ADDRESS_USAGE + idx) instanceof Number) {
                emailAddressUsages.add(((Number)params.get(OPTION_EMAIL_ADDRESS_USAGE + idx)).shortValue());
                ++idx;
            }
            ArrayList<Path> testAccounts = new ArrayList<Path>();
            if (params.get(OPTION_TEST_ACCOUNT) instanceof Account) {
                testAccounts.add(((Account)params.get(OPTION_TEST_ACCOUNT)).refGetPath());
            }
            ArrayList<Path> testEMails = new ArrayList<Path>();
            idx = 0;
            while (params.get(OPTION_TEST_EMAIL + idx) instanceof EMailAddress) {
                testEMails.add(((EMailAddress)params.get(OPTION_TEST_EMAIL + idx)).refGetPath());
                ++idx;
            }
            Boolean excludeNoBulkEMail = null;
            if (params.get(OPTION_EXCLUDE_NO_BULK_EMAIL) instanceof Boolean) {
                excludeNoBulkEMail = (Boolean)params.get(OPTION_EXCLUDE_NO_BULK_EMAIL);
            }
            Boolean ignoreExecutionTimeLimit = null;
            if (params.get(OPTION_IGNORE_EXECUTION_TIME_LIMIT) instanceof Boolean) {
                ignoreExecutionTimeLimit = (Boolean)params.get(OPTION_IGNORE_EXECUTION_TIME_LIMIT);
            }
            RefObject_1_0 targetObject = null;
            if (wfProcessInstance.getTargetObject() != null) {
                try {
                    targetObject = (RefObject_1_0)pmUser.getObjectById((Object)new Path(wfProcessInstance.getTargetObject()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ActivityCreator activityCreator = targetObject instanceof ActivityCreator ? (ActivityCreator)targetObject : null;
            long queryExecutionStartAt = System.currentTimeMillis();
            List<?> selectedObjects = this.getSelectedObjects(selector);
            int numberOfActivities = selectedObjects.size();
            long queryExecutionTime = System.currentTimeMillis() - queryExecutionStartAt;
            if (!Boolean.TRUE.equals(ignoreExecutionTimeLimit) && queryExecutionTime > 5000L && numberOfActivities > 1000) {
                this.createLogEntry("Report - ERROR: Query too slow", wfProcessInstance, queryExecutionTime, 5000L, numberOfActivities);
            } else if (activityCreator != null && (creationType == CreationType.CREATE_CONFIRMED || creationType == CreationType.CREATE_TEST_CONFIRMED)) {
                int numberOfAccountsWithoutEmailAddress = 0;
                int numberOfActivitiesCreated = 0;
                int numberOfActivitiesUpdated = 0;
                int numberOfActivitiesSkipped = 0;
                int numberFailed = 0;
                this.createLogEntry("Report @" + new Date(), wfProcessInstance, numberOfActivities, numberOfAccountsWithoutEmailAddress, numberOfActivitiesCreated, numberOfActivitiesUpdated, numberOfActivitiesSkipped, numberFailed);
                ArrayList<ActivityCreatorThread> activityCreatorThreads = new ArrayList<ActivityCreatorThread>();
                CollectionBasedQueue selectedObjectsQueue = new CollectionBasedQueue(selectedObjects);
                for (int threadIndex = 0; threadIndex < 5; ++threadIndex) {
                    try {
                        ActivityCreatorThread t = new ActivityCreatorThread(pmf, wfProcessInstance.refGetPath(), activityCreator.refGetPath(), selectedObjectsQueue, creationType == CreationType.CREATE_TEST_CONFIRMED ? testAccounts : Collections.emptyList(), creationType == CreationType.CREATE_TEST_CONFIRMED ? testEMails : Collections.emptyList(), threadIndex, creationType == CreationType.CREATE_TEST_CONFIRMED ? (threadIndex == 0 ? 3 : 0) : numberOfActivities, excludeNoBulkEMail, name, description, detailedDescription, dueBy, priority, scheduledEnd, scheduledStart, emailSender == null ? null : emailSender.refGetPath(), emailAddressUsages, emailMessageSubject, (String)emailMessageBody, defaultPlaceHolders, locale);
                        t.start();
                        activityCreatorThreads.add(t);
                        continue;
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
                boolean hasRunningThreads = true;
                int lastTotalCount = 0;
                while (hasRunningThreads) {
                    numberOfAccountsWithoutEmailAddress = 0;
                    numberOfActivitiesCreated = 0;
                    numberOfActivitiesUpdated = 0;
                    numberOfActivitiesSkipped = 0;
                    numberFailed = 0;
                    hasRunningThreads = false;
                    for (ActivityCreatorThread t : activityCreatorThreads) {
                        numberOfAccountsWithoutEmailAddress += t.getNumberOfAccountsWithoutEmailAddress();
                        numberOfActivitiesCreated += t.getNumberOfActivitiesCreated();
                        numberOfActivitiesUpdated += t.getNumberOfActivitiesUpdated();
                        numberOfActivitiesSkipped += t.getNumberOfActivitiesSkipped();
                        numberFailed += t.getNumberFailed();
                        hasRunningThreads |= t.isAlive();
                    }
                    int totalCount = numberOfAccountsWithoutEmailAddress + numberOfActivitiesCreated + numberOfActivitiesUpdated + numberOfActivitiesSkipped;
                    if (totalCount > lastTotalCount + 100) {
                        this.createLogEntry("Report @" + new Date(), wfProcessInstance, numberOfActivities, numberOfAccountsWithoutEmailAddress, numberOfActivitiesCreated, numberOfActivitiesUpdated, numberOfActivitiesSkipped, numberFailed);
                        lastTotalCount = totalCount;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                numberOfAccountsWithoutEmailAddress = 0;
                numberOfActivitiesCreated = 0;
                numberOfActivitiesUpdated = 0;
                numberOfActivitiesSkipped = 0;
                numberFailed = 0;
                for (ActivityCreatorThread t : activityCreatorThreads) {
                    try {
                        t.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    numberOfAccountsWithoutEmailAddress += t.getNumberOfAccountsWithoutEmailAddress();
                    numberOfActivitiesCreated += t.getNumberOfActivitiesCreated();
                    numberOfActivitiesUpdated += t.getNumberOfActivitiesUpdated();
                    numberOfActivitiesSkipped += t.getNumberOfActivitiesSkipped();
                    numberFailed += t.getNumberFailed();
                }
                this.createLogEntry("Report - Complete", wfProcessInstance, numberOfActivities, numberOfAccountsWithoutEmailAddress, numberOfActivitiesCreated, numberOfActivitiesUpdated, numberOfActivitiesSkipped, numberFailed);
            } else if (creationType == CreationType.CREATE || creationType == CreationType.CREATE_TEST) {
                this.createLogEntry("Report - Complete", wfProcessInstance, queryExecutionTime, 5000L, numberOfActivities);
            }
            pmUser.close();
        }
        catch (Exception e) {
            SysLog.warning((String)"Can not perform BulkCreateActivity (reason=Exception)", (Object)e.getMessage());
            ServiceException e0 = new ServiceException(e);
            SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
            WorkflowHelper.createLogEntry(wfProcessInstance, "Can not perform BulkCreateActivity: Exception", e.getMessage());
            throw e0;
        }
    }

    public class ActivityCreatorThread
    extends Thread {
        private int counter = 0;
        private int numberOfActivitiesCreated = 0;
        private int numberOfActivitiesUpdated = 0;
        private int numberOfAccountsWithoutEmailAddress = 0;
        private int numberOfActivitiesSkipped = 0;
        private int numberFailed = 0;
        private final org.opencrx.kernel.activity1.jmi1.Segment activitySegment;
        private final Path wfProcessInstanceIdentity;
        private final ActivityCreator activityCreator;
        private final CollectionBasedQueue selectedObjects;
        private final List<Path> additionalAccounts;
        private final List<Path> additionalAddresses;
        private final int threadIndex;
        private final int limit;
        private final Boolean excludeNoBulkEMail;
        private final String name;
        private final String description;
        private final String detailedDescription;
        private final Date dueBy;
        private final short priority;
        private final Date scheduledEnd;
        private final Date scheduledStart;
        private final AccountAddress emailSender;
        private final List<Short> emailAddressUsages;
        private final String emailMessageSubject;
        private final String emailMessageBody;
        private final Properties defaultPlaceHolders;
        private final short locale;
        private final Codes codes;

        public ActivityCreatorThread(PersistenceManagerFactory pmf, Path wfProcessInstanceIdentity, Path activityCreatorIdentity, CollectionBasedQueue selectedObjects, List<Path> additionalAccounts, List<Path> additionalAddresses, int threadIndex, int limit, Boolean excludeNoBulkEMail, String name, String description, String detailedDescription, Date dueBy, short priority, Date scheduledEnd, Date scheduledStart, Path emailSenderIdentity, List<Short> emailAddressUsages, String emailMessageSubject, String emailMessageBody, Properties defaultPlaceHolders, short locale) throws ServiceException {
            PersistenceManager pm = pmf.getPersistenceManager(wfProcessInstanceIdentity.get(6), null);
            UserObjects.setBulkLoad((PersistenceManager)pm, (boolean)true);
            String providerName = wfProcessInstanceIdentity.get(2);
            String segmentName = wfProcessInstanceIdentity.get(4);
            this.activitySegment = Activities.getInstance().getActivitySegment(pm, providerName, segmentName);
            this.wfProcessInstanceIdentity = wfProcessInstanceIdentity;
            this.activityCreator = (ActivityCreator)pm.getObjectById((Object)activityCreatorIdentity);
            this.excludeNoBulkEMail = excludeNoBulkEMail;
            this.selectedObjects = selectedObjects;
            this.additionalAccounts = additionalAccounts;
            this.additionalAddresses = additionalAddresses;
            this.threadIndex = threadIndex;
            this.limit = limit;
            this.name = name;
            this.description = description;
            this.detailedDescription = detailedDescription;
            this.dueBy = dueBy;
            this.priority = priority;
            this.scheduledEnd = scheduledEnd;
            this.scheduledStart = scheduledStart;
            this.emailSender = emailSenderIdentity == null ? null : (AccountAddress)pm.getObjectById((Object)emailSenderIdentity);
            this.emailAddressUsages = emailAddressUsages;
            this.emailMessageSubject = emailMessageSubject;
            this.emailMessageBody = emailMessageBody;
            this.defaultPlaceHolders = defaultPlaceHolders;
            this.locale = locale;
            this.codes = new Codes((RefObject_1_0)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1").getDescendant(new String[]{"provider", providerName, "segment", "Root"})));
        }

        protected void updateEMailRecipient(EMail email, EMailAddress emailAddress, Activities.PartyType partyType) throws ServiceException {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)email);
            EMailRecipientQuery query = (EMailRecipientQuery)pm.newQuery(EMailRecipient.class);
            query.partyType().equalTo((Object)partyType.getValue());
            query.orderByCreatedAt().descending();
            List emailRecipients = email.getEmailRecipient(query);
            EMailRecipient emailRecipient = null;
            if (emailRecipients.isEmpty()) {
                emailRecipient = (EMailRecipient)pm.newInstance(EMailRecipient.class);
                email.addEmailRecipient(Base.getInstance().getUidAsString(), emailRecipient);
            } else {
                emailRecipient = (EMailRecipient)emailRecipients.iterator().next();
            }
            emailRecipient.setEmailHint(emailAddress.getEmailAddress());
            emailRecipient.setParty(emailAddress);
            emailRecipient.setPartyType(partyType.getValue());
            emailRecipient.setPartyStatus(Activities.PartyStatus.ACCEPTED.getValue());
        }

        protected EMailAddress findEMailAddress(Account account, List<Short> usages, Boolean excludeNoBulkEMail) throws ServiceException {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
            EMailAddress emailAddress = null;
            if (usages != null && !usages.isEmpty()) {
                for (short usage : usages) {
                    List<AccountAddress> addresses = Accounts.getInstance().getAccountAddresses(account, usage);
                    for (AccountAddress address : addresses) {
                        if (!(address instanceof EMailAddress)) continue;
                        emailAddress = emailAddress == null ? (EMailAddress)address : (Boolean.TRUE.equals(address.isMain()) ? (EMailAddress)address : emailAddress);
                    }
                    if (emailAddress == null) continue;
                    break;
                }
            } else {
                EMailAddressQuery emailAddressQuery = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
                emailAddressQuery.forAllDisabled().isFalse();
                emailAddressQuery.orderByCreatedAt().ascending();
                List addresses = account.getAddress(emailAddressQuery);
                for (EMailAddress address : addresses) {
                    emailAddress = emailAddress == null ? address : (Boolean.TRUE.equals(address.isMain()) ? address : emailAddress);
                }
            }
            boolean sendingEmailToContactAllowed = true;
            if (account instanceof Contact && Boolean.TRUE.equals(((Contact)account).isDoNotEMail())) {
                sendingEmailToContactAllowed = false;
            }
            return emailAddress != null && (!Boolean.TRUE.equals(excludeNoBulkEMail) || sendingEmailToContactAllowed) ? emailAddress : null;
        }

        protected void createOrUpdateActivity(Object selectedObject) throws ServiceException {
            AddressGroupMember addressGroupMember;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)selectedObject);
            AccountAddress address = null;
            org.opencrx.kernel.account1.cci2.Account account = null;
            if (selectedObject instanceof Account) {
                account = (Account)selectedObject;
            } else if (selectedObject instanceof AccountAddress) {
                address = (AccountAddress)selectedObject;
                account = (Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent());
            } else if (selectedObject instanceof Member) {
                Member member = (Member)selectedObject;
                if (member.getAccount() != null && !Boolean.TRUE.equals(member.getAccount().isDisabled())) {
                    account = member.getAccount();
                }
            } else if (selectedObject instanceof AddressGroupMember && (addressGroupMember = (AddressGroupMember)selectedObject).getAddress() != null && !Boolean.TRUE.equals(addressGroupMember.getAddress().isDisabled())) {
                address = addressGroupMember.getAddress();
                account = (Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent());
            }
            List activities = null;
            if (account != null) {
                if (this.activityCreator.getActivityType() != null && this.activityCreator.getActivityType().getActivityClass() == Activities.ActivityClass.EMAIL.getValue()) {
                    if (!(address instanceof EMailAddress)) {
                        address = this.findEMailAddress((Account)account, this.emailAddressUsages, this.excludeNoBulkEMail);
                    }
                    if (account != null && address instanceof EMailAddress) {
                        EMailQuery emailQuery = (EMailQuery)pm.newQuery(EMail.class);
                        EMailRecipientQuery emailRecipientQuery = (EMailRecipientQuery)pm.newQuery(EMailRecipient.class);
                        emailRecipientQuery.thereExistsParty().equalTo(address);
                        emailRecipientQuery.partyType().notEqualTo((Object)Activities.PartyType.EMAIL_FROM.getValue());
                        emailQuery.thereExistsEmailRecipient().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)emailRecipientQuery));
                        if (account instanceof Contact) {
                            emailQuery.thereExistsReportingContact().equalTo(account);
                        } else if (account instanceof Account) {
                            emailQuery.thereExistsReportingAccount().equalTo(account);
                        }
                        emailQuery.thereExistsLastAppliedCreator().equalTo(this.activityCreator);
                        emailQuery.orderByCreatedAt().descending();
                        activities = this.activitySegment.getActivity(emailQuery);
                    } else {
                        ++this.numberOfAccountsWithoutEmailAddress;
                    }
                } else {
                    ActivityQuery activityQuery = (ActivityQuery)pm.newQuery(Activity.class);
                    if (account instanceof Contact) {
                        activityQuery.thereExistsReportingContact().equalTo(account);
                    } else if (account instanceof Account) {
                        activityQuery.thereExistsReportingAccount().equalTo(account);
                    }
                    activityQuery.thereExistsLastAppliedCreator().equalTo(this.activityCreator);
                    activityQuery.orderByCreatedAt().descending();
                    activities = this.activitySegment.getActivity(activityQuery);
                }
            }
            if (activities != null) {
                Activity activity = null;
                boolean doUpdateAddress = false;
                if (activities.isEmpty()) {
                    String activityName = this.name + " / " + account.getFullName() + (String)(account.getAliasName() == null ? "" : " / " + account.getAliasName());
                    NewActivityParams newActivityParams = (NewActivityParams)Structures.create(NewActivityParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)NewActivityParams.Member.description, (Object)this.description), Datatypes.member((Enum)NewActivityParams.Member.detailedDescription, (Object)this.detailedDescription), Datatypes.member((Enum)NewActivityParams.Member.dueBy, (Object)this.dueBy), Datatypes.member((Enum)NewActivityParams.Member.icalType, (Object)0), Datatypes.member((Enum)NewActivityParams.Member.name, (Object)activityName), Datatypes.member((Enum)NewActivityParams.Member.priority, (Object)this.priority), Datatypes.member((Enum)NewActivityParams.Member.scheduledEnd, (Object)this.scheduledEnd), Datatypes.member((Enum)NewActivityParams.Member.scheduledStart, (Object)this.scheduledStart)});
                    try {
                        pm.currentTransaction().begin();
                        NewActivityResult result = this.activityCreator.newActivity(newActivityParams);
                        pm.currentTransaction().commit();
                        activity = result.getActivity();
                        ++this.numberOfActivitiesCreated;
                    }
                    catch (Exception e) {
                        ++this.numberFailed;
                        new ServiceException(e).log();
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    doUpdateAddress = true;
                } else {
                    activity = (Activity)activities.iterator().next();
                    if (activity.getCreationContext() == null || !this.wfProcessInstanceIdentity.equals((Object)activity.getCreationContext().refGetPath())) {
                        doUpdateAddress = true;
                        ++this.numberOfActivitiesUpdated;
                    } else {
                        ++this.numberOfActivitiesSkipped;
                    }
                }
                if (doUpdateAddress) {
                    try {
                        String replacedDescription = null;
                        try {
                            replacedDescription = BulkCreateActivityWorkflow.this.replacePlaceHolders((RefObject_1_0)account, this.locale, this.description, this.defaultPlaceHolders, this.codes);
                        }
                        catch (Exception newActivityParams) {
                            // empty catch block
                        }
                        String replacedDetailedDescription = null;
                        try {
                            replacedDetailedDescription = BulkCreateActivityWorkflow.this.replacePlaceHolders((RefObject_1_0)account, this.locale, this.detailedDescription, this.defaultPlaceHolders, this.codes);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        String replacedMessageSubject = null;
                        try {
                            replacedMessageSubject = BulkCreateActivityWorkflow.this.replacePlaceHolders((RefObject_1_0)account, this.locale, this.emailMessageSubject, this.defaultPlaceHolders, this.codes);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String replacedMessageBody = null;
                        try {
                            replacedMessageBody = BulkCreateActivityWorkflow.this.replacePlaceHolders((RefObject_1_0)account, this.locale, this.emailMessageBody, this.defaultPlaceHolders, this.codes);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        pm.currentTransaction().begin();
                        activity.setDescription(replacedDescription);
                        activity.setDetailedDescription(replacedDetailedDescription);
                        activity.setCreationContext((ContextCapable)((WfProcessInstance)pm.getObjectById((Object)this.wfProcessInstanceIdentity)));
                        if (account instanceof Contact) {
                            activity.setReportingContact((Contact)account);
                        } else {
                            activity.setReportingContact(null);
                            activity.setReportingAccount(account);
                        }
                        if (activity instanceof EMail) {
                            EMail email = (EMail)activity;
                            email.setMessageSubject(replacedMessageSubject);
                            email.setMessageBody(replacedMessageBody);
                            email.setSender(this.emailSender);
                            if (this.emailSender instanceof EMailAddress) {
                                this.updateEMailRecipient(email, (EMailAddress)this.emailSender, Activities.PartyType.EMAIL_FROM);
                            }
                            if (address instanceof EMailAddress) {
                                this.updateEMailRecipient(email, (EMailAddress)address, Activities.PartyType.EMAIL_TO);
                            }
                        }
                        pm.currentTransaction().commit();
                    }
                    catch (Exception e) {
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block19: {
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)this.activitySegment);
                try {
                    if (this.threadIndex == 0) {
                        if (this.additionalAccounts != null) {
                            for (Path additionalAccountIdentity : this.additionalAccounts) {
                                this.createOrUpdateActivity(pm.getObjectById((Object)additionalAccountIdentity));
                            }
                        }
                        if (this.additionalAddresses != null) {
                            for (Path additionalAddressIdentity : this.additionalAddresses) {
                                this.createOrUpdateActivity(pm.getObjectById((Object)additionalAddressIdentity));
                            }
                        }
                    }
                    if (this.numberOfActivitiesCreated + this.numberOfActivitiesSkipped + this.numberOfActivitiesUpdated >= this.limit) break block19;
                    Path selectedObjectIdentity = null;
                    while ((selectedObjectIdentity = this.selectedObjects.take()) != null) {
                        try {
                            this.createOrUpdateActivity(pm.getObjectById((Object)selectedObjectIdentity));
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                        }
                        if (this.numberOfActivitiesCreated + this.numberOfActivitiesSkipped + this.numberOfActivitiesUpdated < this.limit) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
                finally {
                    try {
                        pm.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public int getCounter() {
            return this.counter;
        }

        public int getNumberOfActivitiesCreated() {
            return this.numberOfActivitiesCreated;
        }

        public int getNumberOfActivitiesUpdated() {
            return this.numberOfActivitiesUpdated;
        }

        public int getNumberOfAccountsWithoutEmailAddress() {
            return this.numberOfAccountsWithoutEmailAddress;
        }

        public int getNumberOfActivitiesSkipped() {
            return this.numberOfActivitiesSkipped;
        }

        public int getNumberFailed() {
            return this.numberFailed;
        }
    }

    public static class CollectionBasedQueue {
        private final Iterator<?> objectsIterator;

        public CollectionBasedQueue(List<?> objects) {
            this.objectsIterator = objects.iterator();
        }

        public synchronized Path take() {
            return this.objectsIterator.hasNext() ? ((RefObject_1_0)this.objectsIterator.next()).refGetPath() : null;
        }
    }

    public static enum CreationType {
        CREATE,
        CREATE_CONFIRMED,
        CREATE_TEST,
        CREATE_TEST_CONFIRMED;

    }
}

