/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableMapTemplate;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.OffsetMapCache;

public abstract class ImmutableOffsetMapTemplate<K>
extends ImmutableMapTemplate<K> {
    private final @NonNull ImmutableMap<K, Integer> offsets;

    ImmutableOffsetMapTemplate(ImmutableMap<K, Integer> offsets) {
        this.offsets = Objects.requireNonNull(offsets);
    }

    public static <K> @NonNull ImmutableOffsetMapTemplate<K> ordered(Collection<K> keys) {
        Preconditions.checkArgument((keys.size() > 1 ? 1 : 0) != 0);
        return new Ordered<K>(keys);
    }

    public static <K> @NonNull ImmutableOffsetMapTemplate<K> unordered(Collection<K> keys) {
        Preconditions.checkArgument((keys.size() > 1 ? 1 : 0) != 0);
        return new Unordered<K>(keys);
    }

    @Override
    public final Set<K> keySet() {
        return this.offsets.keySet();
    }

    @Override
    public final <T, V> @NonNull ImmutableOffsetMap<K, V> instantiateTransformed(Map<K, T> fromMap, BiFunction<K, T, V> valueTransformer) {
        int size = this.offsets.size();
        Preconditions.checkArgument((fromMap.size() == size ? 1 : 0) != 0);
        Object[] objects = new Object[size];
        for (Map.Entry<K, T> entry : fromMap.entrySet()) {
            K key = Objects.requireNonNull(entry.getKey());
            Integer offset = (Integer)this.offsets.get(key);
            Preconditions.checkArgument((offset != null ? 1 : 0) != 0, (String)"Key %s present in input, but not in offsets %s", key, this.offsets);
            objects[offset.intValue()] = this.transformValue(key, entry.getValue(), valueTransformer);
        }
        return this.createMap(this.offsets, objects);
    }

    @Override
    @SafeVarargs
    public final <V> @NonNull ImmutableOffsetMap<K, V> instantiateWithValues(V ... values) {
        Preconditions.checkArgument((values.length == this.offsets.size() ? 1 : 0) != 0);
        Object[] copy = (Object[])values.clone();
        Arrays.stream(copy).forEach(Objects::requireNonNull);
        return this.createMap(this.offsets, values);
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offsets", this.offsets).toString();
    }

    abstract <V> @NonNull ImmutableOffsetMap<K, V> createMap(ImmutableMap<K, Integer> var1, V[] var2);

    private static final class Unordered<K>
    extends ImmutableOffsetMapTemplate<K> {
        Unordered(Collection<K> keys) {
            super(OffsetMapCache.unorderedOffsets(keys));
        }

        @Override
        <V> @NonNull ImmutableOffsetMap<K, V> createMap(ImmutableMap<K, Integer> offsets, V[] objects) {
            return new ImmutableOffsetMap.Unordered<K, V>(offsets, objects);
        }
    }

    private static final class Ordered<K>
    extends ImmutableOffsetMapTemplate<K> {
        Ordered(Collection<K> keys) {
            super(OffsetMapCache.orderedOffsets(keys));
        }

        @Override
        <V> @NonNull ImmutableOffsetMap<K, V> createMap(ImmutableMap<K, Integer> offsets, V[] objects) {
            return new ImmutableOffsetMap.Ordered<K, V>(offsets, objects);
        }
    }
}

