/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.Function;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public abstract class ExceptionMapper<X extends Exception>
implements Function<Exception, X> {
    private final Class<X> exceptionType;
    private final String opName;

    public ExceptionMapper(String opName, Class<X> exceptionType) {
        this.exceptionType = Objects.requireNonNull(exceptionType);
        this.opName = Objects.requireNonNull(opName);
    }

    protected final Class<X> getExceptionType() {
        return this.exceptionType;
    }

    protected abstract X newWithCause(String var1, Throwable var2);

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE", "NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public X apply(Exception input) {
        if (this.exceptionType.isAssignableFrom(input.getClass())) {
            return (X)input;
        }
        if (input instanceof ExecutionException && input.getCause() != null) {
            if (this.exceptionType.isAssignableFrom(input.getCause().getClass())) {
                return (X)((Exception)input.getCause());
            }
            return this.newWithCause(this.opName + " execution failed", input.getCause());
        }
        if (input instanceof InterruptedException) {
            return this.newWithCause(this.opName + " was interupted.", input);
        }
        if (input instanceof CancellationException) {
            return this.newWithCause(this.opName + " was cancelled.", input);
        }
        return this.newWithCause(this.opName + " encountered an unexpected failure", input);
    }
}

