/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.DoNotLeakSpotbugs;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QQNv1;
import org.opendaylight.yangtools.yang.common.UQNv1;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;

@NonNullByDefault
public abstract sealed class UnresolvedQName
extends AbstractQName {
    private static final long serialVersionUID = 1L;

    private UnresolvedQName(String localName) {
        super(localName);
    }

    public static @Nullable Unqualified tryLocalName(String localName) {
        return UnresolvedQName.isValidLocalName(localName) ? new Unqualified(localName) : null;
    }

    @Override
    public abstract UnresolvedQName intern();

    public abstract @Nullable String getPrefix();

    public abstract Qualified withPrefix(String var1);

    public static final class Unqualified
    extends UnresolvedQName
    implements Comparable<Unqualified> {
        private static final long serialVersionUID = 1L;
        private static final Interner<Unqualified> INTERNER = Interners.newWeakInterner();

        Unqualified(String localName) {
            super(localName);
        }

        public static Unqualified of(String localName) {
            return new Unqualified(Unqualified.checkLocalName(localName));
        }

        public static Unqualified readFrom(DataInput in) throws IOException {
            return Unqualified.of(in.readUTF());
        }

        @Override
        public Unqualified unbind() {
            return this;
        }

        @Override
        public Unqualified intern() {
            String internedName = DoNotLeakSpotbugs.internedString(this.getLocalName());
            Unqualified template = internedName == null ? this : new Unqualified(internedName);
            return (Unqualified)INTERNER.intern((Object)template);
        }

        @Override
        public @Nullable String getPrefix() {
            return null;
        }

        @Override
        public Qualified withPrefix(String newPrefix) {
            return new Qualified(newPrefix, this.getLocalName());
        }

        @Override
        public int compareTo(Unqualified o) {
            return this.getLocalName().compareTo(o.getLocalName());
        }

        public void writeTo(DataOutput out) throws IOException {
            out.writeUTF(this.getLocalName());
        }

        @Override
        public int hashCode() {
            return this.getLocalName().hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Unqualified)) return false;
            Unqualified other = (Unqualified)obj;
            if (!this.getLocalName().equals(other.getLocalName())) return false;
            return true;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("localName", (Object)this.getLocalName()).toString();
        }

        @Override
        Object writeReplace() {
            return new UQNv1(this);
        }
    }

    public static final class Qualified
    extends UnresolvedQName
    implements Comparable<Qualified> {
        private static final long serialVersionUID = 1L;
        private static final Interner<Qualified> INTERNER = Interners.newWeakInterner();
        private final String prefix;

        private Qualified(String prefix, String localName) {
            super(localName);
            this.prefix = Objects.requireNonNull(prefix);
        }

        public static Qualified of(String prefix, String localName) {
            return new Qualified(Qualified.checkLocalName(prefix), Qualified.checkLocalName(localName));
        }

        public static Qualified readFrom(DataInput in) throws IOException {
            return Qualified.of(in.readUTF(), in.readUTF());
        }

        @Override
        public @NonNull String getPrefix() {
            return this.prefix;
        }

        public Optional<QName> bindTo(YangNamespaceContext namespaceContext) {
            return namespaceContext.findNamespaceForPrefix(this.prefix).map(this::bindTo);
        }

        @Override
        public Qualified intern() {
            String internedName = DoNotLeakSpotbugs.internedString(this.getLocalName());
            Qualified template = internedName == null ? this : new Qualified(this.prefix.intern(), internedName);
            return (Qualified)INTERNER.intern((Object)template);
        }

        @Override
        public Qualified withPrefix(String newPrefix) {
            return this.prefix.equals(newPrefix) ? this : new Qualified(newPrefix, this.getLocalName());
        }

        @Override
        public int compareTo(Qualified o) {
            return this.getLocalName().compareTo(o.getLocalName());
        }

        public void writeTo(DataOutput out) throws IOException {
            out.writeUTF(this.getLocalName());
        }

        @Override
        public int hashCode() {
            return this.getLocalName().hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Qualified)) return false;
            Qualified other = (Qualified)obj;
            if (!this.getLocalName().equals(other.getLocalName())) return false;
            return true;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("localName", (Object)this.getLocalName()).toString();
        }

        @Override
        Object writeReplace() {
            return new QQNv1(this);
        }
    }
}

