/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.regex.qual.Regex;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.QNv1;
import org.opendaylight.yangtools.yang.common.Revision;

public final class QName
implements Immutable,
Serializable,
Comparable<QName>,
Identifier,
WritableObject {
    private static final Interner<QName> INTERNER = Interners.newWeakInterner();
    private static final long serialVersionUID = 5398411242927766414L;
    static final String QNAME_REVISION_DELIMITER = "?revision=";
    static final String QNAME_LEFT_PARENTHESIS = "(";
    static final String QNAME_RIGHT_PARENTHESIS = ")";
    private static final @Regex String QNAME_STRING_FULL = "^\\((.+)\\?revision=(.+)\\)(.+)$";
    private static final Pattern QNAME_PATTERN_FULL = Pattern.compile("^\\((.+)\\?revision=(.+)\\)(.+)$");
    private static final @Regex String QNAME_STRING_NO_REVISION = "^\\((.+)\\)(.+)$";
    private static final Pattern QNAME_PATTERN_NO_REVISION = Pattern.compile("^\\((.+)\\)(.+)$");
    private final @NonNull QNameModule module;
    private final @NonNull String localName;
    private transient int hash = 0;

    QName(QNameModule module, @NonNull String localName) {
        this.module = Objects.requireNonNull(module);
        this.localName = Objects.requireNonNull(localName);
    }

    private QName(URI namespace, String localName) {
        this(QNameModule.create(namespace), AbstractQName.checkLocalName(localName));
    }

    public static @NonNull QName create(String input) {
        Matcher matcher = QNAME_PATTERN_FULL.matcher(input);
        if (matcher.matches()) {
            String namespace = matcher.group(1);
            String revision = matcher.group(2);
            String localName = matcher.group(3);
            return QName.create(namespace, revision, localName);
        }
        matcher = QNAME_PATTERN_NO_REVISION.matcher(input);
        if (matcher.matches()) {
            URI namespace = URI.create(matcher.group(1));
            String localName = matcher.group(2);
            return new QName(namespace, localName);
        }
        throw new IllegalArgumentException("Invalid input: " + input);
    }

    public static @NonNull QName create(QName base, String localName) {
        return QName.create(base.getModule(), localName);
    }

    public static @NonNull QName create(QNameModule qnameModule, String localName) {
        return new QName(Objects.requireNonNull(qnameModule, "module may not be null"), AbstractQName.checkLocalName(localName));
    }

    public static @NonNull QName create(URI namespace, @Nullable Revision revision, String localName) {
        return QName.create(QNameModule.create(namespace, revision), localName);
    }

    public static @NonNull QName create(URI namespace, Optional<Revision> revision, String localName) {
        return QName.create(QNameModule.create(namespace, revision), localName);
    }

    public static @NonNull QName create(String namespace, String localName, Revision revision) {
        return QName.create(QNameModule.create(QName.parseNamespace(namespace), revision), localName);
    }

    public static @NonNull QName create(String namespace, String revision, String localName) {
        return QName.create(QName.parseNamespace(namespace), Revision.of(revision), localName);
    }

    public static @NonNull QName create(String namespace, String localName) {
        return QName.create(QName.parseNamespace(namespace), localName);
    }

    public static @NonNull QName create(URI namespace, String localName) {
        return new QName(namespace, localName);
    }

    public static @NonNull QName readFrom(DataInput in) throws IOException {
        QNameModule module = QNameModule.readFrom(in);
        return new QName(module, AbstractQName.checkLocalName(in.readUTF()));
    }

    public @NonNull QNameModule getModule() {
        return this.module;
    }

    public @NonNull URI getNamespace() {
        return this.module.getNamespace();
    }

    public @NonNull String getLocalName() {
        return this.localName;
    }

    public @NonNull Optional<Revision> getRevision() {
        return this.module.getRevision();
    }

    public @NonNull QName intern() {
        QNameModule cacheMod = this.module.intern();
        QName template = cacheMod == this.module ? this : new QName(cacheMod, this.localName.intern());
        return (QName)INTERNER.intern((Object)template);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.module, this.localName);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QName)) {
            return false;
        }
        QName other = (QName)obj;
        return Objects.equals(this.localName, other.localName) && this.module.equals(other.module);
    }

    private static @NonNull URI parseNamespace(String namespace) {
        try {
            return new URI(namespace);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' is not a valid URI", ue);
        }
    }

    public @NonNull String toString() {
        StringBuilder sb = new StringBuilder().append(QNAME_LEFT_PARENTHESIS).append(this.getNamespace());
        Optional<Revision> rev = this.getRevision();
        if (rev.isPresent()) {
            sb.append(QNAME_REVISION_DELIMITER).append(rev.get());
        }
        return sb.append(QNAME_RIGHT_PARENTHESIS).append(this.localName).toString();
    }

    public @NonNull QName withModule(QNameModule newModule) {
        return new QName(newModule, this.localName);
    }

    public @NonNull QName withoutRevision() {
        QNameModule newModule = this.module.withoutRevision();
        return newModule == this.module ? this : new QName(newModule, this.localName);
    }

    public static @Nullable String formattedRevision(Optional<Revision> revision) {
        return revision.map(Revision::toString).orElse(null);
    }

    public boolean isEqualWithoutRevision(QName other) {
        return this.localName.equals(other.getLocalName()) && Objects.equals(this.getNamespace(), other.getNamespace());
    }

    @Override
    public int compareTo(QName o) {
        int result = this.localName.compareTo(o.localName);
        if (result != 0) {
            return result;
        }
        return this.module.compareTo(o.module);
    }

    public void writeTo(DataOutput out) throws IOException {
        this.module.writeTo(out);
        out.writeUTF(this.localName);
    }

    Object writeReplace() {
        return new QNv1(this);
    }
}

