/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.UnsignedInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

@Beta
@NonNullByDefault
public class Uint32
extends Number
implements CanonicalValue<Uint32> {
    private static final CanonicalValueSupport<Uint32> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final long MIN_VALUE = 0L;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    private static final Uint32[] CACHE = new Uint32[255];
    private static final Uint32[] COMMON = new Uint32[]{new Uint32(Short.MAX_VALUE), new Uint32(32768), new Uint32(65535), new Uint32(65536), new Uint32(Integer.MAX_VALUE)};
    private static final int DEFAULT_LRU_SIZE = 1024;
    private static final String LRU_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint32.LRU.size";
    private static final int MAX_LRU_SIZE = 0xFFFFFF;
    private static final int LRU_SIZE;
    private static final LoadingCache<Integer, Uint32> LRU;
    private final int value;

    Uint32(int value) {
        this.value = value;
    }

    protected Uint32(Uint32 other) {
        this.value = other.value;
    }

    private static Uint32 instanceFor(int value) {
        long longSlot = Integer.toUnsignedLong(value);
        return longSlot < (long)CACHE.length ? Uint32.fromCache((int)longSlot, value) : Uint32.fromCommon(value);
    }

    private static Uint32 fromCommon(int value) {
        for (Uint32 c : COMMON) {
            if (c.value != value) continue;
            return c;
        }
        return (Uint32)LRU.getUnchecked((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Uint32 fromCache(int slot, int value) {
        Uint32 ret = CACHE[slot];
        if (ret != null) return ret;
        Uint32[] uint32Array = CACHE;
        synchronized (CACHE) {
            ret = CACHE[slot];
            if (ret != null) return ret;
            Uint32.CACHE[slot] = ret = new Uint32(value);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    public static Uint32 fromIntBits(int bits) {
        return Uint32.instanceFor(bits);
    }

    public static Uint32 fromUnsignedInteger(UnsignedInteger uint) {
        return Uint32.instanceFor(uint.intValue());
    }

    public static Uint32 valueOf(byte byteVal) {
        Preconditions.checkArgument(((long)byteVal >= 0L ? 1 : 0) != 0, (Object)"Negative values are not allowed");
        return Uint32.instanceFor(byteVal);
    }

    public static Uint32 valueOf(short shortVal) {
        Preconditions.checkArgument(((long)shortVal >= 0L ? 1 : 0) != 0, (Object)"Negative values are not allowed");
        return Uint32.instanceFor(shortVal);
    }

    public static Uint32 valueOf(int intVal) {
        Preconditions.checkArgument(((long)intVal >= 0L ? 1 : 0) != 0, (String)"Value %s is outside of allowed range", (int)intVal);
        return Uint32.instanceFor(intVal);
    }

    public static Uint32 valueOf(long longVal) {
        Preconditions.checkArgument((longVal >= 0L && longVal <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"Value %s is outside of allowed range", (long)longVal);
        return Uint32.instanceFor((int)longVal);
    }

    public static Uint32 valueOf(Uint8 uint) {
        return Uint32.instanceFor(uint.shortValue());
    }

    public static Uint32 valueOf(Uint16 uint) {
        return Uint32.instanceFor(uint.intValue());
    }

    public static Uint32 valueOf(Uint64 uint) {
        return Uint32.valueOf(uint.longValue());
    }

    public static Uint32 valueOf(String string) {
        return Uint32.valueOf(string, 10);
    }

    public static Uint32 valueOf(String string, int radix) {
        return Uint32.instanceFor(Integer.parseUnsignedInt(string, radix));
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return Integer.toUnsignedLong(this.value);
    }

    @Override
    public final float floatValue() {
        return this.longValue();
    }

    @Override
    public final double doubleValue() {
        return this.longValue();
    }

    public final UnsignedInteger toUnsignedInteger() {
        return UnsignedInteger.fromIntBits((int)this.value);
    }

    @Override
    public final int compareTo(Uint32 o) {
        return Integer.compareUnsigned(this.value, o.value);
    }

    @Override
    public final String toCanonicalString() {
        return Integer.toUnsignedString(this.value);
    }

    @Override
    public final CanonicalValueSupport<Uint32> support() {
        return SUPPORT;
    }

    public final int hashCode() {
        return Integer.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint32 && this.value == ((Uint32)obj).value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint32.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(LRU_SIZE_PROPERTY, 1024);
        LRU_SIZE = p >= 0 ? Math.min(p, 0xFFFFFF) : 1024;
        LRU = CacheBuilder.newBuilder().weakValues().maximumSize((long)LRU_SIZE).build((CacheLoader)new CacheLoader<Integer, Uint32>(){

            public Uint32 load(Integer key) {
                return new Uint32(key);
            }
        });
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint32> {
        public Support() {
            super(Uint32.class);
        }

        @Override
        public Variant<Uint32, CanonicalValueViolation> fromString(String str) {
            try {
                return Variant.ofFirst((Object)Uint32.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

