/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi;

import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStorage;
import org.opendaylight.yangtools.yang.parser.spi.meta.OnDemandSchemaTreeStorage;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class SchemaTreeNamespaceBehaviour<D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>>
extends NamespaceBehaviour<QName, StmtContext<QName, D, E>> {
    SchemaTreeNamespaceBehaviour() {
        super(ParserNamespaces.schemaTree());
    }

    @Override
    public StmtContext<QName, D, E> getFrom(NamespaceStorage.GlobalStorage global, NamespaceStorage storage, QName key) {
        NamespaceStorage storageNode = SchemaTreeNamespaceBehaviour.globalOrStatementSpecific(storage);
        StmtContext<QName, D, E> existing = (StmtContext<QName, D, E>)storageNode.getFromLocalStorage(this.namespace(), key);
        return existing != null ? existing : SchemaTreeNamespaceBehaviour.requestFrom(storageNode, key);
    }

    @Override
    public Map<QName, StmtContext<QName, D, E>> getAllFrom(NamespaceStorage.GlobalStorage global, NamespaceStorage storage) {
        return null;
    }

    @Override
    public void addTo(NamespaceStorage.GlobalStorage global, NamespaceStorage storage, QName key, StmtContext<QName, D, E> value) {
        StmtContext<QName, D, E> prev = SchemaTreeNamespaceBehaviour.globalOrStatementSpecific(storage).putToLocalStorageIfAbsent(this.namespace(), key, value);
        if (prev != null) {
            throw new SourceException(value, "Error in module '%s': cannot add '%s'. Node name collision: '%s' already declared at %s", value.getRoot().rawArgument(), key, prev.argument(), prev.sourceReference());
        }
    }

    private static <D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>> StmtContext<QName, D, E> requestFrom(NamespaceStorage storage, QName key) {
        StmtContext stmtContext;
        if (storage instanceof OnDemandSchemaTreeStorage) {
            OnDemandSchemaTreeStorage ondemand = (OnDemandSchemaTreeStorage)storage;
            stmtContext = ondemand.requestSchemaTreeChild(key);
        } else {
            stmtContext = null;
        }
        return stmtContext;
    }

    private static NamespaceStorage globalOrStatementSpecific(NamespaceStorage storage) {
        NamespaceStorage current = storage;
        while (current.getStorageType() != NamespaceStorage.StorageType.STATEMENT_LOCAL) {
            NamespaceStorage parent = current.getParentStorage();
            if (parent == null) {
                return current;
            }
            current = parent;
        }
        return current;
    }
}

