/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.model.spi.source.SourceInfo;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;

@NonNullByDefault
public record BuildSpecification(String symbolicName, ImmutableMap<QNameModule, SourceSpec.Module> modules, @Nullable FeatureSet featureSet) {
    public BuildSpecification(String symbolicName, ImmutableMap<QNameModule, SourceSpec.Module> modules, @Nullable FeatureSet featureSet) {
        Objects.requireNonNull(symbolicName);
        Objects.requireNonNull(modules);
    }

    public static sealed interface SourceSpec {
        public SourceInfo info();

        public StatementStreamSource stream();

        public static final class Submodule
        extends Record
        implements SourceSpec {
            private final SourceInfo.Submodule info;
            private final StatementStreamSource stream;

            public Submodule(SourceInfo.Submodule info, StatementStreamSource stream) {
                info = Objects.requireNonNull(info);
                stream = Objects.requireNonNull(stream);
                this.info = info;
                this.stream = stream;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Submodule.class, "info;stream", "info", "stream"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Submodule.class, "info;stream", "info", "stream"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Submodule.class, "info;stream", "info", "stream"}, this, o);
            }

            public SourceInfo.Submodule info() {
                return this.info;
            }

            @Override
            public StatementStreamSource stream() {
                return this.stream;
            }
        }

        public static final class Module
        extends Record
        implements SourceSpec {
            private final SourceInfo.Module info;
            private final StatementStreamSource stream;
            private final ImmutableMap<SourceIdentifier, Submodule> submodules;
            private final @Nullable ImmutableSet<QName> allowDeviationsFrom;
            private final // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable ModuleEffectiveStatement.ConformanceType conformanceType;

            public Module(SourceInfo.Module info, StatementStreamSource stream, ImmutableMap<SourceIdentifier, Submodule> submodules, @Nullable ImmutableSet<QName> allowDeviationsFrom, // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable ModuleEffectiveStatement.ConformanceType conformanceType) {
                Objects.requireNonNull(info);
                Objects.requireNonNull(stream);
                Objects.requireNonNull(submodules);
                this.info = info;
                this.stream = stream;
                this.submodules = submodules;
                this.allowDeviationsFrom = allowDeviationsFrom;
                this.conformanceType = conformanceType;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Module.class, "info;stream;submodules;allowDeviationsFrom;conformanceType", "info", "stream", "submodules", "allowDeviationsFrom", "conformanceType"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Module.class, "info;stream;submodules;allowDeviationsFrom;conformanceType", "info", "stream", "submodules", "allowDeviationsFrom", "conformanceType"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Module.class, "info;stream;submodules;allowDeviationsFrom;conformanceType", "info", "stream", "submodules", "allowDeviationsFrom", "conformanceType"}, this, o);
            }

            public SourceInfo.Module info() {
                return this.info;
            }

            @Override
            public StatementStreamSource stream() {
                return this.stream;
            }

            public ImmutableMap<SourceIdentifier, Submodule> submodules() {
                return this.submodules;
            }

            public @Nullable ImmutableSet<QName> allowDeviationsFrom() {
                return this.allowDeviationsFrom;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable ModuleEffectiveStatement.ConformanceType conformanceType() {
                return this.conformanceType;
            }
        }
    }
}

