/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.utils;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class RewindableFileInputStream
extends InputStream {
    private FileInputStream backedStream;
    private final File backedFile;
    private int markCount = 0;
    private boolean closed = false;

    public RewindableFileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    public RewindableFileInputStream(File file) throws FileNotFoundException {
        this(file, new FileInputStream(file));
    }

    private RewindableFileInputStream(File file, FileInputStream inputStream) {
        this.backedStream = inputStream;
        this.backedFile = file;
    }

    @Override
    public void mark(int mark) {
        this.markCount = mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed.  Cannot reset a closed stream.");
        }
        FileInputStream newStream = new FileInputStream(this.backedFile);
        this.backedStream.close();
        this.backedStream = newStream;
        this.skip(this.markCount);
    }

    @Override
    public void close() throws IOException {
        this.backedStream.close();
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        return this.backedStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.backedStream.available();
    }

    public FileChannel getChannel() {
        return this.backedStream.getChannel();
    }

    public final FileDescriptor getFD() throws IOException {
        return this.backedStream.getFD();
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        return this.backedStream.read(arg0, arg1, arg2);
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        return this.backedStream.read(arg0);
    }

    @Override
    public long skip(long arg0) throws IOException {
        return this.backedStream.skip(arg0);
    }
}

