/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.utils.thread;

public class ConfigurableInheritableThreadLocal<T>
extends InheritableThreadLocal<T> {
    protected static boolean threadSupportEnabled = false;
    protected static Object nonThreadedValue = null;
    protected static boolean firstCall = true;

    public static void enableThreading(boolean enable) {
        threadSupportEnabled = enable;
    }

    public static boolean isThreadingEnabled() {
        return threadSupportEnabled;
    }

    @Override
    public final T get() {
        if (threadSupportEnabled) {
            return super.get();
        }
        if (firstCall) {
            firstCall = false;
            nonThreadedValue = super.get();
        }
        return (T)nonThreadedValue;
    }

    @Override
    public final void remove() {
        super.remove();
        firstCall = true;
        nonThreadedValue = null;
    }

    @Override
    public final void set(T value) {
        super.set(value);
        if (!threadSupportEnabled) {
            nonThreadedValue = value;
        }
    }
}

