/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.agreement;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Iterator;
import java.util.Map;

public class CohensKappaInterraterAgreement {
    public static <K, A> double calculate(Map<K, A> rater1, Map<K, A> rater2) {
        int totalCount = 0;
        int agreementCount = 0;
        TObjectIntHashMap answerCountsR1 = new TObjectIntHashMap();
        TObjectIntHashMap answerCountsR2 = new TObjectIntHashMap();
        for (K subjectKey : rater1.keySet()) {
            if (!rater2.keySet().contains(subjectKey)) continue;
            A r1a = rater1.get(subjectKey);
            A r2a = rater2.get(subjectKey);
            if (r1a == null || r2a == null) continue;
            Iterator<Object> annotation1 = r1a;
            A annotation2 = r2a;
            if (annotation1.equals(annotation2)) {
                ++agreementCount;
            }
            answerCountsR1.putIfAbsent(annotation1, 0);
            answerCountsR2.putIfAbsent(annotation2, 0);
            answerCountsR1.increment(annotation1);
            answerCountsR2.increment(annotation2);
            ++totalCount;
        }
        System.out.println(answerCountsR1);
        double PrA = (double)agreementCount / (double)totalCount;
        System.out.println(PrA);
        double PrE = 0.0;
        for (Object ann : answerCountsR1.keySet()) {
            Integer i = answerCountsR2.get(ann);
            double PrAnnR1 = (double)answerCountsR1.get(ann) / (double)totalCount;
            double PrAnnR2 = (double)(i == null ? 0 : i) / (double)totalCount;
            PrE += PrAnnR1 * PrAnnR2;
        }
        System.out.println(PrE);
        double kappa = (PrA - PrE) / (1.0 - PrE);
        return kappa;
    }
}

