/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster.analyser;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyser;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyserUtils;
import org.openimaj.experiment.evaluation.cluster.analyser.NMIAnalysis;
import org.openimaj.logger.LoggerUtils;

public class NMIClusterAnalyser
implements ClusterAnalyser<NMIAnalysis> {
    private static final Logger logger = LogManager.getLogger(NMIClusterAnalyser.class);

    @Override
    public NMIAnalysis analyse(int[][] correct, int[][] estimated) {
        NMIAnalysis ret = new NMIAnalysis();
        Map<Integer, Integer> invCor = ClusterAnalyserUtils.invert(correct);
        Map<Integer, Integer> invEst = ClusterAnalyserUtils.invert(estimated);
        ret.nmi = this.nmi(correct, estimated, invCor, invEst);
        return ret;
    }

    private double nmi(int[][] c, int[][] e, Map<Integer, Integer> ic, Map<Integer, Integer> ie) {
        double N = Math.max(ic.size(), ie.size());
        double mi = this.mutualInformation(N, c, e, ic, ie);
        LoggerUtils.debugFormat((Logger)logger, (String)"Iec = %2.5f", (Object[])new Object[]{mi});
        double ent_e = this.entropy(e, N);
        LoggerUtils.debugFormat((Logger)logger, (String)"He = %2.5f", (Object[])new Object[]{ent_e});
        double ent_c = this.entropy(c, N);
        LoggerUtils.debugFormat((Logger)logger, (String)"Hc = %2.5f", (Object[])new Object[]{ent_c});
        return mi / ((ent_e + ent_c) / 2.0);
    }

    private double entropy(int[][] clusters, double N) {
        double total = 0.0;
        for (int k = 0; k < clusters.length; ++k) {
            LoggerUtils.debugFormat((Logger)logger, (String)"%2.1f/%2.1f * log2 ((%2.1f / %2.1f) )", (Object[])new Object[]{(double)clusters[k].length, N, (double)clusters[k].length, N});
            double prop = (double)clusters[k].length / N;
            total += prop * this.log2(prop);
        }
        return -total;
    }

    private double log2(double prop) {
        if (prop == 0.0) {
            return 0.0;
        }
        return Math.log(prop) / Math.log(2.0);
    }

    private double mutualInformation(double N, int[][] c, int[][] e, Map<Integer, Integer> ic, Map<Integer, Integer> ie) {
        double mi = 0.0;
        for (int k = 0; k < e.length; ++k) {
            double n_e = e[k].length;
            for (int j = 0; j < c.length; ++j) {
                double n_c = c[j].length;
                double both = 0.0;
                for (int i = 0; i < e[k].length; ++i) {
                    Integer itemCluster = ic.get(e[k][i]);
                    if (itemCluster == null || itemCluster != j) continue;
                    both += 1.0;
                }
                double normProp = both * N / (n_c * n_e);
                double sum = both / N * this.log2(normProp);
                mi += sum;
            }
        }
        return mi;
    }
}

