/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation;

import java.util.Map;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.validation.DefaultValidationData;
import org.openimaj.experiment.validation.RandomisedPercentageHoldOut;

public class StratifiedGroupedRandomisedPercentageHoldOut<KEY, INSTANCE>
extends DefaultValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> {
    public StratifiedGroupedRandomisedPercentageHoldOut(double percentageTraining, GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> dataset) {
        if (percentageTraining < 0.0 || percentageTraining > 1.0) {
            throw new IllegalArgumentException("percentage of training instances must be between 0 and 1");
        }
        this.training = new MapBackedDataset();
        this.validation = new MapBackedDataset();
        Map trainMap = ((MapBackedDataset)this.training).getMap();
        Map validMap = ((MapBackedDataset)this.validation).getMap();
        for (Object key : dataset.getGroups()) {
            RandomisedPercentageHoldOut ho = new RandomisedPercentageHoldOut(percentageTraining, (ListDataset)dataset.getInstances(key));
            trainMap.put(key, ho.training);
            validMap.put(key, ho.validation);
        }
    }
}

