/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation.cross;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.experiment.validation.DefaultValidationData;
import org.openimaj.experiment.validation.ValidationData;
import org.openimaj.experiment.validation.cross.CrossValidationIterable;
import org.openimaj.experiment.validation.cross.CrossValidator;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.SkippingListView;

public class GroupedLeaveOneOut<KEY, INSTANCE>
implements CrossValidator<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> {
    @Override
    public CrossValidationIterable<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> createIterable(GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> data) {
        return new GroupedLeaveOneOutIterable(data);
    }

    public String toString() {
        return "Leave-One-Out Cross Validation (LOOCV) for grouped data.";
    }

    private class GroupedLeaveOneOutIterable
    implements CrossValidationIterable<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> {
        private GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset;

        public GroupedLeaveOneOutIterable(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset) {
            this.dataset = dataset;
        }

        @Override
        public int numberIterations() {
            return this.dataset.numInstances();
        }

        @Override
        public Iterator<ValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>>> iterator() {
            return new Iterator<ValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>>>(){
                int validationIndex = 0;
                int validationGroupIndex = 0;
                Iterator<KEY> groupIterator = GroupedLeaveOneOutIterable.access$000(GroupedLeaveOneOutIterable.this).getGroups().iterator();
                KEY currentGroup = this.groupIterator.hasNext() ? this.groupIterator.next() : null;
                List<INSTANCE> currentValues = this.currentGroup == null ? null : DatasetAdaptors.asList(GroupedLeaveOneOutIterable.access$000(GroupedLeaveOneOutIterable.this).getInstances(this.currentGroup));

                @Override
                public boolean hasNext() {
                    return this.validationIndex < GroupedLeaveOneOutIterable.this.dataset.numInstances();
                }

                @Override
                public ValidationData<GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE>> next() {
                    if (this.currentValues == null || this.validationGroupIndex >= this.currentValues.size()) {
                        this.validationGroupIndex = 0;
                        this.currentGroup = this.groupIterator.next();
                        this.currentValues = this.currentGroup == null ? null : DatasetAdaptors.asList(GroupedLeaveOneOutIterable.this.dataset.getInstances(this.currentGroup));
                        return this.next();
                    }
                    int selectedIndex = this.validationGroupIndex++;
                    HashMap<Object, Object> train = new HashMap<Object, Object>();
                    for (Object group : GroupedLeaveOneOutIterable.this.dataset.getGroups()) {
                        if (group == this.currentGroup) continue;
                        train.put(group, GroupedLeaveOneOutIterable.this.dataset.getInstances(group));
                    }
                    train.put(this.currentGroup, new ListBackedDataset((List)new SkippingListView(this.currentValues, new int[]{selectedIndex})));
                    HashMap valid = new HashMap();
                    valid.put(this.currentGroup, new ListBackedDataset((List)new AcceptingListView(this.currentValues, new int[]{selectedIndex})));
                    MapBackedDataset cvTrain = new MapBackedDataset(train);
                    MapBackedDataset cvValid = new MapBackedDataset(valid);
                    ++this.validationIndex;
                    return new DefaultValidationData<MapBackedDataset>(cvTrain, cvValid);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

