/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.trix;

import info.aduna.xml.XMLWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;

public class TriXWriter
implements RDFWriter {
    private XMLWriter xmlWriter;
    private boolean writingStarted;
    private boolean inActiveContext;
    private Resource currentContext;

    public TriXWriter(OutputStream out) {
        this(new XMLWriter(out));
    }

    public TriXWriter(Writer writer) {
        this(new XMLWriter(writer));
    }

    protected TriXWriter(XMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.xmlWriter.setPrettyPrint(true);
        this.writingStarted = false;
        this.inActiveContext = false;
        this.currentContext = null;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIX;
    }

    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RDFHandlerException("Document writing has already started");
        }
        try {
            this.xmlWriter.startDocument();
            this.xmlWriter.setAttribute("xmlns", "http://www.w3.org/2004/03/trix/trix-1/");
            this.xmlWriter.startTag("TriX");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = true;
        }
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RDFHandlerException("Document writing has not yet started");
        }
        try {
            if (this.inActiveContext) {
                this.xmlWriter.endTag("graph");
                this.inActiveContext = false;
                this.currentContext = null;
            }
            this.xmlWriter.endTag("TriX");
            this.xmlWriter.endDocument();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = false;
        }
    }

    public void handleNamespace(String prefix, String name) {
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RDFHandlerException("Document writing has not yet been started");
        }
        try {
            Resource context = st.getContext();
            if (this.inActiveContext && !TriXWriter.contextsEquals(context, this.currentContext)) {
                this.xmlWriter.endTag("graph");
                this.inActiveContext = false;
            }
            if (!this.inActiveContext) {
                this.xmlWriter.startTag("graph");
                if (context != null) {
                    this.writeValue((Value)context);
                }
                this.currentContext = context;
                this.inActiveContext = true;
            }
            this.xmlWriter.startTag("triple");
            this.writeValue((Value)st.getSubject());
            this.writeValue((Value)st.getPredicate());
            this.writeValue(st.getObject());
            this.xmlWriter.endTag("triple");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.xmlWriter.comment(comment);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeValue(Value value) throws IOException, RDFHandlerException {
        if (value instanceof URI) {
            URI uri = (URI)value;
            this.xmlWriter.textElement("uri", uri.toString());
        } else if (value instanceof BNode) {
            BNode bNode = (BNode)value;
            this.xmlWriter.textElement("id", bNode.getID());
        } else if (value instanceof Literal) {
            Literal literal = (Literal)value;
            URI datatype = literal.getDatatype();
            if (datatype != null) {
                this.xmlWriter.setAttribute("datatype", datatype.toString());
                this.xmlWriter.textElement("typedLiteral", literal.getLabel());
            } else {
                String language = literal.getLanguage();
                if (language != null) {
                    this.xmlWriter.setAttribute("xml:lang", language);
                }
                this.xmlWriter.textElement("plainLiteral", literal.getLabel());
            }
        } else {
            throw new RDFHandlerException("Unknown value type: " + value.getClass());
        }
    }

    private static final boolean contextsEquals(Resource context1, Resource context2) {
        if (context1 == null) {
            return context2 == null;
        }
        return context1.equals(context2);
    }
}

