/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import java.io.IOException;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.limited.LimitedSizeEvaluationStrategy;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.nativerdf.NativeStoreConnection;

public class LimitedSizeNativeStoreConnection
extends NativeStoreConnection {
    private int maxCollectionsSize = Integer.MAX_VALUE;

    protected LimitedSizeNativeStoreConnection(NativeStore nativeStore) throws IOException {
        super(nativeStore);
    }

    public int getMaxCollectionsSize() {
        return this.maxCollectionsSize;
    }

    public void setMaxCollectionsSize(int maxCollectionsSize) {
        this.maxCollectionsSize = maxCollectionsSize;
    }

    @Override
    protected EvaluationStrategy getEvaluationStrategy(Dataset dataset, TripleSource tripleSource) {
        return new LimitedSizeEvaluationStrategy(tripleSource, dataset, this.maxCollectionsSize, this.getFederatedServiceResolver());
    }
}

