/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.ReducedIteration;
import info.aduna.iteration.UnionIteration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.openrdf.IsolationLevel;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.BackingSailSource;
import org.openrdf.sail.base.SailDataset;
import org.openrdf.sail.base.SailSink;
import org.openrdf.sail.base.SailSource;
import org.openrdf.sail.base.SailStore;
import org.openrdf.sail.nativerdf.NamespaceStore;
import org.openrdf.sail.nativerdf.NativeEvaluationStatistics;
import org.openrdf.sail.nativerdf.NativeStatementIterator;
import org.openrdf.sail.nativerdf.TripleStore;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeSailStore
implements SailStore {
    final Logger logger = LoggerFactory.getLogger(NativeSailStore.class);
    final TripleStore tripleStore;
    final ValueStore valueStore;
    final NamespaceStore namespaceStore;
    final ReentrantLock txnLockManager = new ReentrantLock();

    public NativeSailStore(File dataDir, String tripleIndexes) throws IOException, SailException {
        this(dataDir, tripleIndexes, false, 512, 128, 64, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeSailStore(File dataDir, String tripleIndexes, boolean forceSync, int valueCacheSize, int valueIDCacheSize, int namespaceCacheSize, int namespaceIDCacheSize) throws IOException, SailException {
        boolean initialized = false;
        try {
            this.namespaceStore = new NamespaceStore(dataDir);
            this.valueStore = new ValueStore(dataDir, forceSync, valueCacheSize, valueIDCacheSize, namespaceCacheSize, namespaceIDCacheSize);
            this.tripleStore = new TripleStore(dataDir, tripleIndexes, forceSync);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.close();
            }
        }
    }

    public ValueFactory getValueFactory() {
        return this.valueStore;
    }

    public void close() {
        if (this.namespaceStore != null) {
            this.namespaceStore.close();
        }
        try {
            if (this.valueStore != null) {
                this.valueStore.close();
            }
            if (this.tripleStore != null) {
                this.tripleStore.close();
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to close store", (Throwable)e);
        }
    }

    public EvaluationStatistics getEvaluationStatistics() {
        return new NativeEvaluationStatistics(this.valueStore, this.tripleStore);
    }

    public SailSource getExplicitSailSource() {
        return new NativeSailSource(true);
    }

    public SailSource getInferredSailSource() {
        return new NativeSailSource(false);
    }

    List<Integer> getContextIDs(Resource ... contexts) throws IOException {
        assert (contexts.length > 0) : "contexts must not be empty";
        LinkedHashSet contextSet = new LinkedHashSet();
        Collections.addAll(contextSet, contexts);
        ArrayList<Integer> contextIDs = new ArrayList<Integer>(contextSet.size());
        for (Resource context : contextSet) {
            if (context == null) {
                contextIDs.add(0);
                continue;
            }
            int contextID = this.valueStore.getID((Value)context);
            if (contextID == -1) continue;
            contextIDs.add(contextID);
        }
        return contextIDs;
    }

    CloseableIteration<? extends Statement, SailException> createStatementIterator(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID((Value)subj)) == -1) {
            return new EmptyIteration();
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID((Value)pred)) == -1) {
            return new EmptyIteration();
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return new EmptyIteration();
        }
        ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
        if (contexts.length == 0) {
            contextIDList.add(-1);
        } else {
            for (Resource context : contexts) {
                if (context == null) {
                    contextIDList.add(0);
                    continue;
                }
                int contextID = this.valueStore.getID((Value)context);
                if (contextID == -1) continue;
                contextIDList.add(contextID);
            }
        }
        ArrayList<NativeStatementIterator> perContextIterList = new ArrayList<NativeStatementIterator>(contextIDList.size());
        Iterator iterator = contextIDList.iterator();
        while (iterator.hasNext()) {
            int contextID = (Integer)iterator.next();
            RecordIterator btreeIter = this.tripleStore.getTriples(subjID, predID, objID, contextID, explicit, false);
            perContextIterList.add(new NativeStatementIterator(btreeIter, this.valueStore));
        }
        if (perContextIterList.size() == 1) {
            return (CloseableIteration)perContextIterList.get(0);
        }
        return new UnionIteration(perContextIterList);
    }

    double cardinality(Resource subj, URI pred, Value obj, Resource context) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID((Value)subj)) == -1) {
            return 0.0;
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID((Value)pred)) == -1) {
            return 0.0;
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return 0.0;
        }
        int contextID = -1;
        if (context != null && (contextID = this.valueStore.getID((Value)context)) == -1) {
            return 0.0;
        }
        return this.tripleStore.cardinality(subjID, predID, objID, contextID);
    }

    private final class NativeSailDataset
    implements SailDataset {
        private final boolean explicit;

        public NativeSailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
        }

        public void close() {
        }

        public String getNamespace(String prefix) throws SailException {
            return NativeSailStore.this.namespaceStore.getNamespace(prefix);
        }

        public CloseableIteration<? extends Namespace, SailException> getNamespaces() {
            return new CloseableIteratorIteration(NativeSailStore.this.namespaceStore.iterator());
        }

        public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
            try {
                RecordIterator btreeIter = NativeSailStore.this.tripleStore.getAllTriplesSortedByContext(false);
                Object stIter = btreeIter == null ? NativeSailStore.this.createStatementIterator(null, null, null, this.explicit, new Resource[0]) : new CloseableIteration<Statement, SailException>(btreeIter, NativeSailStore.this.valueStore);
                stIter = new FilterIteration<Statement, SailException>(stIter){

                    protected boolean accept(Statement st) {
                        return st.getContext() != null;
                    }
                };
                Object ctxIter = new ConvertingIteration<Statement, Resource, SailException>(stIter){

                    protected Resource convert(Statement st) {
                        return st.getContext();
                    }
                };
                ctxIter = btreeIter == null ? new DistinctIteration((Iteration)ctxIter) : new ReducedIteration((Iteration)ctxIter);
                return new ExceptionConvertingIteration<Resource, SailException>((Iteration)ctxIter){

                    protected SailException convert(Exception e) {
                        if (e instanceof IOException) {
                            return new SailException((Throwable)e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (e == null) {
                            throw new IllegalArgumentException("e must not be null");
                        }
                        throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                    }
                };
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
        }

        public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
            try {
                return NativeSailStore.this.createStatementIterator(subj, pred, obj, this.explicit, contexts);
            }
            catch (IOException e) {
                throw new SailException("Unable to get statements", (Throwable)e);
            }
        }
    }

    private final class NativeSailSink
    implements SailSink {
        private boolean explicit;
        private volatile boolean txnLockAcquired;

        public NativeSailSink(boolean explicit) throws SailException {
            this.explicit = explicit;
        }

        public synchronized void close() {
            if (this.txnLockAcquired) {
                NativeSailStore.this.txnLockManager.unlock();
                this.txnLockAcquired = false;
            }
        }

        public void prepare() throws SailException {
        }

        public void flush() throws SailException {
            if (this.txnLockAcquired && NativeSailStore.this.txnLockManager.getHoldCount() == 1) {
                try {
                    NativeSailStore.this.valueStore.sync();
                    NativeSailStore.this.namespaceStore.sync();
                    NativeSailStore.this.tripleStore.commit();
                }
                catch (IOException e) {
                    NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                }
                catch (RuntimeException e) {
                    NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                    throw e;
                }
            }
        }

        public void setNamespace(String prefix, String name) throws SailException {
            this.acquireExclusiveTransactionLock();
            NativeSailStore.this.namespaceStore.setNamespace(prefix, name);
        }

        public void removeNamespace(String prefix) throws SailException {
            this.acquireExclusiveTransactionLock();
            NativeSailStore.this.namespaceStore.removeNamespace(prefix);
        }

        public void clearNamespaces() throws SailException {
            this.acquireExclusiveTransactionLock();
            NativeSailStore.this.namespaceStore.clear();
        }

        public void observe(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        }

        public void clear(Resource ... contexts) throws SailException {
            this.removeStatements(null, null, null, this.explicit, contexts);
        }

        public void approve(Resource subj, URI pred, Value obj, Resource ctx) throws SailException {
            this.addStatement(subj, pred, obj, this.explicit, ctx);
        }

        public void deprecate(Resource subj, URI pred, Value obj, Resource ctx) throws SailException {
            this.removeStatements(subj, pred, obj, this.explicit, ctx);
        }

        private synchronized void acquireExclusiveTransactionLock() throws SailException {
            if (!this.txnLockAcquired) {
                NativeSailStore.this.txnLockManager.lock();
                try {
                    if (NativeSailStore.this.txnLockManager.getHoldCount() == 1) {
                        NativeSailStore.this.tripleStore.startTransaction();
                    }
                    this.txnLockAcquired = true;
                }
                catch (IOException e) {
                    throw new SailException((Throwable)e);
                }
                finally {
                    if (!this.txnLockAcquired) {
                        NativeSailStore.this.txnLockManager.unlock();
                    }
                }
            }
        }

        private boolean addStatement(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
            this.acquireExclusiveTransactionLock();
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            boolean result = false;
            try {
                int subjID = NativeSailStore.this.valueStore.storeValue((Value)subj);
                int predID = NativeSailStore.this.valueStore.storeValue((Value)pred);
                int objID = NativeSailStore.this.valueStore.storeValue(obj);
                if (contexts.length == 0) {
                    contexts = new Resource[]{null};
                }
                for (Resource context : contexts) {
                    int contextID = 0;
                    if (context != null) {
                        contextID = NativeSailStore.this.valueStore.storeValue((Value)context);
                    }
                    boolean wasNew = NativeSailStore.this.tripleStore.storeTriple(subjID, predID, objID, contextID, explicit);
                    result |= wasNew;
                }
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to add a statement", (Throwable)e);
                throw e;
            }
            return result;
        }

        private int removeStatements(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
            this.acquireExclusiveTransactionLock();
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            try {
                int subjID = -1;
                if (subj != null && (subjID = NativeSailStore.this.valueStore.getID((Value)subj)) == -1) {
                    return 0;
                }
                int predID = -1;
                if (pred != null && (predID = NativeSailStore.this.valueStore.getID((Value)pred)) == -1) {
                    return 0;
                }
                int objID = -1;
                if (obj != null && (objID = NativeSailStore.this.valueStore.getID(obj)) == -1) {
                    return 0;
                }
                ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
                if (contexts.length == 0) {
                    contextIDList.add(-1);
                } else {
                    for (Resource context : contexts) {
                        if (context == null) {
                            contextIDList.add(0);
                            continue;
                        }
                        int contextID = NativeSailStore.this.valueStore.getID((Value)context);
                        if (contextID == -1) continue;
                        contextIDList.add(contextID);
                    }
                }
                int removeCount = 0;
                for (int i = 0; i < contextIDList.size(); ++i) {
                    int contextID = (Integer)contextIDList.get(i);
                    removeCount += NativeSailStore.this.tripleStore.removeTriples(subjID, predID, objID, contextID, explicit);
                }
                return removeCount;
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to remove statements", (Throwable)e);
                throw e;
            }
        }
    }

    private final class NativeSailSource
    extends BackingSailSource {
        private final boolean explicit;

        public NativeSailSource(boolean explicit) {
            this.explicit = explicit;
        }

        public SailSource fork() {
            throw new UnsupportedOperationException("This store does not support multiple datasets");
        }

        public SailSink sink(IsolationLevel level) throws SailException {
            return new NativeSailSink(this.explicit);
        }

        public NativeSailDataset dataset(IsolationLevel level) throws SailException {
            return new NativeSailDataset(this.explicit);
        }
    }
}

