/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.concurrent.locks.Lock;
import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailException;
import org.openrdf.sail.SailReadOnlyException;
import org.openrdf.sail.base.SailSourceConnection;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.nativerdf.NativeStore;

public class NativeStoreConnection
extends SailSourceConnection {
    protected final NativeStore nativeStore;
    private volatile DefaultSailChangedEvent sailChangedEvent;
    private volatile Lock txnLock;

    protected NativeStoreConnection(NativeStore sail) throws IOException {
        super((SailBase)sail, sail.getSailStore(), sail.getFederatedServiceResolver());
        this.nativeStore = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)sail);
    }

    protected void startTransactionInternal() throws SailException {
        if (!this.nativeStore.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        boolean releaseLock = true;
        try {
            if (this.txnLock == null || !this.txnLock.isActive()) {
                this.txnLock = this.nativeStore.getTransactionLock(this.getTransactionIsolation());
            }
            super.startTransactionInternal();
        }
        finally {
            if (releaseLock && this.txnLock != null) {
                this.txnLock.release();
            }
        }
    }

    protected void commitInternal() throws SailException {
        try {
            super.commitInternal();
        }
        finally {
            if (this.txnLock != null) {
                this.txnLock.release();
            }
        }
        this.nativeStore.notifySailChanged((SailChangedEvent)this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.nativeStore);
    }

    protected void rollbackInternal() throws SailException {
        try {
            super.rollbackInternal();
        }
        finally {
            if (this.txnLock != null) {
                this.txnLock.release();
            }
        }
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.nativeStore);
    }

    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
    }

    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        return ret;
    }

    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    protected EvaluationStrategy getEvaluationStrategy(Dataset dataset, TripleSource tripleSource) {
        return new EvaluationStrategyImpl(tripleSource, dataset, this.getFederatedServiceResolver(), this.nativeStore.getIterationCacheSyncThreshold());
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }
}

