/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins.github;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.openrewrite.jenkins.github.TeamNameGenerator;
import org.openrewrite.jenkins.github.TeamNameInput;

class ArtifactIdTeamNameGenerator
implements TeamNameGenerator<TeamNameInput> {
    private static final String EXCLUDE = "EXCLUDE";
    private static final String ORG = "@jenkinsci/";
    private final Map<String, String> artifactIdAdvice = ArtifactIdTeamNameGenerator.loadAdvice();

    ArtifactIdTeamNameGenerator() {
    }

    @Override
    public String generate(TeamNameInput input) {
        String artifactId = input.getArtifactId();
        String advice = this.artifactIdAdvice.get(artifactId);
        if (EXCLUDE.equalsIgnoreCase(advice)) {
            return "";
        }
        if (advice != null) {
            return ORG + advice;
        }
        String withoutParent = artifactId;
        if (artifactId.endsWith("-parent") || artifactId.endsWith("-plugin")) {
            withoutParent = artifactId.substring(0, artifactId.lastIndexOf(45));
        }
        return (ORG + withoutParent + "-plugin-developers").toLowerCase(Locale.ROOT);
    }

    private static Map<String, String> loadAdvice() {
        HashMap<String, String> hashMap;
        block9: {
            Properties p = new Properties();
            InputStream is = ArtifactIdTeamNameGenerator.class.getResourceAsStream("teams.properties");
            try {
                HashMap<String, String> o = new HashMap<String, String>();
                p.load(is);
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    o.put((String)entry.getKey(), (String)entry.getValue());
                }
                hashMap = o;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return hashMap;
    }
}

