/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class AddJellyXmlDeclaration
extends Recipe {
    private static final String JELLY_DECLARATION = "<?jelly escape-by-default='true'?>";

    public String getDisplayName() {
        return "Add XML declaration to Jelly files";
    }

    public String getDescription() {
        return "Ensure the XML declaration `<?jelly escape-by-default='true'?>` is present in all `.jelly` files.";
    }

    public PlainTextVisitor<ExecutionContext> getVisitor() {
        return new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                if (text.getSourcePath().toString().endsWith(".jelly")) {
                    String lineEnding;
                    String content = text.getText().trim();
                    if (content.isEmpty()) {
                        return text.withText(AddJellyXmlDeclaration.JELLY_DECLARATION);
                    }
                    String string = lineEnding = content.contains("\r\n") ? "\r\n" : "\n";
                    if (content.toLowerCase().matches("^<\\?jelly\\s+[^>]*>") && !content.startsWith(AddJellyXmlDeclaration.JELLY_DECLARATION)) {
                        content = content.substring(content.indexOf(lineEnding) + lineEnding.length());
                    }
                    if (!content.startsWith(AddJellyXmlDeclaration.JELLY_DECLARATION)) {
                        content = AddJellyXmlDeclaration.JELLY_DECLARATION + lineEnding + content;
                        return text.withText(content);
                    }
                }
                return text;
            }
        };
    }
}

