/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class UpdateBeanManagerMethods
extends Recipe {
    public String getDisplayName() {
        return "Update `fireEvent()` and `createInjectionTarget()` calls";
    }

    public String getDescription() {
        return " Updates `BeanManager.fireEvent()` or `BeanManager.createInjectionTarget()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher fireEventMatcher = new MethodMatcher("*.enterprise.inject.spi.BeanManager fireEvent(..)", false);
            private final MethodMatcher createInjectionTargetMatcher = new MethodMatcher("*.enterprise.inject.spi.BeanManager createInjectionTarget(..)", false);

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (this.fireEventMatcher.matches((MethodCall)method)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(jakarta.enterprise.inject.spi.BeanManager)}.getEvent().fire(#{any(jakarta.enterprise.inject.spi.BeforeBeanDiscovery)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.enterprise.cdi-api-3.0.0-M4"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getSelect(), mi.getArguments().get(0)});
                }
                if (this.createInjectionTargetMatcher.matches((MethodCall)method)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(jakarta.enterprise.inject.spi.BeanManager)}.getInjectionTargetFactory(#{any(jakarta.enterprise.inject.spi.AnnotatedType)}).createInjectionTarget(null)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.enterprise.cdi-api-3.0.0-M4"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getSelect(), mi.getArguments().get(0)});
                }
                return mi;
            }
        };
    }
}

