/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class ScopeAwareVisitor
extends JavaVisitor<ExecutionContext> {
    protected final LinkedList<VariablesInScope> scopes;

    public J preVisit(J j, ExecutionContext ctx) {
        if (j instanceof J.Block) {
            this.scopes.push(new VariablesInScope(this.getCursor()));
        }
        if (j instanceof J.MethodDeclaration) {
            this.scopes.push(new VariablesInScope(this.getCursor()));
        }
        if (j instanceof J.VariableDeclarations.NamedVariable) {
            assert (!this.scopes.isEmpty());
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)j;
            this.scopes.peek().variables.add(variable);
        }
        return (J)super.preVisit((Tree)j, (Object)ctx);
    }

    public J postVisit(J j, ExecutionContext ctx) {
        if (j instanceof J.Block) {
            this.scopes.pop();
        }
        return (J)super.postVisit((Tree)j, (Object)ctx);
    }

    Cursor findScope(J.VariableDeclarations.NamedVariable variable) {
        for (VariablesInScope scope : this.scopes) {
            if (!scope.variables.contains(variable)) continue;
            return scope.scope;
        }
        return null;
    }

    Optional<J.VariableDeclarations.NamedVariable> findVarInScope(String varName) {
        for (VariablesInScope scope : this.scopes) {
            for (J.VariableDeclarations.NamedVariable var : scope.variables) {
                if (!var.getSimpleName().equals(varName)) continue;
                return Optional.of(var);
            }
        }
        return Optional.empty();
    }

    Cursor getCurrentScope() {
        assert (!this.scopes.isEmpty());
        return this.scopes.peek().scope;
    }

    @ConstructorProperties(value={"scopes"})
    @Generated
    public ScopeAwareVisitor(LinkedList<VariablesInScope> scopes) {
        this.scopes = scopes;
    }

    public static final class VariablesInScope {
        private final Cursor scope;
        private final Set<J.VariableDeclarations.NamedVariable> variables;

        public VariablesInScope(Cursor scope) {
            this.scope = scope;
            this.variables = new HashSet<J.VariableDeclarations.NamedVariable>();
        }

        @Generated
        public Cursor getScope() {
            return this.scope;
        }

        @Generated
        public Set<J.VariableDeclarations.NamedVariable> getVariables() {
            return this.variables;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariablesInScope)) {
                return false;
            }
            VariablesInScope other = (VariablesInScope)o;
            Cursor this$scope = this.getScope();
            Cursor other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            Set<J.VariableDeclarations.NamedVariable> this$variables = this.getVariables();
            Set<J.VariableDeclarations.NamedVariable> other$variables = other.getVariables();
            return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Cursor $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            Set<J.VariableDeclarations.NamedVariable> $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ScopeAwareVisitor.VariablesInScope(scope=" + this.getScope() + ", variables=" + this.getVariables() + ")";
        }
    }
}

